/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.DealType;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IDealTypeManager;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IDealTypeManager.class})
@Stateless
public class DealTypeManager
implements IDealTypeManager {
    private static final Log log = LogFactory.getLog(DealTypeManager.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(DealType transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting DealType instance");
        try {
            this.isExists(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public boolean remove(DealType persistentInstance) {
        log.debug((Object)"removing DealType instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
        return true;
    }

    public DealType merge(DealType detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging DealType instance");
        try {
            this.isExists(detachedInstance);
            DealType result = (DealType)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public DealType findById(long id) {
        log.debug((Object)("getting DealType instance with id: " + id));
        try {
            DealType instance = (DealType)this.entityManager.find(DealType.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<DealType> getAllDealTypes() {
        try {
            Query query = this.entityManager.createQuery("SELECT type from DealType type");
            log.debug((Object)"get successful");
            return query.getResultList();
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    private void isExists(DealType transientInstance) throws ContractManagerValidationException {
        DealType existing = this.findByName(transientInstance.getType());
        if (existing != null && (transientInstance.getIdType() == null || existing.getIdType().longValue() != transientInstance.getIdType().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Deal Type already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public DealType findByName(String type) {
        try {
            Query query = this.entityManager.createQuery("SELECT type from DealType type WHERE type.type = :type");
            query.setParameter("type", (Object)type);
            log.debug((Object)"get successful");
            try {
                return (DealType)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

