/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.cms.contractmgmt.validation.FieldValidator;
import com.ericsson.ejb.Field;
import com.ericsson.enumeration.FieldType;
import com.ericsson.enumeration.ScreenName;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.ICurrencyManager;
import com.ericsson.service.IFieldManager;
import com.ericsson.service.IFrequencyManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IFieldManager.class})
@Stateless
public class FieldManager
implements IFieldManager {
    private static final Log log = LogFactory.getLog(FieldManager.class);
    private ICurrencyManager currencyManager;
    private IFrequencyManager frequencyManager;
    private ConcurrentHashMap<String, List<Field>> fieldCache = new ConcurrentHashMap();
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public synchronized ICurrencyManager getCurrencyManager() {
        if (this.currencyManager == null) {
            this.currencyManager = (ICurrencyManager)InjectionUtil.injectInstance((String)"cms/CurrencyManager/local", ICurrencyManager.class);
        }
        return this.currencyManager;
    }

    public void setCurrencyManager(ICurrencyManager currencyManager) {
        this.currencyManager = currencyManager;
    }

    public synchronized IFrequencyManager getFrequencyManager() {
        if (this.frequencyManager == null) {
            this.frequencyManager = (IFrequencyManager)InjectionUtil.injectInstance((String)"cms/FrequencyManager/local", IFrequencyManager.class);
        }
        return this.frequencyManager;
    }

    public void setFrequencyManager(IFrequencyManager frequencyManager) {
        this.frequencyManager = frequencyManager;
    }

    public void persist(Field transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting Field instance");
        this.validate(transientInstance);
        this.isExists(transientInstance);
        this.entityManager.persist((Object)transientInstance);
        log.debug((Object)"persist successful");
        this.reloadCache();
    }

    public void remove(Field persistentInstance) {
        log.debug((Object)"removing Field instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
            this.reloadCache();
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public Field merge(Field detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging Field instance");
        this.validate(detachedInstance);
        this.isExists(detachedInstance);
        Field result = (Field)this.entityManager.merge((Object)detachedInstance);
        log.debug((Object)"merge successful");
        this.reloadCache();
        return result;
    }

    public Field findById(long id) {
        log.debug((Object)("getting Field instance with id: " + id));
        try {
            Field instance = (Field)this.entityManager.find(Field.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public synchronized List<Field> findByScreenName(ScreenName name, String sortProperty, boolean isAscending) {
        log.debug((Object)("getting Field instance for screen_name = " + name));
        String key = name.toString() + sortProperty + isAscending;
        List result = this.fieldCache.get(key);
        if (result == null) {
            Query query = this.entityManager.createQuery("SELECT field from Field field WHERE field.screenName = :screenName ORDER BY field." + sortProperty + " " + (isAscending ? "asc" : "desc"));
            query.setParameter("screenName", (Object)name);
            result = query.getResultList();
            log.debug((Object)"get successful");
            if (result != null) {
                this.fieldCache.put(key, result);
            }
        }
        return result != null ? new ArrayList<Field>(result) : null;
    }

    public List<Field> findByTypeAndValue(FieldType type, String value) {
        try {
            log.debug((Object)("getting Field instance for type = " + type));
            Query query = this.entityManager.createQuery("SELECT distinct field from Field field LEFT JOIN FETCH field.customLicFieldValues cust WHERE field.type = :type AND (field.defaultValue = :value OR cust.value = :value)");
            query.setParameter("type", (Object)type);
            query.setParameter("value", (Object)value);
            List fields = query.getResultList();
            log.debug((Object)"get successful");
            return fields;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    private void isExists(Field transientInstance) throws ContractManagerValidationException {
        Field existing = this.findByNameAndScreen(transientInstance.getName(), transientInstance.getScreenName());
        if (existing != null && (transientInstance.getIdField() == null || existing.getIdField().longValue() != transientInstance.getIdField().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Field already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public boolean exists(Field transientInstance) {
        Field field = this.findByNameAndScreen(transientInstance.getName(), transientInstance.getScreenName());
        return field != null;
    }

    public Field findByNameAndScreen(String name, ScreenName screenName) {
        try {
            Query query = this.entityManager.createQuery("SELECT field from Field field WHERE field.name = :name and field.screenName = :screenName");
            query.setParameter("screenName", (Object)screenName);
            query.setParameter("name", (Object)name);
            log.debug((Object)"get successful");
            try {
                return (Field)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    private void validate(Field field) throws ContractManagerValidationException {
        log.debug((Object)"Field Manager valiate started");
        FieldValidator validator = new FieldValidator(this.getCurrencyManager(), this.getFrequencyManager());
        validator.validate(field);
        log.debug((Object)"Field Manager valiate exited");
    }

    private void reloadCache() {
        this.fieldCache.clear();
    }
}

