/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.Platform;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IPlatformManager;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IPlatformManager.class})
@Stateless
public class PlatformManager
implements IPlatformManager {
    private static final Log log = LogFactory.getLog(PlatformManager.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(Platform transientInstance) throws ContractManagerValidationException {
        log.debug((Object)"persisting Platform instance");
        try {
            this.isExists(transientInstance);
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(Platform persistentInstance) {
        log.debug((Object)"removing Platform instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public Platform merge(Platform detachedInstance) throws ContractManagerValidationException {
        log.debug((Object)"merging Platform instance");
        try {
            this.isExists(detachedInstance);
            Platform result = (Platform)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public Platform findById(long id) {
        log.debug((Object)("getting Platform instance with id: " + id));
        try {
            Platform instance = (Platform)this.entityManager.find(Platform.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<Platform> getAllPlatforms() {
        try {
            Query query = this.entityManager.createQuery("SELECT platform from Platform platform");
            List platforms = query.getResultList();
            log.debug((Object)"get successful");
            return platforms;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<Platform> getPlatforms(int start, int length, String sortProperty, boolean isAscending) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("platform", Platform.class, "platform");
        SortingOrder sortOrder = SortingOrder.ASCENDING;
        if (!isAscending) {
            sortOrder = SortingOrder.DESCENDING;
        }
        sortProperty = sortProperty.equalsIgnoreCase("name") ? "description" : sortProperty;
        e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
        criteria.addParameter((SearchParameterBase)e);
        criteria.setStartingRecordNumber(start);
        criteria.setRecordsCount(length);
        String s = this.getQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        query.setFirstResult(start);
        query.setMaxResults(criteria.getRecordsCount() == 0 ? Integer.MAX_VALUE : criteria.getRecordsCount());
        List platforms = query.getResultList();
        log.debug((Object)"get successful");
        return platforms;
    }

    private String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    public int count() {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("platform", Platform.class, "platform");
        criteria.addParameter((SearchParameterBase)e);
        String s = QueryBuilder.newInstance().buildCountQuery(criteria);
        Query query = this.entityManager.createQuery(s);
        long count = (Long)query.getSingleResult();
        return (int)count;
    }

    private void isExists(Platform transientInstance) throws ContractManagerValidationException {
        Platform existing = this.findByName(transientInstance.getDescription());
        if (existing != null && (transientInstance.getIdPlatform() == null || existing.getIdPlatform().longValue() != transientInstance.getIdPlatform().longValue())) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            validationErrors.add("Platform already exists!");
            throw new ContractManagerValidationException(validationErrors);
        }
    }

    public Platform findByName(String name) {
        try {
            Query query = this.entityManager.createQuery("SELECT platform from Platform platform WHERE platform.description = :name");
            query.setParameter("name", (Object)name);
            log.debug((Object)"get successful");
            try {
                return (Platform)query.getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

