/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.entitymanager;

import com.ericsson.ejb.License;
import com.ericsson.ejb.LicenseDetails;
import com.ericsson.ejb.SmAssets;
import com.ericsson.ejb.SmAssetsId;
import com.ericsson.service.ISmAssetsManager;
import java.util.Calendar;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={ISmAssetsManager.class})
@Stateless
public class SmAssetsManager
implements ISmAssetsManager {
    private static final Log log = LogFactory.getLog(SmAssetsManager.class);
    @PersistenceContext(unitName="ContractManagerRealm")
    private EntityManager entityManager;

    public void persist(SmAssets transientInstance) {
        log.debug((Object)"persisting SmAssets instance");
        try {
            this.entityManager.persist((Object)transientInstance);
            log.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void remove(SmAssets persistentInstance) {
        log.debug((Object)"removing SmAssets instance");
        try {
            this.entityManager.remove((Object)persistentInstance);
            log.debug((Object)"remove successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"remove failed", (Throwable)re);
            throw re;
        }
    }

    public SmAssets merge(SmAssets detachedInstance) {
        log.debug((Object)"merging SmAssets instance");
        try {
            SmAssets result = (SmAssets)this.entityManager.merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public SmAssets findById(SmAssetsId id) {
        log.debug((Object)("getting SmAssets instance with id: " + id));
        try {
            SmAssets instance = (SmAssets)this.entityManager.find(SmAssets.class, (Object)id);
            log.debug((Object)"get successful");
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public License getLicenseByAssetId(long assetId) {
        try {
            Query query = this.entityManager.createQuery("SELECT assets from SmAssets assets WHERE assets.id.idAsset = " + assetId);
            log.debug((Object)"get successful");
            List list = query.getResultList();
            License license = null;
            if (list == null || list.size() > 1) {
                license = null;
                if (list.size() > 1) {
                    log.warn((Object)("Title [" + assetId + "] is associated with more than one license."));
                }
            } else {
                for (SmAssets asset : list) {
                    if (asset.getId().getIdAsset() == null || assetId != new Long(asset.getId().getIdAsset()) || !asset.getLicense().getActive().booleanValue() || !asset.getLicense().getExpiryDate().after(Calendar.getInstance().getTime())) continue;
                    license = asset.getLicense();
                }
            }
            return license;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public License getLicenseByAssetIdSiteId(long assetId, long siteId) {
        try {
            Query query = this.entityManager.createQuery("SELECT assets from SmAssets assets WHERE assets.id.idAsset = " + assetId);
            log.debug((Object)"get successful");
            List list = query.getResultList();
            License license = null;
            if (list == null || list.size() > 1) {
                license = null;
                if (list.size() > 1) {
                    log.warn((Object)("Title [" + assetId + "] is associated with more than one license."));
                }
            } else {
                for (SmAssets asset : list) {
                    if (asset.getLicense().getLicenseDetails() == null) continue;
                    for (LicenseDetails details : asset.getLicense().getLicenseDetails()) {
                        if (details.getDeliveryLocationId() == null || details.getDeliveryLocationId() != siteId || asset.getId().getIdAsset() == null || assetId != new Long(asset.getId().getIdAsset()) || !asset.getLicense().getActive().booleanValue() || !asset.getLicense().getExpiryDate().after(Calendar.getInstance().getTime())) continue;
                        license = asset.getLicense();
                    }
                }
            }
            return license;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List<SmAssets> getAssociatedAssetsList(long assetId) {
        try {
            Query query = this.entityManager.createQuery("SELECT assets from SmAssets assets WHERE assets.id.idAsset = " + assetId);
            List list = query.getResultList();
            log.debug((Object)"get successful");
            return list;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public void disAssociateAsset(long assetId) {
        List<SmAssets> assets = this.getAssociatedAssetsList(assetId);
        for (SmAssets title : assets) {
            this.remove(title);
        }
    }
}

