/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.extended.impl;

import com.ericsson.ejb.Currency;
import com.ericsson.ejb.Field;
import com.ericsson.ejb.FieldDropdown;
import com.ericsson.ejb.Frequency;
import com.ericsson.ejb.License;
import com.ericsson.enumeration.FieldIdentifier;
import com.ericsson.enumeration.ScreenName;
import com.ericsson.extended_interface.IRulesLicensingField;
import com.ericsson.extended_interface.IRulesLicensingProvider;
import com.ericsson.extended_interface.LicenseKeyName;
import com.ericsson.extended_interface.impl.RulesLicenseWrapper;
import com.ericsson.extended_interface.impl.RulesLicensingField;
import com.ericsson.extended_interface.impl.RulesLicensingFieldOption;
import com.ericsson.service.ICMLicenseManager;
import com.ericsson.service.ICurrencyManager;
import com.ericsson.service.IFieldManager;
import com.ericsson.service.IFrequencyManager;
import com.ericsson.service.ISmAssetsManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IRulesLicensingProvider.class})
@Stateless
public class RulesLicensingProvider
implements IRulesLicensingProvider {
    private static final Log log = LogFactory.getLog(RulesLicensingProvider.class);
    @EJB
    private ISmAssetsManager assetsManager;
    @EJB
    private ICMLicenseManager licenseManager;
    @EJB
    private IFieldManager fieldManager;
    @EJB
    private ICurrencyManager currencyManager;
    @EJB
    private IFrequencyManager frequencyManager;
    private Set<FieldDropdown> dropDownFieldSet = new HashSet<FieldDropdown>();

    private LicenseKeyName createKeyName(Long key, String name) {
        LicenseKeyName licenseKeyName = new LicenseKeyName();
        licenseKeyName.setLicenseId(key);
        licenseKeyName.setName(name);
        return licenseKeyName;
    }

    public List<LicenseKeyName> getAllLicenses() {
        List licenseList = this.licenseManager.getAllLicenses();
        ArrayList<LicenseKeyName> returnList = new ArrayList<LicenseKeyName>(0);
        for (License license : licenseList) {
            LicenseKeyName licenseKeyName = this.createKeyName(license.getIdLicense(), license.getName());
            returnList.add(licenseKeyName);
        }
        return returnList;
    }

    public List<RulesLicensingField> getFields() {
        List<RulesLicensingField> list = this.getRegularFields();
        if (list != null) {
            list.addAll(this.buildCustomFieldList());
            return list;
        }
        return new ArrayList<RulesLicensingField>(0);
    }

    public RulesLicenseWrapper getLicense(long titleId, long siteId) {
        RulesLicenseWrapper wrapper = null;
        License license = this.assetsManager.getLicenseByAssetIdSiteId(titleId, siteId);
        if (license != null) {
            License fullLicense = this.licenseManager.getFullLicense(license.getIdLicense());
            wrapper = new RulesLicenseWrapper(fullLicense, Long.valueOf(siteId), this.buildCustomFieldList(), this.frequencyManager.getAllFrequencies(), this.currencyManager.getAllCurrencies());
        }
        return wrapper;
    }

    public RulesLicenseWrapper getLicense(long titleId) {
        RulesLicenseWrapper wrapper = null;
        License license = this.assetsManager.getLicenseByAssetId(titleId);
        if (license != null) {
            License fullLicense = this.licenseManager.getFullLicense(license.getIdLicense());
            wrapper = new RulesLicenseWrapper(fullLicense, null, this.buildCustomFieldList(), this.frequencyManager.getAllFrequencies(), this.currencyManager.getAllCurrencies());
        }
        return wrapper;
    }

    private List<RulesLicensingField> buildCustomFieldList() {
        long startTime = System.currentTimeMillis();
        ArrayList<RulesLicensingField> customFieldList = new ArrayList<RulesLicensingField>(0);
        List fieldLicenseList = this.fieldManager.findByScreenName(ScreenName.LICENSE, "fieldOrder", true);
        List fieldStorageList = this.fieldManager.findByScreenName(ScreenName.STORAGE_METADATA, "fieldOrder", true);
        List fieldAssetList = this.fieldManager.findByScreenName(ScreenName.ASSET_ENHANCEMENT, "fieldOrder", true);
        List fieldDistributionList = this.fieldManager.findByScreenName(ScreenName.DISTRIBUTION, "fieldOrder", true);
        if (fieldLicenseList != null && !fieldLicenseList.isEmpty()) {
            customFieldList.addAll(this.createRulesLicensingList(fieldLicenseList, ScreenName.LICENSE));
        }
        if (fieldStorageList != null && !fieldStorageList.isEmpty()) {
            customFieldList.addAll(this.createRulesLicensingList(fieldStorageList, ScreenName.STORAGE_METADATA));
        }
        if (fieldDistributionList != null && !fieldDistributionList.isEmpty()) {
            customFieldList.addAll(this.createRulesLicensingList(fieldDistributionList, ScreenName.DISTRIBUTION));
        }
        if (fieldAssetList != null && !fieldAssetList.isEmpty()) {
            customFieldList.addAll(this.createRulesLicensingList(fieldAssetList, ScreenName.ASSET_ENHANCEMENT));
        }
        long stopTime = System.currentTimeMillis();
        log.debug((Object)("buildCustomFieldList took time totally: " + (stopTime - startTime) + "ms"));
        return customFieldList;
    }

    private List<RulesLicensingField> createRulesLicensingList(List<Field> fieldList, ScreenName screenName) {
        ArrayList<RulesLicensingField> list = new ArrayList<RulesLicensingField>(0);
        for (Field field : fieldList) {
            RulesLicensingField rlField = this.createRulesLicensingField(field, screenName);
            list.add(rlField);
        }
        return list;
    }

    private RulesLicensingField createRulesLicensingField(Field field, ScreenName screenName) {
        String displayName = this.createCustomFieldDisplayName(screenName, field);
        String identifier = this.createCustomFieldIdentifier(screenName, field);
        IRulesLicensingField.DataType dataType = this.createCustomFieldDataType(field);
        List<RulesLicensingFieldOption<?>> optionList = this.createOptionList(screenName, field);
        RulesLicensingField rlField = new RulesLicensingField(displayName, dataType, identifier, optionList);
        return rlField;
    }

    private List<RulesLicensingFieldOption<?>> createOptionList(ScreenName screenName, Field field) {
        this.dropDownFieldSet = field.getFieldDropdowns();
        ArrayList optionList = new ArrayList();
        switch (field.getType()) {
            case Frequency: {
                List allFrequencies = this.frequencyManager.getAllFrequencies();
                for (Frequency freq : allFrequencies) {
                    RulesLicensingFieldOption rlfo = new RulesLicensingFieldOption((Object)freq.getDescription(), freq.getDescription());
                    optionList.add(rlfo);
                }
                return optionList;
            }
            case Currency: {
                List allCurrencies = this.currencyManager.getAllCurrencies();
                for (Currency cur : allCurrencies) {
                    RulesLicensingFieldOption rlfo = new RulesLicensingFieldOption((Object)cur.getNameAndSymbol(), cur.getNameAndSymbol());
                    optionList.add(rlfo);
                }
                return optionList;
            }
        }
        for (FieldDropdown dropDown : this.dropDownFieldSet) {
            RulesLicensingFieldOption rlfo = new RulesLicensingFieldOption((Object)dropDown.getValue(), dropDown.getValue());
            optionList.add(rlfo);
        }
        return optionList;
    }

    private String createCustomFieldDisplayName(ScreenName screenName, Field field) {
        StringBuilder sb = new StringBuilder();
        switch (screenName) {
            case LICENSE: {
                sb.append("License/").append(field.getName());
                break;
            }
            case STORAGE_METADATA: {
                sb.append("Storage and Metadata Management/").append(field.getName());
                break;
            }
            case ASSET_ENHANCEMENT: {
                sb.append("Asset Enhancement Management/").append(field.getName());
                break;
            }
            case DISTRIBUTION: {
                sb.append("Distribution Management/").append(field.getName());
            }
        }
        return sb.toString();
    }

    private String createCustomFieldIdentifier(ScreenName screenName, Field field) {
        StringBuilder sb = new StringBuilder();
        switch (screenName) {
            case LICENSE: {
                sb.append("License/").append(field.getIdField());
                break;
            }
            case STORAGE_METADATA: {
                sb.append("Storage and Metadata Management/").append(field.getIdField());
                break;
            }
            case ASSET_ENHANCEMENT: {
                sb.append("Asset Enhancement Management/").append(field.getIdField());
                break;
            }
            case DISTRIBUTION: {
                sb.append("Distribution Management/").append(field.getIdField());
            }
        }
        return sb.toString();
    }

    private IRulesLicensingField.DataType createCustomFieldDataType(Field field) {
        switch (field.getType()) {
            case Date: {
                return IRulesLicensingField.DataType.DATE;
            }
            case Percentage: {
                return IRulesLicensingField.DataType.FLOAT;
            }
            case Number: {
                return IRulesLicensingField.DataType.LONG;
            }
        }
        return IRulesLicensingField.DataType.STRING;
    }

    private List<RulesLicensingField> getRegularFields() {
        ArrayList<RulesLicensingField> list = new ArrayList<RulesLicensingField>(0);
        RulesLicensingField field = null;
        block8: for (FieldIdentifier identifier : FieldIdentifier.values()) {
            switch (identifier) {
                case LICENSE_ID: {
                    field = new RulesLicensingField(identifier.getDisplayName(), IRulesLicensingField.DataType.LONG, FieldIdentifier.LICENSE_ID.getDisplayName(), new ArrayList());
                    list.add(field);
                    continue block8;
                }
                case LICENSE_EFFECTIVE_DATE: {
                    field = new RulesLicensingField(identifier.getDisplayName(), IRulesLicensingField.DataType.DATE, FieldIdentifier.LICENSE_EFFECTIVE_DATE.getDisplayName(), new ArrayList());
                    list.add(field);
                    continue block8;
                }
                case LICENSE_EXPIRY_DATE: {
                    field = new RulesLicensingField(identifier.getDisplayName(), IRulesLicensingField.DataType.DATE, FieldIdentifier.LICENSE_EXPIRY_DATE.getDisplayName(), new ArrayList());
                    list.add(field);
                    continue block8;
                }
                case PRICING_ACTUAL_RETAIL_PRICE: {
                    field = new RulesLicensingField(identifier.getDisplayName(), IRulesLicensingField.DataType.FLOAT, FieldIdentifier.PRICING_ACTUAL_RETAIL_PRICE.getDisplayName(), new ArrayList());
                    list.add(field);
                    continue block8;
                }
                case STORAGE_AND_METADATA_POSTER: {
                    field = new RulesLicensingField(identifier.getDisplayName(), IRulesLicensingField.DataType.BOOLEAN, FieldIdentifier.STORAGE_AND_METADATA_POSTER.getDisplayName(), new ArrayList());
                    list.add(field);
                    continue block8;
                }
                case STORAGE_AND_METADATA_PREVIEW: {
                    field = new RulesLicensingField(identifier.getDisplayName(), IRulesLicensingField.DataType.BOOLEAN, FieldIdentifier.STORAGE_AND_METADATA_PREVIEW.getDisplayName(), new ArrayList());
                    list.add(field);
                }
            }
        }
        return list;
    }
}

