/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.mail;

import com.ericsson.mail.ICMEmailNotificationManager;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless
public class CMEmailNotificationManager
implements ICMEmailNotificationManager {
    private static final String CONTRACT_MANAGER_TIMER = "Contract Manager Expiry Notification Timer";
    private static final Log log = LogFactory.getLog(CMEmailNotificationManager.class);
    @Resource
    TimerService timerService;

    @Override
    public boolean deleteRegisteredEJBTimer() {
        Collection timers = this.timerService.getTimers();
        Iterator it = timers.iterator();
        boolean registered = false;
        while (it.hasNext()) {
            Timer timer = (Timer)it.next();
            if (!timer.getInfo().equals(CONTRACT_MANAGER_TIMER)) continue;
            log.info((Object)"Contract Manager Expiry Notification Timer actively registered with the EJBTimerService. Will cancel the same!");
            registered = true;
            try {
                timer.cancel();
            }
            catch (Exception e) {
                log.error((Object)("Could not cancel the EJBTimerService: Contract Manager Expiry Notification Timer due to the following reasons: " + e.getLocalizedMessage()));
            }
        }
        return registered;
    }

    @Timeout
    public void timeout(Timer timer) {
        log.debug((Object)"time out");
    }
}

