/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.authorization;

import com.ericsson.cms.epgmgmt.authorization.Messages;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class EPGManagerModuleProvider
implements IModuleProvider {
    private static final String EPG_LICENSE = "EPGManagerLicense";
    private ILicenseManager neptuneLicenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);
    private static final Logger logger = Logger.getLogger(EPGManagerModuleProvider.class);

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        try {
            if (this.isLicensed()) {
                modules.add(this.buildEPGManagerModule());
            }
        }
        catch (InvalidLicenseException e) {
            logger.error((Object)("Error in obtaining the license for EPG Manager " + e.getLocalizedMessage()));
        }
        return modules;
    }

    private boolean isLicensed() throws InvalidLicenseException {
        String value = this.neptuneLicenseManager.getProperty(EPG_LICENSE);
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    private IModule buildEPGManagerModule() {
        String moduleName = "EPGManager";
        String displayName = Messages.getString("EPGManagerModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("EPGManagerModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        displayName = Messages.getString("EPGManagerModule.Permissions.Create");
        permissions.add(new BasicPermission("Create", displayName, moduleName));
        displayName = Messages.getString("EPGManagerModule.Permissions.Modify");
        permissions.add(new BasicPermission("Modify", displayName, moduleName));
        displayName = Messages.getString("EPGManagerModule.Permissions.Delete");
        permissions.add(new BasicPermission("Delete", displayName, moduleName));
        return module;
    }
}

