/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.camel;

import com.ericsson.cms.epgmgmt.camel.FtpEndpointExt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.remote.FtpOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.slf4j.Logger;

public class FtpOperationsExt
extends FtpOperations {
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(FtpOperationsExt.class);
    private StreamControl streamControl = new StreamControl();
    private InputStream inputStreamForStoreFile;

    public FtpOperationsExt(FTPClient client, FTPClientConfig clientConfig) {
        super(client, clientConfig);
        client.setCopyStreamListener((CopyStreamListener)this.streamControl);
    }

    public boolean storeFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        FtpEndpointExt ftpEndPoint = (FtpEndpointExt)this.endpoint;
        ftpEndPoint.bindRouteNameWithRunningFtpOperations(exchange.getFromRouteId(), this);
        boolean success = false;
        try {
            success = this.realStoreFile(name, exchange);
        }
        catch (GenericFileOperationFailedException e) {
            if (this.isCausedByFtpOpeartionisClosed(e)) {
                logger.warn((Object)"The ftpConnection has been closed by camel.");
                exchange.getOut().setBody((Object)("Stop to write the file:" + name + ", canceled by camel call"));
                success = true;
            }
            exchange.setException((Throwable)e);
            logger.warn((Object)("Fail to store file, duel to " + e.getMessage()), (Throwable)e);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean realStoreFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        name = this.endpoint.getConfiguration().normalizePath(name);
        this.log.trace("storeFile({})", (Object)name);
        boolean answer = false;
        String currentDir = null;
        String path = FileUtil.onlyPath((String)name);
        String targetName = name;
        try {
            if (path != null && this.endpoint.getConfiguration().isStepwise()) {
                currentDir = this.getCurrentDirectory();
                this.changeCurrentDirectory(path);
                targetName = FileUtil.stripPath((String)name);
            }
            answer = this.doStoreFile(name, targetName, exchange);
            if (currentDir == null) return answer;
        }
        catch (Throwable throwable) {
            if (currentDir == null) throw throwable;
            this.changeCurrentDirectory(currentDir);
            throw throwable;
        }
        this.changeCurrentDirectory(currentDir);
        return answer;
    }

    private boolean doStoreFile(String name, String targetName, Exchange exchange) throws GenericFileOperationFailedException {
        boolean existFile;
        this.log.trace("doStoreFile({})", (Object)targetName);
        if (this.endpoint.getFileExist() == GenericFileExist.Ignore || this.endpoint.getFileExist() == GenericFileExist.Fail || this.endpoint.getFileExist() == GenericFileExist.Move) {
            existFile = this.existsFile(targetName);
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                this.log.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)name);
                return true;
            }
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Fail) {
                throw new GenericFileOperationFailedException("File already exist: " + name + ". Cannot write new file.");
            }
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Move) {
                this.doMoveExistingFile(name, targetName);
            }
        }
        this.inputStreamForStoreFile = null;
        if (exchange.getIn().getBody() == null) {
            if (this.endpoint.isAllowNullBody()) {
                this.log.trace("Writing empty file.");
                this.inputStreamForStoreFile = new ByteArrayInputStream(new byte[0]);
            } else {
                throw new GenericFileOperationFailedException("Cannot write null body to file: " + name);
            }
        }
        try {
            if (this.inputStreamForStoreFile == null) {
                this.inputStreamForStoreFile = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
            }
            if (this.endpoint.getFileExist() == GenericFileExist.Append) {
                this.log.trace("Client appendFile: {}", (Object)targetName);
                existFile = this.client.appendFile(targetName, this.inputStreamForStoreFile);
                return existFile;
            }
            this.log.trace("Client storeFile: {}", (Object)targetName);
            existFile = this.client.storeFile(targetName, this.inputStreamForStoreFile);
            return existFile;
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
        catch (InvalidPayloadException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
        }
        finally {
            IOHelper.close((Closeable)this.inputStreamForStoreFile, (String)("store: " + name), (Logger)this.log);
            this.inputStreamForStoreFile = null;
        }
    }

    private void doMoveExistingFile(String name, String targetName) throws GenericFileOperationFailedException {
        String to;
        block8: {
            Exchange dummy = this.endpoint.createExchange();
            Object parent = null;
            String onlyName = FileUtil.stripPath((String)targetName);
            dummy.getIn().setHeader("CamelFileName", (Object)targetName);
            dummy.getIn().setHeader("CamelFileNameOnly", (Object)onlyName);
            dummy.getIn().setHeader("CamelFileParent", parent);
            to = (String)this.endpoint.getMoveExisting().evaluate(dummy, String.class);
            to = FileUtil.stripLeadingSeparator((String)to);
            to = this.endpoint.getConfiguration().normalizePath(to);
            if (ObjectHelper.isEmpty((Object)to)) {
                throw new GenericFileOperationFailedException("moveExisting evaluated as empty String, cannot move existing file: " + name);
            }
            String dir = FileUtil.onlyPath((String)to);
            if (dir != null) {
                this.buildDirectory(dir, false);
            }
            if (this.existsFile(to)) {
                if (this.endpoint.isEagerDeleteTargetFile()) {
                    this.log.trace("Deleting existing file: {}", (Object)to);
                    try {
                        boolean result = this.client.deleteFile(to);
                        if (!result) {
                            throw new GenericFileOperationFailedException("Cannot delete file: " + to);
                        }
                        break block8;
                    }
                    catch (IOException e) {
                        throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), "Cannot delete file: " + to, (Throwable)e);
                    }
                }
                throw new GenericFileOperationFailedException("Cannot moved existing file from: " + name + " to: " + to + " as there already exists a file: " + to);
            }
        }
        this.log.trace("Moving existing file: {} to: {}", (Object)name, (Object)to);
        if (!this.renameFile(targetName, to)) {
            throw new GenericFileOperationFailedException("Cannot rename file from: " + name + " to: " + to);
        }
    }

    private boolean isCausedByFtpOpeartionisClosed(GenericFileOperationFailedException e) {
        return e.getReason().contains("Connection is not open") && e.getCode() == 150;
    }

    public void forceDisconnect() {
        if (this.client == null || !this.client.isConnected()) {
            return;
        }
        String endpointKey = this.endpoint.getEndpointKey();
        logger.info((Object)("Try to force close the ftp:" + endpointKey));
        try {
            this.log.trace("Client disconnect");
            this.client.disconnect();
            if (this.inputStreamForStoreFile != null) {
                this.inputStreamForStoreFile.close();
            }
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
    }

    class StreamControl
    implements CopyStreamListener {
        private long mbTransferred = 0L;

        StreamControl() {
        }

        public void bytesTransferred(CopyStreamEvent event) {
            this.bytesTransferred(event.getTotalBytesTransferred(), event.getBytesTransferred(), event.getStreamSize());
        }

        public void bytesTransferred(long totalBytes, int bytes, long streamSize) {
            long mb = totalBytes / 0x100000L;
            if (mb > this.mbTransferred) {
                this.mbTransferred = mb;
                logger.debug((Object)("[" + this.mbTransferred + "] Mb transferred"));
            }
        }
    }
}

