/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.EpgAlarmActivityLog;
import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.entity.enumeration.RouteTypeEnum;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IProviderManager;
import com.ericsson.cms.epgmgmt.service.IPublisherManager;
import com.ericsson.cms.epgmgmt.service.ProviderRouteBuilder;
import com.ericsson.cms.epgmgmt.service.PublisherRouteBuilder;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.processor.validation.SchemaValidationException;
import org.apache.log4j.Logger;

@Local(value={IAlarmActivityLogManager.class})
@Stateless
public class AlarmActivityLogManager
implements IAlarmActivityLogManager {
    private static final String ERROR_MSG = "ERROR_MSG";
    private static final Logger logger = Logger.getLogger(AlarmActivityLogManager.class);
    private static final Logger snmpLogger = Logger.getLogger((String)"com.ericsson.cms.epgmgmt.AlertLogger");
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;
    @EJB
    IProviderManager providerManager;
    @EJB
    IPublisherManager publisherManager;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void log(PluginLogSeverity severity, PluginLogComponent component, String description) {
        String msg;
        logger.trace((Object)"log(PluginLogSeverity severity, String description)");
        String string = msg = description == null ? "" : description;
        if (description != null && description.length() > 2000) {
            msg = description.substring(0, 2000);
        }
        EpgAlarmActivityLog aal = new EpgAlarmActivityLog();
        aal.setSeverity(severity);
        aal.setComponent(component);
        aal.setDescription(msg);
        this.create(aal);
        logger.trace((Object)"log(PluginLogSeverity severity, String description)");
    }

    public void create(EpgAlarmActivityLog activity) {
        logger.debug((Object)"create(EpgAlarmActivityLog) - start");
        this.entityManager.persist((Object)activity);
        this.entityManager.flush();
        logger.debug((Object)"create(EpgAlarmActivityLog) - end");
    }

    public List<EpgAlarmActivityLog> getCompleteAlarmActivityLog() {
        logger.debug((Object)"getCompleteAlarmActivityLog() - start");
        List alarmActivityLog = null;
        Query query = this.entityManager.createNamedQuery("EpgAlarmActivityLog.findAll");
        alarmActivityLog = query.getResultList();
        logger.debug((Object)"getCompleteAlarmActivityLog() - end");
        return alarmActivityLog;
    }

    private Date addADayToDate(Date day) {
        if (day == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(day);
        c.add(5, 1);
        return c.getTime();
    }

    public List<EpgAlarmActivityLog> getAlaramActivityLogByFilter(int start, int count, String sortProperty, boolean isAscending, String severity, String component, Date startDate, Date endDate) {
        logger.debug((Object)"getAlaramActivityLogByFilter(int, int, String, boolean, String, String, Date, Date) - start");
        List result = null;
        String orderBy = " ORDER BY ";
        orderBy = sortProperty != null && sortProperty.equalsIgnoreCase("severity") ? orderBy + "aal.severity" : (sortProperty != null && sortProperty.equalsIgnoreCase("component") ? orderBy + "aal.component" : (sortProperty != null && sortProperty.equalsIgnoreCase("description") ? orderBy + "aal.description" : orderBy + "aal.createdDate"));
        orderBy = isAscending ? orderBy + " asc , aal.id asc " : orderBy + " desc , aal.id desc ";
        Query query = this.buildCriteriaQuery(severity, component, startDate, endDate, orderBy);
        query.setFirstResult(start);
        query.setMaxResults(count == 0 ? Integer.MAX_VALUE : count);
        result = query.getResultList();
        logger.debug((Object)"getAlaramActivityLogByFilter(int, int, String, boolean, String, String, Date, Date) - end");
        return result;
    }

    public long getCountAlaramActivityLogByFilter(String severity, String component, Date startDate, Date endDate) {
        logger.debug((Object)"getCountAlaramActivityLogByFilter(String, String, Date, Date) - start");
        Query query = this.buildCriteriaQuery(severity, component, startDate, endDate, null);
        long result = query.getResultList().size();
        logger.debug((Object)"getCountAlaramActivityLogByFilter(String, String, Date, Date) - end");
        return result;
    }

    private Query buildCriteriaQuery(String severity, String component, Date startDate, Date endDate, String orderByClause) {
        logger.debug((Object)"buildCriteriaQuery(String, String, Date, Date, String) - start");
        Query query = null;
        StringBuilder queryStr = new StringBuilder("SELECT aal FROM EpgAlarmActivityLog aal ");
        StringBuilder whereClause = new StringBuilder();
        boolean hadWhereCondintion = false;
        boolean hadDateCondition = false;
        if (severity != null && !severity.equalsIgnoreCase("ALL")) {
            if (hadWhereCondintion) {
                whereClause.append(" and ");
            }
            whereClause.append("aal.severity ").append(" = '").append(severity).append("'");
            hadWhereCondintion = true;
        }
        if (component != null && !component.equalsIgnoreCase("ALL")) {
            if (hadWhereCondintion) {
                whereClause.append(" and ");
            }
            whereClause.append("aal.component ").append(" = '").append(component).append("'");
            hadWhereCondintion = true;
        }
        if (startDate != null && endDate != null && startDate.compareTo(endDate) <= 0) {
            if (hadWhereCondintion) {
                whereClause.append(" and ");
            }
            whereClause.append("(aal.createdDate >= :start and aal.createdDate < :end) ");
            hadDateCondition = true;
            hadWhereCondintion = true;
        }
        if (hadWhereCondintion) {
            queryStr.append(" WHERE ").append(whereClause.toString());
        }
        if (orderByClause != null && !orderByClause.isEmpty()) {
            queryStr.append(orderByClause);
        }
        query = this.entityManager.createQuery(queryStr.toString());
        if (hadDateCondition) {
            query.setParameter("start", startDate, TemporalType.TIMESTAMP);
            query.setParameter("end", this.addADayToDate(endDate), TemporalType.TIMESTAMP);
        }
        logger.debug((Object)"buildCriteriaQuery(String, String, Date, Date, String) - end");
        return query;
    }

    public void createWorkflowErrorLog(Exchange exchange) {
        this.create(PluginLogComponent.WORKFLOW, null, exchange, true);
    }

    public void createValidationError(Exchange exchange) {
        this.logValidationError(exchange);
        SchemaValidationException exception = (SchemaValidationException)exchange.getProperty("CamelExceptionCaught", SchemaValidationException.class);
        if (exception != null) {
            exchange.setProperty(ERROR_MSG, (Object)("Fail to validate the data file[" + exchange.getIn() + "]"));
        }
        PluginLogComponent type = this.isProvider(exchange) ? PluginLogComponent.INGEST : PluginLogComponent.WORKFLOW;
        this.create(type, "Failure to translate EPG error for %s", exchange, true);
    }

    private boolean isProvider(Exchange exchange) {
        RouteTypeEnum typeOfRoute = this.getRouteType(exchange);
        return typeOfRoute == RouteTypeEnum.PROVIDER;
    }

    private RouteTypeEnum getRouteType(Exchange exchange) {
        return (RouteTypeEnum)exchange.getIn().getHeader("ROUTE_TYPE", RouteTypeEnum.class);
    }

    private void logValidationError(Exchange exchange) {
        Exception exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        logger.error((Object)("Fail to validate thethe data file[" + exchange.getIn() + "]" + " for provider: " + exchange.getFromRouteId() + "\n" + exception.getMessage()));
    }

    public void createPluginFrameworkErrorLog(Exchange exchange) {
        this.create(PluginLogComponent.PLUGIN_FRAMEWORK, null, exchange, false);
    }

    public void createPluginErrorLog(Exchange exchange) {
        this.create(PluginLogComponent.PLUGIN, null, exchange, false);
    }

    public void createIngestErrorLog(Exchange exchange) {
        this.create(PluginLogComponent.INGEST, "Failure to translate EPG error for %s", exchange, true);
    }

    public void createPublishErrorLog(Exchange exchange) {
        this.create(PluginLogComponent.PUBLISH, "Failure to publish EPG data for %s", exchange, true);
    }

    public void createMergeErrorLog(Exchange exchange) {
        this.create(PluginLogComponent.MERGE, "Merge failed for %s", exchange, true);
    }

    public void createExportToStagingErrorLog(Exchange exchange) {
        this.create(PluginLogComponent.EXPORT_TO_STG, "Failure to publish EPG data for %s", exchange, true);
    }

    public void createExportToXMLErrorLog(Exchange exchange) {
        this.create(PluginLogComponent.EXPORT_TO_XML, "Failure to publish EPG data for %s", exchange, true);
    }

    private void create(PluginLogComponent pluginLogComponent, String alertServerPattern, Exchange exchange, boolean addDetailsToMessage) {
        RouteTypeEnum typeOfRoute;
        StringBuilder messageToLog = new StringBuilder(200);
        String msg = (String)exchange.getProperty(ERROR_MSG, String.class);
        if (msg != null) {
            messageToLog.append(msg);
        } else {
            this.extractExceptionMsg(exchange, messageToLog);
        }
        if (messageToLog.length() <= 0) {
            messageToLog.append("unkown workflow error");
        }
        if (addDetailsToMessage && exchange.getIn() != null && (typeOfRoute = this.getRouteType(exchange)) != null) {
            switch (typeOfRoute) {
                case PROVIDER: {
                    String providerString = this.lookUpProvider(exchange);
                    messageToLog.append(" for " + providerString);
                    if (alertServerPattern == null) break;
                    alertServerPattern = String.format(alertServerPattern, providerString);
                    break;
                }
                case PUBLISHER: {
                    String publisherString = this.lookUpPublisher(exchange);
                    messageToLog.append(" for " + publisherString);
                    if (alertServerPattern == null) break;
                    alertServerPattern = String.format(alertServerPattern, publisherString);
                }
            }
        }
        this.logError(pluginLogComponent, messageToLog.toString());
        snmpLogger.info((Object)alertServerPattern);
    }

    private void extractExceptionMsg(Exchange exchange, StringBuilder messageToLog) {
        Exception exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        if (exception != null) {
            if (exception.getCause() != null) {
                messageToLog.append(exception.getCause().getMessage());
            } else {
                messageToLog.append(exception.getMessage());
            }
            if (exception instanceof GenericFileOperationFailedException) {
                String uri = (String)exchange.getProperty("CamelFailureEndpoint");
                if (uri != null && uri.contains("?")) {
                    uri = ((Object)uri.subSequence(0, uri.indexOf(63))).toString();
                }
                messageToLog.append(" for URI " + uri);
            }
        }
    }

    public void logError(PluginLogComponent pluginLogComponent, String message) {
        this.log(PluginLogSeverity.ERROR, pluginLogComponent, message);
    }

    public void createNormalizationErrorLog(Exchange exchange) {
        this.create(PluginLogComponent.NORMALIZATION_RULES, null, exchange, true);
    }

    public void createValidationErrorLog(Exchange exchange) {
        this.create(PluginLogComponent.VALIDATION_RULES, "Validation rule caused abort for %s", exchange, true);
    }

    public void logInfo(Exchange exchange, PluginLogComponent pluginLogComponent, String message) {
        message = message + " for " + this.lookUpProviderOrPublisher(exchange);
        this.log(PluginLogSeverity.INFORMATION, pluginLogComponent, message);
    }

    public void logIngestInfo(Exchange exchange, String message) {
        this.logInfo(exchange, PluginLogComponent.INGEST, message);
    }

    public void logSystemInfo(Exchange exchange, String message) {
        this.logInfo(exchange, PluginLogComponent.SYSTEM, message);
    }

    private String lookUpProvider(Exchange exchange) {
        String providerString = "Unknown";
        long providerId = ProviderRouteBuilder.getProviderId(exchange);
        if (providerId != -1L) {
            try {
                Provider provider = this.providerManager.getProvider(providerId);
                if (provider != null) {
                    providerString = provider.toString();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to lookup provider for id " + providerId));
            }
        }
        return providerString;
    }

    private String lookUpPublisher(Exchange exchange) {
        String publisherString = "Unknown";
        long publisherId = PublisherRouteBuilder.getPublisherId(exchange);
        if (publisherId != -1L) {
            try {
                Publisher publisher = this.publisherManager.getPublisher(publisherId);
                if (publisher != null) {
                    publisherString = publisher.toString();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to lookup provider for id " + publisherId));
            }
        }
        return publisherString;
    }

    private String lookUpProviderOrPublisher(Exchange exchange) {
        RouteTypeEnum typeOfRoute = this.getRouteType(exchange);
        switch (typeOfRoute) {
            case PROVIDER: {
                return this.lookUpProvider(exchange);
            }
            case PUBLISHER: {
                return this.lookUpPublisher(exchange);
            }
        }
        logger.error((Object)" Trying to lookup provider of publisher for Exchange failed since type of route is undetermined!");
        return "Unknown";
    }
}

