/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.Compression;
import com.ericsson.cms.epgmgmt.entity.EndpointDetails;
import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.PluginPropertyEntity;
import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.ProviderPluginValue;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.PublisherPluginValue;
import com.ericsson.cms.epgmgmt.entity.enumeration.EPGPluginTypeEnum;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import com.ericsson.cms.epgmgmt.service.IProviderManager;
import com.ericsson.cms.epgmgmt.service.IPublisherManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IEPGMetadataManager.class})
@Stateless
public class EPGMetadataManager
implements IEPGMetadataManager {
    private static final Log logger = LogFactory.getLog(EPGMetadataManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;
    @EJB
    private IProviderManager providerManager;
    @EJB
    private IPublisherManager publisherManager;

    public List<EpgFormat> getAllEpgFormatDetails() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllEpgFormatDetails() - start");
        }
        try {
            Query query = this.entityManager.createNamedQuery("EpgFormat.findAll");
            List returnList = query.getResultList();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getAllEpgFormatDetails() - end");
            }
            return returnList;
        }
        catch (Exception ex) {
            logger.error((Object)"Error found while retrieving EPGFormat Details", (Throwable)ex);
            throw ex;
        }
    }

    public EpgFormat getEpgFormatDetailsbyName(String formatName) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getEpgFormatDetailsbyName(String) - start");
        }
        try {
            Query query = this.entityManager.createNamedQuery("EpgFormat.byName");
            query.setParameter("NAME", (Object)formatName);
            EpgFormat returnEpgFormat = (EpgFormat)query.getSingleResult();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getEpgFormatDetailsbyName(String) - end");
            }
            return returnEpgFormat;
        }
        catch (Exception ex) {
            logger.error((Object)"Error found while retrieving EPGFormat Details", (Throwable)ex);
            throw ex;
        }
    }

    public EpgFormat getEpgFormatDetailsbyId(long id) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getEpgFormatDetailsbyId(long) - start");
        }
        try {
            EpgFormat returnEpgFormat = (EpgFormat)this.entityManager.find(EpgFormat.class, (Object)id);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getEpgFormatDetailsbyId(long) - end");
            }
            return returnEpgFormat;
        }
        catch (Exception ex) {
            logger.error((Object)"Error found while retrieving EPGFormat Details", (Throwable)ex);
            throw ex;
        }
    }

    public EpgFormat getEpgFormatDetailsbyNameType(String formatName, String type) throws Exception {
        EpgFormat returnEpgFormat = null;
        try {
            Query query = this.entityManager.createNamedQuery("EpgFormat.byPluginNameType");
            query.setParameter("NAME", (Object)formatName);
            query.setParameter("TYPE", (Object)type);
            returnEpgFormat = (EpgFormat)query.getSingleResult();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getEpgFormatDetailsbyName(String) - end");
            }
            return returnEpgFormat;
        }
        catch (NoResultException nrEx) {
            return returnEpgFormat;
        }
        catch (Exception ex) {
            logger.error((Object)"Error found while retrieving EPGFormat Details", (Throwable)ex);
            throw ex;
        }
    }

    public List<EndpointDetails> getAllEndpointDetails() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllEndpointDetails() - start");
        }
        try {
            Query query = this.entityManager.createNamedQuery("EndpointDetails.findAll");
            List returnList = query.getResultList();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getAllEndpointDetails() - end");
            }
            return returnList;
        }
        catch (Exception ex) {
            logger.error((Object)"Error found while retrieving Endpoint Details", (Throwable)ex);
            throw ex;
        }
    }

    public EndpointDetails getEndpointDetailsbyName(String name) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getEndpointDetailsbyName(String) - start");
        }
        try {
            Query query = this.entityManager.createNamedQuery("EndpointDetails.byName");
            query.setParameter("NAME", (Object)name);
            EndpointDetails returnEndpointDetails = (EndpointDetails)query.getSingleResult();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getEndpointDetailsbyName(String) - end");
            }
            return returnEndpointDetails;
        }
        catch (Exception ex) {
            logger.error((Object)"Error found while retrieving Endpoint Details", (Throwable)ex);
            throw ex;
        }
    }

    public EndpointDetails getEndpointDetailsbyId(long id) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getEndpointDetailsbyId(long) - start");
        }
        try {
            EndpointDetails returnEndpointDetails = (EndpointDetails)this.entityManager.find(EndpointDetails.class, (Object)id);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getEndpointDetailsbyId(long) - end");
            }
            return returnEndpointDetails;
        }
        catch (Exception ex) {
            logger.error((Object)"Error found while retrieving Endpoint Details", (Throwable)ex);
            throw ex;
        }
    }

    public List<Compression> getAllCompressionDetails() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllCompressionDetails() - start");
        }
        try {
            Query query = this.entityManager.createNamedQuery("Compression.findAll");
            List returnList = query.getResultList();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getAllCompressionDetails() - end");
            }
            return returnList;
        }
        catch (Exception ex) {
            logger.error((Object)"Error found while retrieving Endpoint Details", (Throwable)ex);
            throw ex;
        }
    }

    public void createOrUpdate(EpgFormat epgFormat) throws Exception {
        try {
            EpgFormat existingEpgFormat;
            HashSet newPluginProperties = epgFormat.getPluginProperties();
            if (newPluginProperties == null) {
                newPluginProperties = new HashSet(0);
                epgFormat.setPluginProperties(newPluginProperties);
            }
            if ((existingEpgFormat = this.getEpgFormatDetailsbyNameTypeJar(epgFormat.getFormatName(), epgFormat.getType().toString(), epgFormat.getJarName())) == null) {
                this.createEpgFormat(epgFormat);
            } else {
                if (((Object)existingEpgFormat.getPluginProperties()).equals(newPluginProperties) && StringUtils.equals((String)existingEpgFormat.getVersion(), (String)epgFormat.getVersion())) {
                    logger.debug((Object)("No changes found for plugin properties for:" + epgFormat.toString()));
                    return;
                }
                existingEpgFormat.setPluginProperties(newPluginProperties);
                existingEpgFormat.setVersion(epgFormat.getVersion());
                this.entityManager.persist((Object)existingEpgFormat);
                List providersAffected = this.providerManager.getProviderByFormat(existingEpgFormat);
                if (providersAffected == null || providersAffected.size() == 0) {
                    logger.debug((Object)("No providers are currently using the epgformat:" + epgFormat.toString()));
                } else {
                    for (Provider provider : providersAffected) {
                        List existingProviderPluginValues = provider.getPluginPropertyValues();
                        ArrayList<ProviderPluginValue> newProviderPluginValues = new ArrayList<ProviderPluginValue>(newPluginProperties.size());
                        for (PluginPropertyEntity newppe : newPluginProperties) {
                            ProviderPluginValue newPPV = new ProviderPluginValue();
                            newPPV.setProvider(provider);
                            newPPV.setPluginPropertyEntity(newppe);
                            newppe.setepgFormat(existingEpgFormat);
                            String newValue = newppe.getPropertyDefaultValue();
                            if (existingProviderPluginValues != null && !existingProviderPluginValues.isEmpty()) {
                                for (ProviderPluginValue providerPluginValue : existingProviderPluginValues) {
                                    String oldValue;
                                    if (!newppe.getPropertyName().equals(providerPluginValue.getPluginPropertyEntity().getPropertyName())) continue;
                                    newValue = oldValue = providerPluginValue.getValue();
                                    break;
                                }
                            }
                            newPPV.setValue(newValue);
                            newProviderPluginValues.add(newPPV);
                        }
                        provider.setPluginPropertyValues(newProviderPluginValues);
                        this.entityManager.merge((Object)provider);
                    }
                }
                List publishersAffected = this.publisherManager.getPublisherByFormat(existingEpgFormat);
                if (publishersAffected == null || publishersAffected.size() == 0) {
                    logger.debug((Object)("No publishers are currently using the epgformat:" + epgFormat.toString()));
                } else {
                    for (Publisher publisher : publishersAffected) {
                        List existingProviderPluginValues = publisher.getPluginPropertyValues();
                        ArrayList<PublisherPluginValue> newProviderPluginValues = new ArrayList<PublisherPluginValue>(newPluginProperties.size());
                        for (PluginPropertyEntity newppe : newPluginProperties) {
                            PublisherPluginValue newPPV = new PublisherPluginValue();
                            newPPV.setPublisher(publisher);
                            newPPV.setPluginPropertyEntity(newppe);
                            newppe.setepgFormat(existingEpgFormat);
                            String newValue = newppe.getPropertyDefaultValue();
                            if (existingProviderPluginValues != null && !existingProviderPluginValues.isEmpty()) {
                                for (PublisherPluginValue publisherPluginValue : existingProviderPluginValues) {
                                    String oldValue;
                                    if (!newppe.getPropertyName().equals(publisherPluginValue.getPluginPropertyEntity().getPropertyName())) continue;
                                    newValue = oldValue = publisherPluginValue.getValue();
                                    break;
                                }
                            }
                            newPPV.setValue(newValue);
                            newProviderPluginValues.add(newPPV);
                        }
                        publisher.setPluginPropertyValues(newProviderPluginValues);
                        this.entityManager.merge((Object)publisher);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)(" Failed to create/update EPG format " + ex));
            throw ex;
        }
    }

    public void createEpgFormat(EpgFormat epgFormat) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"createEpgFormat(EpgFormat) - start");
        }
        try {
            this.entityManager.persist((Object)epgFormat);
        }
        catch (Exception ex) {
            logger.error((Object)"createEpgFormat(EpgFormat)", (Throwable)ex);
            throw ex;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"createEpgFormat(EpgFormat) - end");
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeInactiveEpgPluginProperties(long formatId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removeInactiveEpgPluginProperties(long) - start");
        }
        try {
            Query query = this.entityManager.createNativeQuery("DELETE PLUGIN_PROPERTY WHERE IS_ACTIVE = 0 and FORMAT_ID = :formatId");
            query.setParameter("formatId", (Object)formatId);
            query.executeUpdate();
        }
        catch (Exception ex) {
            logger.error((Object)"removeInactiveEpgPluginProperties(long)", (Throwable)ex);
            throw ex;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removeInactiveEpgPluginProperties(long) - end");
        }
    }

    public EpgFormat getEpgFormatDetailsbyNameTypeJar(String formatName, String type, String jarName) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getEpgFormatDetailsbyNameTypeJar(String, String, String) - start");
        }
        EpgFormat returnEpgFormat = null;
        try {
            Query query = this.entityManager.createNamedQuery("EpgFormat.byPluginNameTypeJar");
            query.setParameter("NAME", (Object)formatName);
            query.setParameter("TYPE", (Object)type);
            query.setParameter("JARNAME", (Object)jarName);
            returnEpgFormat = (EpgFormat)query.getSingleResult();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getEpgFormatDetailsbyName(String,String,String) - end");
            }
            return returnEpgFormat;
        }
        catch (NoResultException nrEx) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getEpgFormatDetailsbyNameTypeJar(String, String, String) - end");
            }
            return returnEpgFormat;
        }
        catch (Exception ex) {
            logger.error((Object)"Error found while retrieving EPGFormat Details", (Throwable)ex);
            throw ex;
        }
    }

    public List<EpgFormat> getAllProvidersEpgFormats() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllProvidersEpgFormats() - start");
        }
        List returnList = null;
        try {
            Query query = this.entityManager.createNamedQuery("EpgFormat.byPluginType");
            query.setParameter("TYPE", (Object)EPGPluginTypeEnum.Provider.toString());
            returnList = query.getResultList();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getAllProvidersEpgFormats() - end");
            }
            return returnList;
        }
        catch (NoResultException nrEx) {
            return returnList;
        }
        catch (Exception ex) {
            logger.error((Object)"getAllProvidersEpgFormats()", (Throwable)ex);
            throw ex;
        }
    }

    public List<EpgFormat> getAllPublishersEpgFormats() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllPublishersEpgFormats() - start");
        }
        List returnList = null;
        try {
            Query query = this.entityManager.createNamedQuery("EpgFormat.byPluginType");
            query.setParameter("TYPE", (Object)EPGPluginTypeEnum.Publisher.toString());
            returnList = query.getResultList();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getAllPublishersEpgFormats() - end");
            }
            return returnList;
        }
        catch (NoResultException nrEx) {
            return returnList;
        }
        catch (Exception ex) {
            logger.error((Object)"getAllPublishersEpgFormats()", (Throwable)ex);
            throw ex;
        }
    }
}

