/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.Headend;
import com.ericsson.cms.epgmgmt.service.IHeadendManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless
public class HeadendManager
implements IHeadendManager {
    @PersistenceContext(unitName="epgmanagerjpaunit")
    private EntityManager entityManager;
    private static final Log log = LogFactory.getLog(HeadendManager.class);

    public List<Headend> getAllHeadends() {
        try {
            Query query = this.entityManager.createNamedQuery("Headend.findAll");
            List resultList = query.getResultList();
            return resultList;
        }
        catch (RuntimeException e) {
            log.error((Object)"get failed", (Throwable)e);
            throw e;
        }
    }

    public void create(Headend he) {
        try {
            this.validateHeadend();
            this.entityManager.persist((Object)he);
        }
        catch (RuntimeException e) {
            log.error((Object)"create failed", (Throwable)e);
            throw e;
        }
    }

    public void update(Headend he) {
        try {
            this.validateHeadend();
            this.entityManager.merge((Object)he);
        }
        catch (RuntimeException e) {
            log.error((Object)"update failed", (Throwable)e);
            throw e;
        }
    }

    private void validateHeadend() {
        ArrayList validationMessages = new ArrayList();
    }

    public String getEpgSummary() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(" Total Headends - " + this.getCount("HEADEND") + "\n");
            builder.append(" Total Lineups  - " + this.getCount("LINEUP") + "\n");
            builder.append(" Total Stations - " + this.getCount("STATION") + "\n");
            builder.append(" Total Schedules - " + this.getCount("SCHEDULE") + "\n");
            builder.append(" Total Programs- " + this.getCount("PROGRAM") + "\n");
            return builder.toString();
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage());
            return "Error getting EPG summary" + t.getMessage();
        }
    }

    private int getCount(String tableName) {
        Query query = this.entityManager.createNativeQuery("select count(1) from " + tableName);
        return ((BigDecimal)query.getSingleResult()).intValue();
    }
}

