/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.EndpointDetails;
import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.PluginPropertyEntity;
import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.ProviderPluginValue;
import com.ericsson.cms.epgmgmt.service.EpgmgmtException;
import com.ericsson.cms.epgmgmt.service.IProviderManager;
import com.ericsson.cms.epgmgmt.validation.ErrorMessages;
import com.ericsson.cms.epgmgmt.validation.ProviderValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IProviderManager.class})
@Stateless
public class ProviderManager
implements IProviderManager {
    private static final Log logger = LogFactory.getLog(ProviderManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    public boolean create(Provider provider) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create(Provider) - start");
        }
        try {
            this.setPluginPropertyValuesToDefault(provider);
            this.entityManager.persist((Object)provider.getRetrievalDetails());
            this.entityManager.persist((Object)provider);
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"create(Provider)", (Throwable)rtEx);
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create(Provider) - end");
        }
        return true;
    }

    public Provider getProvider(long id) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getProvider(long) - start");
        }
        Provider provider = null;
        try {
            provider = (Provider)this.entityManager.find(Provider.class, (Object)id);
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"getProvider(long)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getProvider(long) - end");
        }
        return provider;
    }

    public List<Provider> getProviders() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getProviders() - start");
        }
        List providersList = null;
        try {
            Query query = this.entityManager.createNamedQuery("Provider.findAll");
            providersList = query.getResultList();
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"getProviders()", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getProviders() - end");
        }
        return providersList;
    }

    public void removeProviderById(long id) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removeProviderById(long) - start");
        }
        try {
            Provider provider = (Provider)this.entityManager.find(Provider.class, (Object)id);
            this.entityManager.remove((Object)provider);
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"removeProviderById(long)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removeProviderById(long) - end");
        }
    }

    public Provider getProviderByName(String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getProviderByName(String) - start");
        }
        Provider provider = null;
        try {
            Query query = this.entityManager.createNamedQuery("Provider.byName");
            query.setParameter("NAME", (Object)name);
            provider = (Provider)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            return provider;
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"getProviderByName(String)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getProviderByName(String) - end");
        }
        return provider;
    }

    public void update(Provider provider) throws EpgmgmtException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"update(Provider) - start");
        }
        try {
            this.validateProvider(provider, provider.getRetrievalDetails().getEndpointTypeDetails().getId(), true);
            Provider existingProvider = (Provider)this.entityManager.find(Provider.class, (Object)provider.getId());
            List ppvs = existingProvider.getPluginPropertyValues();
            if (ppvs != null) {
                ppvs.clear();
                if (provider.getPluginPropertyValues() != null) {
                    ppvs.addAll(provider.getPluginPropertyValues());
                }
                provider.setPluginPropertyValues(ppvs);
            }
            existingProvider = (Provider)this.entityManager.merge((Object)provider);
            existingProvider.setUpdateDate(new Date());
        }
        catch (EpgmgmtException ex) {
            throw ex;
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"update(Provider)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"update(Provider) - end");
        }
    }

    private void validateProvider(Provider provider, Long endPointID, boolean isUpdate) throws EpgmgmtException {
        ProviderValidator providerValidator = new ProviderValidator(this.entityManager);
        try {
            EndpointDetails ed = (EndpointDetails)this.entityManager.find(EndpointDetails.class, (Object)endPointID);
            providerValidator.validateProvider(provider, ed, isUpdate);
        }
        catch (EpgmgmtException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Exception inside epgmgmt Validation ", (Throwable)e);
            throw new EpgmgmtException("Validation failed");
        }
    }

    public Long create(Long endPointDetailsID, Provider provider, Long formatTypeID) throws EpgmgmtException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create(Long, Provider,Long) - start");
        }
        try {
            Provider providerObj = this.getProviderByName(provider.getName());
            logger.debug((Object)("create(Long, Provider) - start provider.getName() :" + provider.getName()));
            if (providerObj != null) {
                ArrayList<String> errorMessages = new ArrayList<String>();
                String tempvalues = "";
                Object[] values = new Object[]{tempvalues};
                errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.duplicate.invalid"), values));
                throw new EpgmgmtException(errorMessages);
            }
            this.validateProvider(provider, endPointDetailsID, false);
            EndpointDetails ed = (EndpointDetails)this.entityManager.find(EndpointDetails.class, (Object)endPointDetailsID);
            logger.debug((Object)("create(Long, Provider) - start formatTypeID :" + formatTypeID));
            EpgFormat returnEpgFormat = (EpgFormat)this.entityManager.find(EpgFormat.class, (Object)formatTypeID);
            if (ed != null && returnEpgFormat != null) {
                provider.getRetrievalDetails().setEndpointTypeDetails(ed);
                provider.setEpgFormat(returnEpgFormat);
                this.setPluginPropertyValuesToDefault(provider);
                this.entityManager.persist((Object)provider.getRetrievalDetails());
                this.entityManager.persist((Object)provider);
            }
        }
        catch (EpgmgmtException ex) {
            throw ex;
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"create(Long, Provider,Long)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create(Long, Provider) - end");
        }
        return provider.getId();
    }

    public List<Provider> getProviderByFormat(EpgFormat epgFormat) {
        Query query = this.entityManager.createNamedQuery("Provider.byFormat");
        query.setParameter("ID", (Object)epgFormat.getId());
        return query.getResultList();
    }

    private void setPluginPropertyValuesToDefault(Provider provider) {
        if (!provider.getEpgFormat().isETV() && (provider.getPluginPropertyValues() == null || provider.getPluginPropertyValues().isEmpty())) {
            ArrayList<ProviderPluginValue> providerPluginValues = new ArrayList<ProviderPluginValue>();
            for (PluginPropertyEntity ppe : provider.getEpgFormat().getPluginProperties()) {
                ProviderPluginValue ppv = new ProviderPluginValue();
                ppv.setPluginPropertyEntity(ppe);
                ppv.setProvider(provider);
                ppv.setValue(ppe.getPropertyDefaultValue());
                providerPluginValues.add(ppv);
            }
            provider.setPluginPropertyValues(providerPluginValues);
        }
    }
}

