/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IRouteStatusManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.log4j.Logger;

public class ProviderRoutePolicy
extends RoutePolicySupport {
    private static final Logger logger = Logger.getLogger(ProviderRoutePolicy.class);
    private IAlarmActivityLogManager applicationLogger = (IAlarmActivityLogManager)InjectionUtil.injectInstance((String)"cms/AlarmActivityLogManager/local", IAlarmActivityLogManager.class);

    public void onExchangeBegin(Route route, Exchange exchange) {
        logger.info((Object)(" exchange start:" + Thread.currentThread().getName()));
        boolean isFile = GenericFile.class.isInstance(exchange.getIn().getBody());
        if (isFile) {
            String message = "Prepare to ingestion, start to retreive file :[" + exchange.getIn() + "]";
            logger.info((Object)message);
            this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.INGEST, message);
        }
    }

    public void onExchangeDone(Route route, Exchange exchange) {
        try {
            IRouteStatusManager routeStatusManager = (IRouteStatusManager)InjectionUtil.injectInstance((String)"cms/RouteStatusManager/local", IRouteStatusManager.class);
            StringBuilder remark = new StringBuilder();
            Object exception = exchange.getProperty("CamelExceptionCaught");
            if (exception instanceof Exception) {
                remark.append("Run failed");
                String reason = ((Exception)exception).getMessage();
                if (reason != null) {
                    remark.append(" - " + reason);
                }
            } else {
                remark.append("Run succeeded");
            }
            routeStatusManager.createOrUpdateRouteStatusToStopped(route.getId(), remark.toString());
        }
        catch (Exception e) {
            logger.error((Object)(" Failed to mark Route status as stopped for Route - " + route.getId()));
            logger.error((Object)e.getMessage());
        }
    }
}

