/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.EndpointDetails;
import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.PluginPropertyEntity;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.PublisherPluginValue;
import com.ericsson.cms.epgmgmt.service.EpgmgmtException;
import com.ericsson.cms.epgmgmt.service.IPublisherManager;
import com.ericsson.cms.epgmgmt.validation.ErrorMessages;
import com.ericsson.cms.epgmgmt.validation.PublisherValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IPublisherManager.class})
@Stateless
public class PublisherManager
implements IPublisherManager {
    private static final Log logger = LogFactory.getLog(PublisherManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    public void create(Publisher publisher) throws EpgmgmtException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create(Publisher) - start");
        }
        try {
            this.validatePublisher(publisher, publisher.getPublishDetails().getEndpointTypeDetails().getId(), false);
            this.setPluginPropertyValuesToDefault(publisher);
            this.entityManager.persist((Object)publisher.getPublishDetails());
            this.entityManager.persist((Object)publisher);
        }
        catch (EpgmgmtException ex) {
            logger.error((Object)"create epgexception Publisher error", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"create(Publisher)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create(Publisher) - end");
        }
    }

    public long create(Publisher publisher, Long endPointDetailsID, Long formatTypeID) throws EpgmgmtException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create(Publisher) - start");
        }
        try {
            Publisher publisherObj = this.getPublisherByName(publisher.getName());
            logger.debug((Object)("create(publisher) - start publisher.getName() :" + publisher.getName()));
            if (publisherObj != null) {
                ArrayList<String> errorMessages = new ArrayList<String>();
                String tempvalues = "";
                Object[] values = new Object[]{tempvalues};
                errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.publisher.duplicate.invalid"), values));
                throw new EpgmgmtException(errorMessages);
            }
            this.validatePublisher(publisher, endPointDetailsID, false);
            EndpointDetails ed = (EndpointDetails)this.entityManager.find(EndpointDetails.class, (Object)endPointDetailsID);
            logger.debug((Object)("create(Publisher) - start formatTypeID :" + formatTypeID));
            EpgFormat returnEpgFormat = (EpgFormat)this.entityManager.find(EpgFormat.class, (Object)formatTypeID);
            if (ed != null && returnEpgFormat != null) {
                publisher.getPublishDetails().setEndpointTypeDetails(ed);
                publisher.setEpgFormat(returnEpgFormat);
                this.setPluginPropertyValuesToDefault(publisher);
                this.entityManager.persist((Object)publisher.getPublishDetails());
                this.entityManager.persist((Object)publisher);
            }
        }
        catch (EpgmgmtException ex) {
            throw ex;
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"create(Publisher,Long,Long)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create(Publisher,Long,Long) - end");
        }
        return publisher.getId();
    }

    private void validatePublisher(Publisher publisher, Long endPointID, boolean isUpdate) throws EpgmgmtException {
        PublisherValidator publisherValidator = new PublisherValidator(this.entityManager);
        try {
            EndpointDetails ed = (EndpointDetails)this.entityManager.find(EndpointDetails.class, (Object)endPointID);
            publisherValidator.validatePublisher(publisher, ed, isUpdate);
        }
        catch (EpgmgmtException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"RuntimeException inside epgmgmt Validation ", (Throwable)e);
            throw new EpgmgmtException("Validation failed");
        }
    }

    public Publisher getPublisher(long id) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getPublisher(long) - start");
        }
        Publisher publisher = null;
        try {
            publisher = (Publisher)this.entityManager.find(Publisher.class, (Object)id);
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"getPublisher(long)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getPublisher(long) - end");
        }
        return publisher;
    }

    public Publisher getPublisherByName(String publisherName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getPublisherByName(String) - start");
        }
        Publisher publisher = null;
        try {
            Query query = this.entityManager.createNamedQuery("Publisher.byName");
            query.setParameter("NAME", (Object)publisherName);
            publisher = (Publisher)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            return publisher;
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"getPublisherByName(String)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getPublisherByName(String) - end");
        }
        return publisher;
    }

    public List<Publisher> getPublishers() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getPublishers() - start");
        }
        List publishers = null;
        try {
            Query query = this.entityManager.createNamedQuery("Publisher.findAll");
            publishers = query.getResultList();
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"getPublishers()", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getPublishers() - end");
        }
        return publishers;
    }

    public void removePublisherById(long id) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removePublisherById(long) - start");
        }
        try {
            Publisher publisher = (Publisher)this.entityManager.find(Publisher.class, (Object)id);
            this.entityManager.remove((Object)publisher);
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"removePublisherById(long)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removePublisherById(long) - end");
        }
    }

    public void update(Publisher publisher) throws EpgmgmtException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"update(Publisher) - start");
        }
        try {
            this.validatePublisher(publisher, publisher.getPublishDetails().getEndpointTypeDetails().getId(), true);
            Publisher existingPublisher = (Publisher)this.entityManager.find(Publisher.class, (Object)publisher.getId());
            List ppvs = existingPublisher.getPluginPropertyValues();
            if (ppvs != null) {
                ppvs.clear();
                if (publisher.getPluginPropertyValues() != null) {
                    ppvs.addAll(publisher.getPluginPropertyValues());
                }
                publisher.setPluginPropertyValues(ppvs);
            }
            existingPublisher = (Publisher)this.entityManager.merge((Object)publisher);
            existingPublisher.setUpdateDate(new Date());
        }
        catch (EpgmgmtException ex) {
            throw ex;
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"update(Publisher)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"update(Publisher) - end");
        }
    }

    public List<Publisher> getPublisherByFormat(EpgFormat epgFormat) {
        Query query = this.entityManager.createNamedQuery("Publisher.byFormat");
        query.setParameter("ID", (Object)epgFormat.getId());
        return query.getResultList();
    }

    private void setPluginPropertyValuesToDefault(Publisher publisher) {
        if (!publisher.getEpgFormat().isETV() && (publisher.getPluginPropertyValues() == null || publisher.getPluginPropertyValues().isEmpty())) {
            ArrayList<PublisherPluginValue> publisherPluginValues = new ArrayList<PublisherPluginValue>();
            for (PluginPropertyEntity ppe : publisher.getEpgFormat().getPluginProperties()) {
                PublisherPluginValue ppv = new PublisherPluginValue();
                ppv.setPluginPropertyEntity(ppe);
                ppv.setPublisher(publisher);
                ppv.setValue(ppe.getPropertyDefaultValue());
                publisherPluginValues.add(ppv);
            }
            publisher.setPluginPropertyValues(publisherPluginValues);
        }
    }
}

