/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.service.IRouteStatusManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.log4j.Logger;

public class PublisherRoutePolicy
extends RoutePolicySupport {
    private static final Logger logger = Logger.getLogger(PublisherRoutePolicy.class);

    public void onExchangeBegin(Route route, Exchange exchange) {
        try {
            IRouteStatusManager routeStatusManager = (IRouteStatusManager)InjectionUtil.injectInstance((String)"cms/RouteStatusManager/local", IRouteStatusManager.class);
            routeStatusManager.createOrUpdateRouteStatusToRunning(route.getId(), null);
        }
        catch (Exception e) {
            logger.error((Object)(" Failed to mark Route status as running for Route - " + route.getId()));
            logger.error((Object)e.getMessage());
        }
    }

    public void onExchangeDone(Route route, Exchange exchange) {
        try {
            IRouteStatusManager routeStatusManager = (IRouteStatusManager)InjectionUtil.injectInstance((String)"cms/RouteStatusManager/local", IRouteStatusManager.class);
            StringBuilder remark = new StringBuilder();
            Object exception = exchange.getProperty("CamelExceptionCaught");
            if (exception instanceof Exception) {
                remark.append("Run failed");
                String reason = ((Exception)exception).getMessage();
                if (reason != null) {
                    remark.append(" - " + reason);
                }
            } else {
                remark.append(" Run succeeded");
            }
            routeStatusManager.createOrUpdateRouteStatusToStopped(route.getId(), remark.toString());
        }
        catch (Exception e) {
            logger.error((Object)(" Failed to mark Route status as stopped for Route - " + route.getId()));
            logger.error((Object)e.getMessage());
        }
    }
}

