/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.RouteStatus;
import com.ericsson.cms.epgmgmt.entity.enumeration.RouteStateEnum;
import com.ericsson.cms.epgmgmt.service.IRouteStatusManager;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IRouteStatusManager.class})
@Stateless
public class RouteStatusManager
implements IRouteStatusManager {
    private static final Log logger = LogFactory.getLog(RouteStatusManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean createRoute(RouteStatus routeStatus) throws Exception {
        boolean result = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"createRoute(RouteStatus) - start");
        }
        try {
            String validationMsg = this.validateRouteStatus(routeStatus);
            if (!this.isEmpty(validationMsg)) {
                throw new Exception(validationMsg);
            }
            this.entityManager.persist((Object)routeStatus);
            result = true;
        }
        catch (Exception ex) {
            logger.error((Object)"createRoute(RouteStatus)", (Throwable)ex);
            throw ex;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"createRoute(RouteStatus) - end");
        }
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateRoute(RouteStatus routeStatus) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"updateRoute(RouteStatus) - start");
        }
        try {
            String validationMsg = this.validateRouteStatus(routeStatus);
            if (!this.isEmpty(validationMsg)) {
                throw new Exception(validationMsg);
            }
            RouteStatus existingRoute = this.getRouteStatusDetailsById(routeStatus.getRouteId());
            if (existingRoute == null) {
                throw new Exception(String.format("No route with id %s is found.", routeStatus.getRouteId()));
            }
            this.entityManager.merge((Object)routeStatus);
        }
        catch (Exception ex) {
            logger.error((Object)"updateRoute(RouteStatus)", (Throwable)ex);
            throw ex;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"updateRoute(RouteStatus) - end");
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean removeRouteById(String routeId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removeRouteById(String) - start");
        }
        boolean result = false;
        try {
            RouteStatus existingRoute = this.getRouteStatusDetailsById(routeId);
            if (existingRoute == null) {
                logger.trace((Object)(" Route Status for Route " + routeId + " not found and hence can't be deleted"));
                result = false;
            } else {
                this.entityManager.remove((Object)existingRoute);
                result = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"removeRouteById(String)", (Throwable)ex);
            throw ex;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removeRouteById(String) - end");
        }
        return result;
    }

    public RouteStatus getRouteStatusDetailsById(String routeId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRouteStatusDetailsById(String) - start");
        }
        RouteStatus routeStatus = null;
        try {
            Query query = this.entityManager.createNamedQuery("routeStatus.findByRouteId");
            query.setParameter("ROUTEID", (Object)routeId);
            routeStatus = (RouteStatus)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            logger.trace((Object)(" Route status for " + routeId + " not found "));
        }
        catch (Exception ex) {
            logger.error((Object)"getRouteStatusDetailsById(String)", (Throwable)ex);
            throw ex;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRouteStatusDetailsById(String) - end");
        }
        return routeStatus;
    }

    public List<RouteStatus> getRoutesStatus() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRoutesStatus() - start");
        }
        List routeStatusList = null;
        try {
            Query query = this.entityManager.createNamedQuery("routeStatus.findAll");
            routeStatusList = query.getResultList();
        }
        catch (Exception rtEx) {
            logger.error((Object)"getRoutesStatus()", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRoutesStatus() - end");
        }
        return routeStatusList;
    }

    public boolean isRouteCanBeExecutedNow(String routeId, int frequency) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"isRouteCanBeExecutedNow(String, int) - start");
        }
        boolean result = false;
        try {
            RouteStatus route = this.getRouteStatusDetailsById(routeId);
            if (route == null) {
                throw new Exception(String.format("No route with id %s is found.", routeId));
            }
            Date lastRunTime = route.getLastRunStartTime();
            if (lastRunTime == null) {
                result = true;
            } else {
                Calendar nextRunTime = GregorianCalendar.getInstance();
                nextRunTime.setTime(lastRunTime);
                nextRunTime.add(13, frequency);
                Calendar currentTime = GregorianCalendar.getInstance();
                currentTime.setTimeInMillis(System.currentTimeMillis());
                result = currentTime.compareTo(nextRunTime) >= 0;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"isRouteCanBeExecutedNow(String, int)", (Throwable)ex);
            throw ex;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"isRouteCanBeExecutedNow(String, int) - end");
        }
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public long getLastRunStartTimeInMillis(String routeId) throws Exception {
        RouteStatus routeStatus = this.getRouteStatusDetailsById(routeId);
        if (routeStatus == null) {
            return 0L;
        }
        return routeStatus.getLastRunStartTime().getTime();
    }

    private String validateRouteStatus(RouteStatus routeStatus) {
        StringBuffer errorMsg = new StringBuffer();
        if (routeStatus == null) {
            errorMsg.append("Invalid Route Status details - the object value is null.");
            return errorMsg.toString();
        }
        if (this.isEmpty(routeStatus.getRouteId())) {
            errorMsg.append(String.format("Invalid Route Id %s. Route Id can not be null or empty. ", routeStatus.getRouteId()));
        }
        if (routeStatus.getLastRunStartTime() == null) {
            errorMsg.append(String.format("Invalid LastRunStartTime value. LastRunStartTime can not be null or empty. ", new Object[0]));
        }
        return errorMsg.toString();
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public boolean createOrUpdateRouteStatusToRunning(String routeId, String remark) throws Exception {
        RouteStatus existingRoute = this.getRouteStatusDetailsById(routeId);
        if (existingRoute == null) {
            RouteStatus routeStatus = new RouteStatus();
            routeStatus.setState(RouteStateEnum.RUNNING);
            routeStatus.setRouteId(routeId);
            routeStatus.setLastRunStartTime(new Date());
            routeStatus.setLastRunEndTime(null);
            routeStatus.setRemarks(remark);
            logger.trace((Object)(" Creating new RouteStatus - " + routeStatus.toString()));
            return this.createRoute(routeStatus);
        }
        logger.trace((Object)existingRoute.toString());
        if (existingRoute.isRunning()) {
            logger.debug((Object)(" Existing route detected to be running " + existingRoute.toString()));
        } else {
            existingRoute.setState(RouteStateEnum.RUNNING);
        }
        existingRoute.setLastRunStartTime(new Date());
        existingRoute.setLastRunEndTime(null);
        existingRoute.setRemarks(remark);
        this.updateRoute(existingRoute);
        return true;
    }

    public boolean createOrUpdateRouteStatusToStopped(String routeId, String remark) throws Exception {
        RouteStatus existingRoute = this.getRouteStatusDetailsById(routeId);
        if (existingRoute == null) {
            logger.error((Object)(" RouteStatus not found for Route " + routeId));
            RouteStatus routeStatus = new RouteStatus();
            routeStatus.setState(RouteStateEnum.STOPPED);
            routeStatus.setRouteId(routeId);
            routeStatus.setLastRunStartTime(new Date());
            routeStatus.setLastRunEndTime(new Date());
            if (remark == null) {
                remark = "";
            }
            routeStatus.setRemarks(remark + " RouteStatus RUNNING entry not found earlier!");
            return this.createRoute(routeStatus);
        }
        logger.trace((Object)existingRoute.toString());
        if (existingRoute.isStopped()) {
            logger.trace((Object)(" Existing route detected to have been already stopped " + existingRoute.toString()));
            existingRoute.setRemarks("RouteStatus STOPPED entry already existed!");
        } else {
            existingRoute.setState(RouteStateEnum.STOPPED);
        }
        existingRoute.setLastRunEndTime(new Date());
        existingRoute.setRemarks(remark);
        this.updateRoute(existingRoute);
        return true;
    }
}

