/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager;

import com.ericsson.cms.epgmgmt.entity.Headend;
import com.ericsson.cms.epgmgmt.entity.Station;
import com.ericsson.cms.epgmgmt.entity.enumeration.PGSortPropertyEnum;
import com.ericsson.cms.epgmgmt.service.IStationManager;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless
public class StationManager
implements IStationManager {
    @PersistenceContext(unitName="epgmanagerjpaunit")
    private EntityManager entityManager;
    private static final Log log = LogFactory.getLog(StationManager.class);

    public List<Station> getStations(int start, int count, Headend headend, PGSortPropertyEnum sortProperty, boolean isAscending) {
        try {
            String orderBy = " ORDER BY ";
            switch (sortProperty) {
                case callSign: {
                    orderBy = orderBy + "st.callSign";
                    break;
                }
                case stationId: {
                    orderBy = orderBy + "st.stationId";
                    break;
                }
                case affiliation: {
                    orderBy = orderBy + "st.affiliation";
                    break;
                }
            }
            orderBy = isAscending ? orderBy + " asc" : orderBy + " desc";
            String queryStr = "SELECT st FROM Station st LEFT JOIN st.lineups lu LEFT JOIN lu.headend he WHERE he.headendId = :HEADENDID " + orderBy;
            Query query = this.entityManager.createQuery(queryStr);
            query.setParameter("HEADENDID", (Object)headend.getHeadendId());
            query.setFirstResult(start);
            if (count > 0) {
                query.setMaxResults(count);
            }
            List result = query.getResultList();
            return result;
        }
        catch (RuntimeException e) {
            log.error((Object)"get failed", (Throwable)e);
            throw e;
        }
    }

    public void create(Station st) {
        try {
            this.validateStation();
            this.entityManager.persist((Object)st);
        }
        catch (RuntimeException e) {
            log.error((Object)"create failed", (Throwable)e);
            throw e;
        }
    }

    public void update(Station st) {
        try {
            this.validateStation();
            this.entityManager.merge((Object)st);
        }
        catch (RuntimeException e) {
            log.error((Object)"update failed", (Throwable)e);
            throw e;
        }
    }

    private void validateStation() {
    }

    public int count(Headend headend, PGSortPropertyEnum sortProperty, boolean isAscending) {
        try {
            String orderBy = " ORDER BY ";
            switch (sortProperty) {
                case callSign: {
                    orderBy = orderBy + "st.callSign";
                    break;
                }
                case stationId: {
                    orderBy = orderBy + "st.stationId";
                    break;
                }
                case affiliation: {
                    orderBy = orderBy + "st.affiliation";
                    break;
                }
            }
            orderBy = isAscending ? orderBy + " asc" : orderBy + " desc";
            String queryStr = "SELECT count(*) FROM Station st LEFT JOIN st.lineups lu LEFT JOIN lu.headend he WHERE he.headendId = :HEADENDID " + orderBy;
            Query query = this.entityManager.createQuery(queryStr);
            query.setParameter("HEADENDID", (Object)headend.getHeadendId());
            long count = (Long)query.getSingleResult();
            return (int)count;
        }
        catch (RuntimeException e) {
            log.error((Object)"get failed", (Throwable)e);
            throw e;
        }
    }
}

