/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager.listener;

import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entitymanager.listener.EntityListener;
import java.util.List;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import org.apache.camel.Route;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProviderListener
extends EntityListener<Provider> {
    private static final Log logger = LogFactory.getLog(ProviderListener.class);

    @PostUpdate
    void onPostUpdate(Provider updatedProvider) {
        logger.trace((Object)"In onPostUpdate..");
        this.getCamelManager().removeProviderRoute(updatedProvider);
        if (updatedProvider.isActive()) {
            this.getCamelManager().createProviderRoute(updatedProvider);
        }
        List routes = this.getCamelManager().getCamelContext().getRoutes();
        StringBuilder sb = new StringBuilder(500);
        sb.append("" + routes.size() + " routes in Camel now after updating the provider. \n");
        for (Route route : routes) {
            sb.append("\tid: " + route.getId() + " Endpoint  :" + route.getEndpoint().getEndpointUri() + "\n");
        }
        logger.info((Object)sb.toString());
    }

    @PostPersist
    void onPostPersist(Provider newProvider) {
        logger.trace((Object)"In onPostPersist..");
        this.getCamelManager().createProviderRoute(newProvider);
    }

    @PostRemove
    void onPostRemove(Provider deletedProvider) {
        logger.trace((Object)"In onPostRemove..");
        deletedProvider.setActive(false);
        this.getCamelManager().removeProviderRoute(deletedProvider);
    }
}

