/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager.listener;

import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entitymanager.listener.EntityListener;
import com.ericsson.cms.epgmgmt.service.ICamelManager;
import com.ericsson.cms.epgmgmt.service.PublisherRouteBuilder;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublisherListener
extends EntityListener<Publisher> {
    private static final Log logger = LogFactory.getLog(PublisherListener.class);

    @PostUpdate
    void onPostUpdate(Publisher updatedPublisher) {
        logger.trace((Object)"In onPostUpdate..");
        ICamelManager camelManager = this.getCamelManager();
        if (camelManager.getCamelContext().getRoute(PublisherRouteBuilder.getRouteName(updatedPublisher)) != null) {
            camelManager.removePublisherRoute(updatedPublisher);
        }
        camelManager.createPublisherRoute(updatedPublisher);
    }

    @PostPersist
    void onPostPersist(Publisher newPublisher) {
        logger.trace((Object)"In onPostPersist..");
        this.getCamelManager().createPublisherRoute(newPublisher);
    }

    @PostRemove
    void onPostRemove(Publisher deletedPublisher) {
        logger.trace((Object)"In onPostRemove..");
        deletedPublisher.setActive(false);
        this.getCamelManager().removePublisherRoute(deletedPublisher);
    }
}

