/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager.rule;

import com.ericsson.cms.epgmgmt.entity.rule.EntityMapping;
import com.ericsson.cms.epgmgmt.service.IEntityMappingManager;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IEntityMappingManager.class})
@Stateless
public class EntityMappingManager
implements IEntityMappingManager {
    private static final Log logger = LogFactory.getLog(EntityMappingManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    public List<EntityMapping> getEntityMappings() {
        List entityMappingsList = null;
        try {
            Query query = this.entityManager.createNamedQuery("EntityMapping.findAll");
            entityMappingsList = query.getResultList();
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)rtEx);
            throw rtEx;
        }
        return entityMappingsList;
    }

    public List<EntityMapping> getEntityMappingsByTable(String tableName) {
        List entityMappingsList = null;
        try {
            Query query = this.entityManager.createNamedQuery("EntityMapping.byTable");
            query.setParameter("TABLENAME", (Object)tableName);
            entityMappingsList = query.getResultList();
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)rtEx);
            throw rtEx;
        }
        return entityMappingsList;
    }

    public EntityMapping getEntityMappingByName(String name) {
        EntityMapping entityMapping = null;
        try {
            Query query = this.entityManager.createNamedQuery("EntityMapping.byName");
            query.setParameter("NAME", (Object)name);
            entityMapping = (EntityMapping)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            return entityMapping;
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)rtEx);
            throw rtEx;
        }
        return entityMapping;
    }

    public EntityMapping getEntityMapping(long id) {
        EntityMapping entityMapping = null;
        try {
            entityMapping = (EntityMapping)this.entityManager.find(EntityMapping.class, (Object)id);
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)rtEx);
            throw rtEx;
        }
        return entityMapping;
    }
}

