/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager.rule;

import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.rule.NormalizationGroup;
import com.ericsson.cms.epgmgmt.entity.rule.NormalizationRule;
import com.ericsson.cms.epgmgmt.service.EpgmgmtException;
import com.ericsson.cms.epgmgmt.service.INormalizationGroupManager;
import com.ericsson.cms.epgmgmt.validation.ErrorMessages;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={INormalizationGroupManager.class})
@Stateless
public class NormalizationGroupManager
implements INormalizationGroupManager {
    private static final Log logger = LogFactory.getLog(NormalizationGroupManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    public void create(NormalizationGroup normalizationGroup) {
        try {
            if (this.isDuplicateExists(normalizationGroup)) {
                throw new RuntimeException(new EpgmgmtException(ErrorMessages.getString("epgmgmt.rulesetname.duplicate")));
            }
            this.entityManager.merge((Object)normalizationGroup);
        }
        catch (RuntimeException re) {
            logger.error((Object)"Failed to save the Normalization Rules Group", (Throwable)re);
            throw re;
        }
    }

    public void update(NormalizationGroup normalizationGroup) {
        try {
            if (this.isDuplicateExists(normalizationGroup)) {
                throw new RuntimeException(new EpgmgmtException(ErrorMessages.getString("epgmgmt.rulesetname.duplicate")));
            }
            this.entityManager.merge((Object)normalizationGroup);
        }
        catch (RuntimeException re) {
            logger.error((Object)"Failed to save the Normalization Rules Group", (Throwable)re);
            throw re;
        }
    }

    public NormalizationGroup getGroup(long groupId) {
        return (NormalizationGroup)this.entityManager.find(NormalizationGroup.class, (Object)groupId);
    }

    public void removeNormalizationGroupById(long groupId) {
        this.entityManager.remove((Object)this.getGroup(groupId));
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void disasociateRulesFromGroup(long gorupId, List<Long> rules) {
        StringBuffer ruleIds = new StringBuffer();
        int count = 0;
        for (Long ruleId : rules) {
            if (count == 1000) break;
            ruleIds.append(ruleId).append(",");
        }
        if (ruleIds.length() == 0) {
            return;
        }
        ruleIds.delete(ruleIds.lastIndexOf(","), ruleIds.length()).append(" ");
        Query query = this.entityManager.createNativeQuery("DELETE NORM_GROUP_RULE_MAPPING WHERE NORM_RULE_GROUP_ID = :groupId and RULE_ID IN(:ruleIds)");
        query.setParameter("groupId", (Object)gorupId);
        query.setParameter("ruleIds", (Object)ruleIds.toString());
        query.executeUpdate();
        this.entityManager.flush();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void disasociateProvidersFromGroup(long gorupId, List<Long> providers) {
        StringBuffer providerIds = new StringBuffer();
        int count = 0;
        for (Long providerId : providers) {
            if (count == 1000) break;
            providerIds.append(providerId).append(",");
        }
        if (providerIds.length() == 0) {
            return;
        }
        providerIds.delete(providerIds.lastIndexOf(","), providerIds.length()).append(" ");
        Query query = this.entityManager.createNativeQuery("DELETE PROVIDER_NORM_GROUP_MAPPING WHERE NORM_GROUP_ID = :groupId and PROVIDER_ID IN(:providerIds)");
        query.setParameter("groupId", (Object)gorupId);
        query.setParameter("providerIds", (Object)providerIds.toString());
        query.executeUpdate();
        this.entityManager.flush();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void disasociatePublishersFromGroup(long gorupId, List<Long> publishers) {
        StringBuffer publisherIds = new StringBuffer();
        int count = 0;
        for (Long providerId : publishers) {
            if (count == 1000) break;
            publisherIds.append(providerId).append(",");
        }
        if (publisherIds.length() == 0) {
            return;
        }
        publisherIds.delete(publisherIds.lastIndexOf(","), publisherIds.length()).append(" ");
        Query query = this.entityManager.createNativeQuery("DELETE PUBLISHER_NORM_GROUP_MAPPING WHERE NORM_GROUP_ID = :groupId and PUBLISHER_ID IN(:publisherIds)");
        query.setParameter("groupId", (Object)gorupId);
        query.setParameter("publisherIds", (Object)publisherIds.toString());
        query.executeUpdate();
        this.entityManager.flush();
    }

    public NormalizationGroup getGroupByName(String name) {
        NormalizationGroup nGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.byName");
            query.setParameter("NAME", (Object)name);
            nGroup = (NormalizationGroup)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            return nGroup;
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
        return nGroup;
    }

    public List<NormalizationRule> getAllRuleAssociationsById(long groupId) {
        List nGroupRules = null;
        NormalizationGroup nGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.allRuleAssociationsById");
            query.setParameter("ID", (Object)groupId);
            nGroup = (NormalizationGroup)query.getSingleResult();
            if (nGroup != null) {
                nGroupRules = nGroup.getRules();
            }
        }
        catch (NoResultException etEx) {
            return nGroupRules;
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
        return nGroupRules;
    }

    public List<Provider> getAllProviderAssociationsById(long groupId) {
        List nGroupProviders = null;
        NormalizationGroup nGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.allProviderAssociationsById");
            query.setParameter("ID", (Object)groupId);
            nGroup = (NormalizationGroup)query.getSingleResult();
            if (nGroup != null) {
                nGroupProviders = nGroup.getProviders();
            }
        }
        catch (NoResultException etEx) {
            return nGroupProviders;
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
        return nGroupProviders;
    }

    public List<Publisher> getAllPublisherAssociationsById(long groupId) {
        List nGroupPublishers = null;
        NormalizationGroup nGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.allPublisherAssociationsById");
            query.setParameter("ID", (Object)groupId);
            nGroup = (NormalizationGroup)query.getSingleResult();
            if (nGroup != null) {
                nGroupPublishers = nGroup.getPublishers();
            }
        }
        catch (NoResultException etEx) {
            return nGroupPublishers;
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
        return nGroupPublishers;
    }

    public Set<NormalizationGroup> getAllGlobalForProviders() {
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.allGlobalForProviders");
            List nGroup = query.getResultList();
            return new HashSet<NormalizationGroup>(nGroup);
        }
        catch (NoResultException etEx) {
            return new HashSet<NormalizationGroup>(0);
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
    }

    public Set<NormalizationGroup> getAllGlobalForPublishers() {
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.allGlobalForPublishers");
            List nGroup = query.getResultList();
            return new HashSet<NormalizationGroup>(nGroup);
        }
        catch (NoResultException etEx) {
            return new HashSet<NormalizationGroup>(0);
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
    }

    public Set<NormalizationGroup> getAllNormalizationGroups() {
        try {
            Query query = this.entityManager.createNamedQuery("NormalizationGroup.findAll");
            List rulesList = query.getResultList();
            return new HashSet<NormalizationGroup>(rulesList);
        }
        catch (NoResultException etEx) {
            return new HashSet<NormalizationGroup>(0);
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
    }

    public List<NormalizationGroup> getAllNormalizationGroups(String sortProperty, boolean isAscending) {
        try {
            SearchCriteria criteria = new SearchCriteria();
            Entity e = new Entity("normalizationgroup", NormalizationGroup.class, "norm");
            SortingOrder sortOrder = SortingOrder.ASCENDING;
            if (!isAscending) {
                sortOrder = SortingOrder.DESCENDING;
            }
            e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
            criteria.addParameter((SearchParameterBase)e);
            String s = QueryBuilder.newInstance().buildQuery(criteria);
            Query query = this.entityManager.createQuery(s);
            List rulesList = query.getResultList();
            return rulesList;
        }
        catch (NoResultException etEx) {
            return new ArrayList<NormalizationGroup>(0);
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
    }

    public void enableGroup(long id) {
        NormalizationGroup vg = this.getGroup(id);
        vg.setEnabled(true);
        this.update(vg);
    }

    public void disableGroup(long id) {
        NormalizationGroup vg = this.getGroup(id);
        vg.setEnabled(false);
        this.update(vg);
    }

    private boolean isDuplicateExists(NormalizationGroup normalizationGroup) {
        NormalizationGroup persistedObject = this.getGroupByName(normalizationGroup.getName());
        return persistedObject != null && persistedObject.getId() != normalizationGroup.getId();
    }
}

