/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager.rule;

import com.ericsson.cms.epgmgmt.entity.rule.Rule;
import com.ericsson.cms.epgmgmt.entity.rule.predicate.Predicate;
import com.ericsson.cms.epgmgmt.service.IEntityMappingManager;
import com.ericsson.cms.epgmgmt.service.IRuleManager;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IRuleManager.class})
@Stateless
public class RuleManager<P extends Predicate>
implements IRuleManager<P> {
    private static final Log logger = LogFactory.getLog(RuleManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;
    @EJB
    IEntityMappingManager entityMappingManager;

    public void create(Rule<P> rule) {
        this.entityManager.persist(rule);
    }

    public void update(Rule<P> rule) {
        this.entityManager.merge(rule);
    }

    public Rule<P> getRule(long ruleId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRule(long) - start");
        }
        Rule rule = null;
        try {
            rule = (Rule)this.entityManager.find(Rule.class, (Object)ruleId);
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"getRule(long)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRule(long) - end");
        }
        return rule;
    }

    public Rule<P> getRuleByName(String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRuleByName(String) - start");
        }
        Rule rule = null;
        try {
            Query query = this.entityManager.createNamedQuery("Rule.byName");
            query.setParameter("NAME", (Object)name);
            rule = (Rule)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getRuleByName(String) - end");
            }
            return rule;
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"getRuleByName(String)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRuleByName(String) - end");
        }
        return rule;
    }

    public void deleteRule(long ruleId) {
        this.entityManager.remove(this.getRule(ruleId));
    }

    public List<Rule<P>> getAllRulesByRuleType(String type) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllRulesByRuleType(String) - start");
        }
        List rules = null;
        try {
            Query query = this.entityManager.createNamedQuery("Rule.findAllByRuleType");
            query.setParameter("RULETYPE", (Object)type);
            rules = query.getResultList();
        }
        catch (RuntimeException rtEx) {
            logger.error((Object)"getAllRulesByRuleType(String)", (Throwable)rtEx);
            throw rtEx;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllRulesByRuleType(String) - end");
        }
        return rules;
    }
}

