/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entitymanager.rule;

import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.rule.ValidationGroup;
import com.ericsson.cms.epgmgmt.entity.rule.ValidationRule;
import com.ericsson.cms.epgmgmt.service.EpgmgmtException;
import com.ericsson.cms.epgmgmt.service.IProviderManager;
import com.ericsson.cms.epgmgmt.service.IValidationGroupManager;
import com.ericsson.cms.epgmgmt.validation.ErrorMessages;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IValidationGroupManager.class})
@Stateless
public class ValidationGroupManager
implements IValidationGroupManager {
    private static final Log logger = LogFactory.getLog(ValidationGroupManager.class);
    @PersistenceContext(unitName="epgmanagerjpaunit", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;
    @EJB
    IProviderManager providerManager;

    public void create(ValidationGroup validationGroup) {
        try {
            if (this.isDuplicateExists(validationGroup)) {
                throw new RuntimeException(new EpgmgmtException(ErrorMessages.getString("epgmgmt.rulesetname.duplicate")));
            }
            this.entityManager.merge((Object)validationGroup);
        }
        catch (RuntimeException re) {
            logger.error((Object)"Failed to save the Validation Rules Group", (Throwable)re);
            throw re;
        }
    }

    public void update(ValidationGroup validationGroup) {
        try {
            if (this.isDuplicateExists(validationGroup)) {
                throw new RuntimeException(new EpgmgmtException(ErrorMessages.getString("epgmgmt.rulesetname.duplicate")));
            }
            this.entityManager.merge((Object)validationGroup);
        }
        catch (RuntimeException re) {
            logger.error((Object)"Failed to save the Validation Rules Group", (Throwable)re);
            throw re;
        }
    }

    public ValidationGroup getGroup(long groupId) {
        return (ValidationGroup)this.entityManager.find(ValidationGroup.class, (Object)groupId);
    }

    public void removeValidationGroupById(long groupId) {
        this.entityManager.remove((Object)this.getGroup(groupId));
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void disasociateRulesFromGroup(long gorupId, List<Long> rules) {
        StringBuffer ruleIds = new StringBuffer();
        int count = 0;
        for (Long ruleId : rules) {
            if (count == 1000) break;
            ruleIds.append(ruleId).append(",");
        }
        if (ruleIds.length() == 0) {
            return;
        }
        ruleIds.delete(ruleIds.lastIndexOf(","), ruleIds.length()).append(" ");
        Query query = this.entityManager.createNativeQuery("DELETE VALID_GROUP_RULE_MAPPING WHERE VALID_RULE_GROUP_ID = :groupId and RULE_ID IN(:ruleIds)");
        query.setParameter("groupId", (Object)gorupId);
        query.setParameter("ruleIds", (Object)ruleIds.toString());
        query.executeUpdate();
        this.entityManager.flush();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void disasociateProvidersFromGroup(long gorupId, List<Long> providers) {
        StringBuffer providerIds = new StringBuffer();
        int count = 0;
        for (Long providerId : providers) {
            if (count == 1000) break;
            providerIds.append(providerId).append(",");
        }
        if (providerIds.length() == 0) {
            return;
        }
        providerIds.delete(providerIds.lastIndexOf(","), providerIds.length()).append(" ");
        Query query = this.entityManager.createNativeQuery("DELETE PROVIDER_VALID_GROUP_MAPPING WHERE VALID_GROUP_ID = :groupId and PROVIDER_ID IN(:providerIds)");
        query.setParameter("groupId", (Object)gorupId);
        query.setParameter("providerIds", (Object)providerIds.toString());
        query.executeUpdate();
        this.entityManager.flush();
    }

    public ValidationGroup getGroupByName(String name) {
        ValidationGroup vGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("ValidationGroup.byName");
            query.setParameter("NAME", (Object)name);
            vGroup = (ValidationGroup)query.getSingleResult();
        }
        catch (NoResultException etEx) {
            return vGroup;
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
        return vGroup;
    }

    public List<ValidationRule> getAllRuleAssociationsById(long groupId) {
        List vGroupRules = null;
        ValidationGroup vGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("ValidationGroup.allRuleAssociationsById");
            query.setParameter("ID", (Object)groupId);
            vGroup = (ValidationGroup)query.getSingleResult();
            if (vGroup != null) {
                vGroupRules = vGroup.getRules();
            }
        }
        catch (NoResultException etEx) {
            return vGroupRules;
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
        return vGroupRules;
    }

    public List<Provider> getAllProviderAssociationsById(long groupId) {
        List vGroupProviders = null;
        ValidationGroup vGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("ValidationGroup.allProviderAssociationsById");
            query.setParameter("ID", (Object)groupId);
            vGroup = (ValidationGroup)query.getSingleResult();
            if (vGroup != null) {
                vGroupProviders = vGroup.getProviders();
            }
        }
        catch (NoResultException etEx) {
            return vGroupProviders;
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
        return vGroupProviders;
    }

    public Set<ValidationGroup> getAllGlobalGroups() {
        try {
            Query query = this.entityManager.createNamedQuery("ValidationGroup.allGlobalRules");
            List nGroup = query.getResultList();
            return new HashSet<ValidationGroup>(nGroup);
        }
        catch (NoResultException etEx) {
            return new HashSet<ValidationGroup>(0);
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
    }

    public Set<ValidationGroup> getAllValidationGroups() {
        try {
            Query query = this.entityManager.createNamedQuery("ValidationGroup.findAll");
            List rulesList = query.getResultList();
            return new HashSet<ValidationGroup>(rulesList);
        }
        catch (NoResultException etEx) {
            return new HashSet<ValidationGroup>(0);
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
    }

    public List<ValidationGroup> getAllValidationGroups(String sortProperty, boolean isAscending) {
        try {
            SearchCriteria criteria = new SearchCriteria();
            Entity e = new Entity("validationgroup", ValidationGroup.class, "valid");
            SortingOrder sortOrder = SortingOrder.ASCENDING;
            if (!isAscending) {
                sortOrder = SortingOrder.DESCENDING;
            }
            e.addParameter((SearchParameterBase)new SortParameter(sortProperty, sortOrder));
            criteria.addParameter((SearchParameterBase)e);
            String s = QueryBuilder.newInstance().buildQuery(criteria);
            Query query = this.entityManager.createQuery(s);
            List rulesList = query.getResultList();
            return rulesList;
        }
        catch (NoResultException etEx) {
            return new ArrayList<ValidationGroup>(0);
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
    }

    public void enableGroup(long id) {
        ValidationGroup vg = this.getGroup(id);
        vg.setEnabled(true);
        this.update(vg);
    }

    public void disableGroup(long id) {
        ValidationGroup vg = this.getGroup(id);
        vg.setEnabled(false);
        this.update(vg);
    }

    private boolean isDuplicateExists(ValidationGroup validationGroup) {
        ValidationGroup persistedObject = this.getGroupByName(validationGroup.getName());
        return persistedObject != null && persistedObject.getId() != validationGroup.getId();
    }
}

