/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export;

import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.ExportETVTypeEnum;
import com.ericsson.cms.epgmgmt.export.IEPGExportGuideData;
import com.ericsson.cms.epgmgmt.export.worker.GuideDataExporter;
import com.ericsson.cms.epgmgmt.export.worker.future.GEUtil;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.sql.DataSource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IEPGExportGuideData.class})
@Stateless
public class EPGExportGudieData
implements IEPGExportGuideData {
    private static final Log logger = LogFactory.getLog(EPGExportGudieData.class);
    private static final int maxMapSize = 50;
    @EJB
    private IAlarmActivityLogManager applicationLogger;
    @Resource(mappedName="java:/epgmanager")
    DataSource datasource;
    private static Map<String, GuideDataExporter> activeEPGExporters = new LinkedHashMap<String, GuideDataExporter>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, GuideDataExporter> eldest) {
            return this.size() > 50;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void exportGuideData(String publisherName, ExportETVTypeEnum etvFormat, String tempFolder) throws ExportToXMLException {
        block7: {
            logger.debug((Object)"exportGuideData(String, ExportETVTypeEnum, String) - start");
            long startTime = System.currentTimeMillis();
            try {
                this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.EXPORT_TO_XML, String.format("Starting XML generation for publisher %s ", publisherName));
                GuideDataExporter gde = new GuideDataExporter(etvFormat, tempFolder, this.datasource);
                activeEPGExporters.put(publisherName, gde);
                boolean result = gde.execute();
                if (result) {
                    this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.EXPORT_TO_XML, String.format("Finished XML generation for publisher %s (took %s)", publisherName, GEUtil.getTimeTook(System.currentTimeMillis() - startTime)));
                }
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException || ExceptionUtils.getRootCauseMessage((Throwable)ex).contains("InterruptedException")) {
                    logger.warn((Object)("exportGuideData(String, ExportETVTypeEnum, String) - " + PluginLogComponent.EXPORT_TO_XML.toString() + " was interrupted"));
                    this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.EXPORT_TO_XML, String.format("Canceled XML generation for publisher %s (took %s)", publisherName, GEUtil.getTimeTook(System.currentTimeMillis() - startTime)));
                    break block7;
                }
                logger.error((Object)("exportGuideData(String, ExportETVTypeEnum, String) - " + PluginLogComponent.EXPORT_TO_XML.toString()), (Throwable)ex);
                this.applicationLogger.log(PluginLogSeverity.CRITICAL, PluginLogComponent.EXPORT_TO_XML, String.format("Error found during XML generation for publisher %s. Check for string '%s' in jboss log for more details. Reason for failure: %s", publisherName, PluginLogComponent.EXPORT_TO_XML.toString(), ex.getLocalizedMessage()));
                throw ExportToXMLException.wrapper((String)ex.getMessage(), (Exception)ex);
            }
            finally {
                activeEPGExporters.remove(publisherName);
            }
        }
        logger.debug((Object)"exportGuideData(String, ExportETVTypeEnum, String) - end");
    }

    @Override
    public void stopExportingGuideData(String publisherName) {
        GuideDataExporter gde = activeEPGExporters.get(publisherName);
        if (gde == null) {
            logger.debug((Object)"stopExportingGuideData() - no active GuideDataExporter");
            return;
        }
        gde.shutdown();
        activeEPGExporters.remove(publisherName);
    }
}

