/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker;

import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.ExportETVTypeEnum;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDHEADEND;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUP;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAM;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.worker.consumer.GuideDataConsumer;
import com.ericsson.cms.epgmgmt.export.worker.future.GEConsumer;
import com.ericsson.cms.epgmgmt.export.worker.future.GEProducer;
import com.ericsson.cms.epgmgmt.export.worker.future.GEResult;
import com.ericsson.cms.epgmgmt.export.worker.future.GEUtil;
import com.ericsson.cms.epgmgmt.export.worker.future.InputStreamEnumerator;
import com.ericsson.cms.epgmgmt.export.worker.producer.GuideDataProducer;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuideDataExporter {
    private static final Log logger = LogFactory.getLog(GuideDataExporter.class);
    private BlockingQueue<RowTypeSGDHEADEND> headendQueue = new ArrayBlockingQueue<RowTypeSGDHEADEND>(10);
    private BlockingQueue<RowTypeSGDLINEUP> lineupQueue = new ArrayBlockingQueue<RowTypeSGDLINEUP>(200);
    private BlockingQueue<RowTypeSGDSTATION> stationQueue = new ArrayBlockingQueue<RowTypeSGDSTATION>(200);
    private BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue = new ArrayBlockingQueue<RowTypeSGDSCHEDULE>(10000);
    private BlockingQueue<RowTypeSGDPROGRAM> programQueue = new ArrayBlockingQueue<RowTypeSGDPROGRAM>(10000);
    private ExportETVTypeEnum etvFormat;
    private String tempFolder;
    private DataSource datasource;
    private ExecutorService geExecutor;
    private GuideDataProducer guideDataProducer;
    private GuideDataConsumer guideDataConsumer;

    public GuideDataExporter(ExportETVTypeEnum etvFormat, String tempFolder, DataSource datasource) {
        this.etvFormat = etvFormat;
        this.datasource = datasource;
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"execute() - start");
        }
        boolean result = true;
        this.geExecutor = Executors.newFixedThreadPool(2);
        try {
            ExecutorCompletionService<GEResult> geService = new ExecutorCompletionService<GEResult>(this.geExecutor);
            long sTime = System.currentTimeMillis();
            this.guideDataProducer = new GuideDataProducer(this.headendQueue, this.lineupQueue, this.stationQueue, this.scheduleQueue, this.programQueue, this.etvFormat, this.datasource);
            this.guideDataConsumer = new GuideDataConsumer(this.headendQueue, this.lineupQueue, this.stationQueue, this.scheduleQueue, this.programQueue, this.etvFormat, this.tempFolder);
            geService.submit(this.guideDataProducer);
            geService.submit(this.guideDataConsumer);
            for (int i = 0; i < 2; ++i) {
                Future geResult = geService.take();
                if (geResult.get() instanceof GEProducer) {
                    logger.debug((Object)String.format("%s - Guide Data Producer done with its tasks (took %s).", PluginLogComponent.EXPORT_TO_XML, GEUtil.getTimeTook(System.currentTimeMillis() - sTime)));
                }
                if (!(geResult.get() instanceof GEConsumer)) continue;
                boolean fileResult = this.mergeGudieData();
                logger.debug((Object)String.format("%s - Is GuideDataOut.xml generated successfully? %s.", PluginLogComponent.EXPORT_TO_XML, fileResult));
                logger.debug((Object)String.format("%s - Guide Data Consumer done with its tasks (took %s).", PluginLogComponent.EXPORT_TO_XML, GEUtil.getTimeTook(System.currentTimeMillis() - sTime)));
                break;
            }
        }
        catch (ExecutionException ex) {
            this.handleException(ex);
        }
        catch (InterruptedException ex) {
            this.handleException(ex);
        }
        finally {
            if (this.geExecutor != null) {
                this.geExecutor.shutdown();
            }
            this.datasource = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"execute() - end");
        }
        return result;
    }

    private void handleException(Exception ex) {
        if (ex instanceof InterruptedException || ex.getMessage().contains("InterruptedException")) {
            logger.warn((Object)("execute()- " + PluginLogComponent.EXPORT_TO_XML.toString() + " was interrupted"));
        } else {
            logger.error((Object)("execute()- " + PluginLogComponent.EXPORT_TO_XML.toString()), (Throwable)ex);
        }
        throw ExportToXMLException.wrapper((String)ex.getMessage(), (Exception)ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mergeGudieData() {
        logger.debug((Object)"mergeGudieData() - start");
        boolean result = true;
        InputStream gdInputFile = null;
        OutputStream gdOutputFile = null;
        try {
            int c;
            ArrayList<String> files = new ArrayList<String>();
            files.add(this.getTempFile("rowHeadEnd.xml"));
            files.add(this.getTempFile("rowLineup.xml"));
            files.add(this.getTempFile("rowStation.xml"));
            if (!GEUtil.isETVMIX(this.etvFormat)) {
                files.add(this.getTempFile("rowSchedule.xml"));
            }
            files.add(this.getTempFile("rowProgram.xml"));
            InputStreamEnumerator ipSteamEnum = new InputStreamEnumerator(files);
            gdInputFile = new SequenceInputStream(ipSteamEnum);
            gdOutputFile = new FileOutputStream(this.getTempFile("GuideDataOut.xml"));
            gdOutputFile.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            gdOutputFile.write("<GuideData xmlns:fn=\"http://www.w3.org/2005/02/xpath-functions\" xmlns:xdt=\"http://www.w3.org/2005/xpath-datatypes\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"ETV_EPG".getBytes());
            if (this.etvFormat.name().equalsIgnoreCase(ExportETVTypeEnum.ETV_18.name())) {
                gdOutputFile.write(".xsd\" Spec_Version=\"1.8\"".getBytes());
            } else if (this.etvFormat.name().equalsIgnoreCase(ExportETVTypeEnum.ETV_20.name())) {
                gdOutputFile.write(".xsd\" Spec_Version=\"2.0\"".getBytes());
            } else if (this.etvFormat.name().equalsIgnoreCase(ExportETVTypeEnum.ETV_MIX.name())) {
                gdOutputFile.write("_MIX.xsd\" Spec_Version=\"3.0\"".getBytes());
            }
            gdOutputFile.write(">\n<SlicerGuideData>\n".getBytes());
            byte[] buf = new byte[102400];
            while ((c = gdInputFile.read(buf)) != -1) {
                gdOutputFile.write(buf, 0, c);
            }
            gdOutputFile.write("</SlicerGuideData>\n</GuideData>".getBytes());
        }
        catch (Exception ex) {
            logger.error((Object)("mergeGudieData()- " + PluginLogComponent.EXPORT_TO_XML.toString()), (Throwable)ex);
            result = false;
        }
        finally {
            try {
                if (gdInputFile != null) {
                    gdInputFile.close();
                }
                if (gdOutputFile != null) {
                    gdOutputFile.close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)("mergeGudieData()- " + PluginLogComponent.EXPORT_TO_XML.toString()), (Throwable)ex);
            }
        }
        logger.debug((Object)"mergeGudieData() - end");
        return result;
    }

    private String getTempFile(String tempFile) {
        return this.tempFolder + System.getProperty("file.separator") + tempFile;
    }

    public void shutdown() {
        if (this.guideDataProducer != null) {
            this.guideDataProducer.shutdownNow();
            this.guideDataProducer = null;
        } else {
            logger.debug((Object)"GuideDataExporter:shutdown() - guideDataProducer has already been shut down.");
        }
        if (this.guideDataConsumer != null) {
            this.guideDataConsumer.shutdownNow();
            this.guideDataConsumer = null;
        } else {
            logger.debug((Object)"GuideDataExporter:shutdown() - guideDataConsumer has already been shut down.");
        }
        if (this.geExecutor != null) {
            this.geExecutor.shutdown();
            this.geExecutor = null;
        } else {
            logger.debug((Object)"GuideDataExporter:shutdown() - geExecutor has already been shut down.");
        }
    }
}

