/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.consumer;

import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.ExportETVTypeEnum;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDHEADEND;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUP;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAM;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.worker.consumer.HeadendConsumer;
import com.ericsson.cms.epgmgmt.export.worker.consumer.LineupConsumer;
import com.ericsson.cms.epgmgmt.export.worker.consumer.ProgramConsumer;
import com.ericsson.cms.epgmgmt.export.worker.consumer.ScheduleConsumer;
import com.ericsson.cms.epgmgmt.export.worker.consumer.StationConsumer;
import com.ericsson.cms.epgmgmt.export.worker.future.GEConsumer;
import com.ericsson.cms.epgmgmt.export.worker.future.GEResult;
import com.ericsson.cms.epgmgmt.export.worker.future.GEUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuideDataConsumer
implements Callable<GEResult> {
    private static final Log logger = LogFactory.getLog(GuideDataConsumer.class);
    private final BlockingQueue<RowTypeSGDHEADEND> headendQueue;
    private final BlockingQueue<RowTypeSGDLINEUP> lineupQueue;
    private final BlockingQueue<RowTypeSGDSTATION> stationQueue;
    private final BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue;
    private final BlockingQueue<RowTypeSGDPROGRAM> programQueue;
    private final ExportETVTypeEnum etvFormat;
    private final String tempFolder;
    private ExecutorService consumerExecutor;

    public GuideDataConsumer(BlockingQueue<RowTypeSGDHEADEND> headendQueue, BlockingQueue<RowTypeSGDLINEUP> lineupQueue, BlockingQueue<RowTypeSGDSTATION> stationQueue, BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue, BlockingQueue<RowTypeSGDPROGRAM> programQueue, ExportETVTypeEnum etvFormat, String tempFolder) {
        this.headendQueue = headendQueue;
        this.lineupQueue = lineupQueue;
        this.stationQueue = stationQueue;
        this.scheduleQueue = scheduleQueue;
        this.programQueue = programQueue;
        this.etvFormat = etvFormat;
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GEResult call() throws ExportToXMLException {
        GEConsumer result = new GEConsumer(false);
        this.consumerExecutor = Executors.newFixedThreadPool(5);
        try {
            ArrayList<Callable<GEConsumer>> consumerTasks = new ArrayList<Callable<GEConsumer>>();
            consumerTasks.add(new HeadendConsumer(this.headendQueue, this.tempFolder));
            consumerTasks.add(new LineupConsumer(this.lineupQueue, this.tempFolder));
            consumerTasks.add(new StationConsumer(this.stationQueue, this.tempFolder));
            if (!GEUtil.isETVMIX(this.etvFormat)) {
                consumerTasks.add(new ScheduleConsumer(this.scheduleQueue, this.tempFolder));
            }
            consumerTasks.add(new ProgramConsumer(this.programQueue, this.tempFolder));
            List consumerResults = this.consumerExecutor.invokeAll(consumerTasks);
            for (Future future : consumerResults) {
                GEConsumer taskResult = (GEConsumer)future.get();
                logger.debug((Object)String.format("%s - Is all records produced by %s producer are processed? %s", PluginLogComponent.EXPORT_TO_XML, taskResult.getConsumerName(), taskResult.isResult()));
            }
            result.setResult(true);
        }
        catch (InterruptedException ex) {
            result.handleException(ex);
        }
        catch (Exception ex) {
            result.handleException(ex);
        }
        finally {
            this.shutdown(true);
        }
        return result;
    }

    private void shutdown(boolean graceful) {
        if (this.consumerExecutor != null) {
            if (graceful) {
                this.consumerExecutor.shutdown();
            } else {
                this.consumerExecutor.shutdownNow();
            }
            this.consumerExecutor = null;
        } else {
            logger.debug((Object)"GuideDataConsumer:shutdown() - consumerExecutor has already been shut down.");
        }
    }

    public void shutdownNow() {
        this.shutdown(false);
    }
}

