/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.consumer;

import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDHEADEND;
import com.ericsson.cms.epgmgmt.export.worker.future.GEConsumer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class HeadendConsumer
implements Callable<GEConsumer> {
    private final BlockingQueue<RowTypeSGDHEADEND> headendQueue;
    private final String tempFolder;
    private static JAXBContext jcEtv = null;
    private static Marshaller heMarshler = null;
    private static final String etvBoRepository = "com.ericsson.cms.epgmgmt.export.bo";

    public HeadendConsumer(BlockingQueue<RowTypeSGDHEADEND> headendQueue, String tempFolder) {
        this.headendQueue = headendQueue;
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GEConsumer call() throws ExportToXMLException {
        GEConsumer result = new GEConsumer("Headend", false);
        boolean amIDone = false;
        OutputStreamWriter heFile = null;
        BufferedWriter heOut = null;
        try {
            heFile = new FileWriter(this.tempFolder + System.getProperty("file.separator") + "rowHeadEnd.xml");
            heOut = new BufferedWriter(heFile);
            heOut.write("<HEADEND>\n");
            while (!amIDone && !Thread.currentThread().isInterrupted()) {
                RowTypeSGDHEADEND rowHeadend = this.headendQueue.take();
                if (rowHeadend.getHEHEADENDID() != null && rowHeadend.getHEHEADENDID().equalsIgnoreCase("done")) {
                    amIDone = true;
                    continue;
                }
                StringWriter sw = new StringWriter();
                this.getETVMarshler().marshal((Object)rowHeadend, (Writer)sw);
                String heRow = sw.toString().substring(sw.toString().indexOf("<row>"));
                heOut.write(heRow);
            }
            heOut.write("</HEADEND>\n");
            result.setResult(true);
        }
        catch (InterruptedException ex) {
            result.handleException(ex);
        }
        catch (IOException ex) {
            result.handleException(ex);
        }
        catch (JAXBException ex) {
            result.handleException((Exception)((Object)ex));
        }
        finally {
            try {
                if (heOut != null) {
                    heOut.close();
                }
                if (heFile != null) {
                    heFile.close();
                }
            }
            catch (IOException ex) {
                result.handleException(ex);
            }
        }
        return result;
    }

    private Marshaller getETVMarshler() throws ExportToXMLException {
        String exMsg = "HeadEnd - Error found while creating Marsheler for ETV";
        try {
            if (jcEtv == null) {
                jcEtv = JAXBContext.newInstance((String)etvBoRepository);
            }
            if (heMarshler == null) {
                heMarshler = jcEtv.createMarshaller();
                heMarshler.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                heMarshler.setProperty("jaxb.encoding", (Object)"UTF-8");
            }
        }
        catch (JAXBException jEx) {
            throw new ExportToXMLException(exMsg, (Throwable)jEx);
        }
        return heMarshler;
    }
}

