/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.consumer;

import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAM;
import com.ericsson.cms.epgmgmt.export.worker.future.GEConsumer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class ProgramConsumer
implements Callable<GEConsumer> {
    private final BlockingQueue<RowTypeSGDPROGRAM> programQueue;
    private final String tempFolder;
    private static JAXBContext jcEtv = null;
    private static Marshaller programMarshler = null;
    private static final String etvBoRepository = "com.ericsson.cms.epgmgmt.export.bo";

    public ProgramConsumer(BlockingQueue<RowTypeSGDPROGRAM> programQueue, String tempFolder) {
        this.programQueue = programQueue;
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GEConsumer call() throws Exception {
        GEConsumer result = new GEConsumer("Program", false);
        boolean amIDone = false;
        OutputStreamWriter programFile = null;
        BufferedWriter programOut = null;
        try {
            programFile = new FileWriter(this.tempFolder + System.getProperty("file.separator") + "rowProgram.xml");
            programOut = new BufferedWriter(programFile);
            programOut.write("<PROGRAM>\n");
            while (!amIDone && !Thread.currentThread().isInterrupted()) {
                RowTypeSGDPROGRAM rowProgram = this.programQueue.take();
                if (rowProgram.getDATABASEKEY() != null && rowProgram.getDATABASEKEY().equalsIgnoreCase("done")) {
                    amIDone = true;
                    continue;
                }
                StringWriter sw = new StringWriter();
                this.getETVMarshler().marshal((Object)rowProgram, (Writer)sw);
                String programRow = sw.toString().substring(sw.toString().indexOf("<row>"));
                programOut.write(programRow);
            }
            programOut.write("</PROGRAM>\n");
            result.setResult(true);
        }
        catch (InterruptedException ex) {
            result.handleException(ex);
        }
        catch (IOException ex) {
            result.handleException(ex);
        }
        catch (JAXBException ex) {
            result.handleException((Exception)((Object)ex));
        }
        finally {
            try {
                if (programOut != null) {
                    programOut.close();
                }
                if (programFile != null) {
                    programFile.close();
                }
            }
            catch (IOException ex) {
                result.handleException(ex);
            }
        }
        return result;
    }

    private Marshaller getETVMarshler() {
        String exMsg = "Program - Error found while creating Marsheler for ETV";
        try {
            if (jcEtv == null) {
                jcEtv = JAXBContext.newInstance((String)etvBoRepository);
            }
            if (programMarshler == null) {
                programMarshler = jcEtv.createMarshaller();
                programMarshler.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                programMarshler.setProperty("jaxb.encoding", (Object)"UTF-8");
            }
        }
        catch (JAXBException jEx) {
            throw new ExportToXMLException(exMsg, (Throwable)jEx);
        }
        return programMarshler;
    }
}

