/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.consumer;

import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.worker.future.GEConsumer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class ScheduleConsumer
implements Callable<GEConsumer> {
    private final BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue;
    private final String tempFolder;
    private static JAXBContext jcEtv = null;
    private static Marshaller scheduleMarshler = null;
    private static final String etvBoRepository = "com.ericsson.cms.epgmgmt.export.bo";

    public ScheduleConsumer(BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue, String tempFolder) {
        this.scheduleQueue = scheduleQueue;
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GEConsumer call() throws Exception {
        GEConsumer result = new GEConsumer("Schedule", false);
        boolean amIDone = false;
        OutputStreamWriter scheduleFile = null;
        BufferedWriter scheduleOut = null;
        try {
            scheduleFile = new FileWriter(this.tempFolder + System.getProperty("file.separator") + "rowSchedule.xml");
            scheduleOut = new BufferedWriter(scheduleFile);
            scheduleOut.write("<SCHEDULE>\n");
            while (!amIDone && !Thread.currentThread().isInterrupted()) {
                RowTypeSGDSCHEDULE rowSchedule = this.scheduleQueue.take();
                if (rowSchedule.getDATABASEKEY() != null && rowSchedule.getDATABASEKEY().equalsIgnoreCase("done")) {
                    amIDone = true;
                    continue;
                }
                StringWriter sw = new StringWriter();
                this.getETVMarshler().marshal((Object)rowSchedule, (Writer)sw);
                String scheduleRow = sw.toString().substring(sw.toString().indexOf("<row>"));
                scheduleOut.write(scheduleRow);
            }
            scheduleOut.write("</SCHEDULE>\n");
            result.setResult(true);
        }
        catch (InterruptedException ex) {
            result.handleException(ex);
        }
        catch (JAXBException ex) {
            result.handleException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            result.handleException(ex);
        }
        finally {
            try {
                if (scheduleOut != null) {
                    scheduleOut.close();
                }
                if (scheduleFile != null) {
                    scheduleFile.close();
                }
            }
            catch (IOException ex) {
                result.handleException(ex);
            }
        }
        return result;
    }

    private Marshaller getETVMarshler() throws Exception {
        String exMsg = "Schedule - Error found while creating Marsheler for ETV";
        try {
            if (jcEtv == null) {
                jcEtv = JAXBContext.newInstance((String)etvBoRepository);
            }
            if (scheduleMarshler == null) {
                scheduleMarshler = jcEtv.createMarshaller();
                scheduleMarshler.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                scheduleMarshler.setProperty("jaxb.encoding", (Object)"UTF-8");
            }
        }
        catch (JAXBException jEx) {
            throw new ExportToXMLException(exMsg, (Throwable)jEx);
        }
        return scheduleMarshler;
    }
}

