/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.consumer;

import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.worker.future.GEConsumer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class StationConsumer
implements Callable<GEConsumer> {
    private final BlockingQueue<RowTypeSGDSTATION> stationQueue;
    private final String tempFolder;
    private static JAXBContext jcEtv = null;
    private static Marshaller stationMarshler = null;
    private static final String etvBoRepository = "com.ericsson.cms.epgmgmt.export.bo";

    public StationConsumer(BlockingQueue<RowTypeSGDSTATION> stationQueue, String tempFolder) {
        this.stationQueue = stationQueue;
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GEConsumer call() throws ExportToXMLException {
        GEConsumer result = new GEConsumer("Station", false);
        boolean amIDone = false;
        OutputStreamWriter stationFile = null;
        BufferedWriter stationOut = null;
        try {
            stationFile = new FileWriter(this.tempFolder + System.getProperty("file.separator") + "rowStation.xml");
            stationOut = new BufferedWriter(stationFile);
            stationOut.write("<STATION>\n");
            while (!amIDone && !Thread.currentThread().isInterrupted()) {
                RowTypeSGDSTATION rowStation = this.stationQueue.take();
                if (rowStation.getSTATIONNUM() != null && rowStation.getSTATIONNUM().equalsIgnoreCase("done")) {
                    amIDone = true;
                    continue;
                }
                StringWriter sw = new StringWriter();
                this.getETVMarshler().marshal((Object)rowStation, (Writer)sw);
                String stationRow = sw.toString().substring(sw.toString().indexOf("<row>"));
                stationOut.write(stationRow);
            }
            stationOut.write("</STATION>\n");
            result.setResult(true);
        }
        catch (InterruptedException ex) {
            result.handleException(ex);
        }
        catch (IOException ex) {
            result.handleException(ex);
        }
        catch (JAXBException ex) {
            result.handleException((Exception)((Object)ex));
        }
        finally {
            try {
                if (stationOut != null) {
                    stationOut.close();
                }
                if (stationFile != null) {
                    stationFile.close();
                }
            }
            catch (IOException ex) {
                result.handleException(ex);
            }
        }
        return result;
    }

    private Marshaller getETVMarshler() {
        String exMsg = "Station - Error found while creating Marsheler for ETV";
        try {
            if (jcEtv == null) {
                jcEtv = JAXBContext.newInstance((String)etvBoRepository);
            }
            if (stationMarshler == null) {
                stationMarshler = jcEtv.createMarshaller();
                stationMarshler.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                stationMarshler.setProperty("jaxb.encoding", (Object)"UTF-8");
            }
        }
        catch (JAXBException jEx) {
            throw new ExportToXMLException(exMsg, (Throwable)jEx);
        }
        return stationMarshler;
    }
}

