/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.future;

import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.export.worker.future.GEResult;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.util.ResourceUtils;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang.time.StopWatch;

public class GEProducer
extends GEResult {
    private String producerName;
    private IAlarmActivityLogManager applicationLogger = (IAlarmActivityLogManager)InjectionUtil.injectInstance((String)"cms/AlarmActivityLogManager/local", IAlarmActivityLogManager.class);
    private long totalCount = 0L;
    private StopWatch stopWatch = new StopWatch();

    public GEProducer() {
    }

    public GEProducer(boolean result) {
        super(result);
    }

    public GEProducer(String producerName, boolean result) {
        super(result);
        this.producerName = producerName;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public void handleException(Exception ex) {
        super.handleException(ex, "Producer", this.producerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalCount(DataSource datasource, String getCountSql) throws SQLException {
        this.stopWatch.start();
        PreparedStatement pStatement = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = datasource.getConnection();
            pStatement = connection.prepareStatement(getCountSql);
            rs = pStatement.executeQuery();
            if (rs.next()) {
                this.totalCount = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            ResourceUtils.closeResource(pStatement, rs);
            ResourceUtils.closeResource(connection);
            throw throwable;
        }
        ResourceUtils.closeResource(pStatement, rs);
        ResourceUtils.closeResource(connection);
    }

    public void logResult(long count) {
        String title;
        PluginLogSeverity logSeverity;
        if (count == 0L) {
            logSeverity = PluginLogSeverity.WARNING;
            title = "No";
        } else {
            logSeverity = PluginLogSeverity.INFORMATION;
            title = "All";
        }
        this.stopWatch.stop();
        String msg = String.format("%s %s filtered out of published data for publisher in %d seconds", title, this.producerName, this.stopWatch.getTime() / 1000L);
        this.applicationLogger.log(logSeverity, PluginLogComponent.EXPORT_TO_XML, msg);
    }

    public void logProgress(long count) {
        logger.debug((Object)String.format("Processed %d %s records out of total %d.", count, this.producerName, this.totalCount));
    }
}

