/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.future;

import com.ericsson.cms.epgmgmt.export.ExportETVTypeEnum;
import java.sql.Timestamp;
import java.text.StringCharacterIterator;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class GEUtil {
    public static XMLGregorianCalendar getXMLDate(Timestamp date) throws DatatypeConfigurationException {
        XMLGregorianCalendar result = null;
        if (date != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            cal.setTime(date);
            result = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
            result.setMillisecond(Integer.MIN_VALUE);
            result.setTimezone(Integer.MIN_VALUE);
        }
        return result;
    }

    public static String getDuration(long timeInMillSec) {
        return String.format("%02d%02d%02d", TimeUnit.MILLISECONDS.toHours(timeInMillSec), TimeUnit.MILLISECONDS.toMinutes(timeInMillSec) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(timeInMillSec)), TimeUnit.MILLISECONDS.toSeconds(timeInMillSec) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(timeInMillSec)));
    }

    public static String getTimeTook(long timeInMillSec) {
        return String.format("%02d hours %02d minutes %02d seconds", TimeUnit.MILLISECONDS.toHours(timeInMillSec), TimeUnit.MILLISECONDS.toMinutes(timeInMillSec) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(timeInMillSec)), TimeUnit.MILLISECONDS.toSeconds(timeInMillSec) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(timeInMillSec)));
    }

    public static boolean isETV18(ExportETVTypeEnum etvFormat) {
        boolean result = false;
        if (etvFormat.name().equalsIgnoreCase(ExportETVTypeEnum.ETV_18.name())) {
            result = true;
        }
        return result;
    }

    public static boolean isETV20(ExportETVTypeEnum etvFormat) {
        boolean result = false;
        if (etvFormat.name().equalsIgnoreCase(ExportETVTypeEnum.ETV_20.name())) {
            result = true;
        }
        return result;
    }

    public static boolean isETVMIX(ExportETVTypeEnum etvFormat) {
        boolean result = false;
        if (etvFormat.name().equalsIgnoreCase(ExportETVTypeEnum.ETV_MIX.name())) {
            result = true;
        }
        return result;
    }

    public static String encode(String text) {
        if (!(text != null && (text.contains("&") || text.contains("\"") || text.contains("<") || text.contains(">") || text.contains("\\")))) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(text);
        char c = iter.first();
        while (c != '\uffff') {
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\'': {
                    sb.append("&#039;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            c = iter.next();
        }
        return sb.toString();
    }
}

