/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer;

import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.ExportETVTypeEnum;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDHEADEND;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUP;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAM;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.worker.future.GEProducer;
import com.ericsson.cms.epgmgmt.export.worker.future.GEResult;
import com.ericsson.cms.epgmgmt.export.worker.future.GEUtil;
import com.ericsson.cms.epgmgmt.export.worker.producer.HeadendProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.LineupProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.ProgramProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.ScheduleProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.StationProducer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuideDataProducer
implements Callable<GEResult> {
    private static final Log logger = LogFactory.getLog(GuideDataProducer.class);
    private final BlockingQueue<RowTypeSGDHEADEND> headendQueue;
    private final BlockingQueue<RowTypeSGDLINEUP> lineupQueue;
    private final BlockingQueue<RowTypeSGDSTATION> stationQueue;
    private final BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue;
    private final BlockingQueue<RowTypeSGDPROGRAM> programQueue;
    private final ExportETVTypeEnum etvFormat;
    private DataSource datasource;
    private ExecutorService producerExecutor;

    public GuideDataProducer(BlockingQueue<RowTypeSGDHEADEND> headendQueue, BlockingQueue<RowTypeSGDLINEUP> lineupQueue, BlockingQueue<RowTypeSGDSTATION> stationQueue, BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue, BlockingQueue<RowTypeSGDPROGRAM> programQueue, ExportETVTypeEnum etvFormat, DataSource datasource) {
        this.headendQueue = headendQueue;
        this.lineupQueue = lineupQueue;
        this.stationQueue = stationQueue;
        this.scheduleQueue = scheduleQueue;
        this.programQueue = programQueue;
        this.etvFormat = etvFormat;
        this.datasource = datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GEResult call() throws ExportToXMLException {
        GEProducer result = new GEProducer(false);
        this.producerExecutor = Executors.newFixedThreadPool(5);
        try {
            ArrayList<Callable<GEProducer>> producerTasks = new ArrayList<Callable<GEProducer>>();
            producerTasks.add(new HeadendProducer(this.headendQueue, GEUtil.isETV20(this.etvFormat) || GEUtil.isETVMIX(this.etvFormat), this.datasource));
            producerTasks.add(new LineupProducer(this.lineupQueue, GEUtil.isETV18(this.etvFormat), this.datasource));
            producerTasks.add(new StationProducer(this.stationQueue, GEUtil.isETV20(this.etvFormat) || GEUtil.isETVMIX(this.etvFormat), this.datasource));
            if (!GEUtil.isETVMIX(this.etvFormat)) {
                producerTasks.add(new ScheduleProducer(this.scheduleQueue, this.datasource));
            }
            producerTasks.add(new ProgramProducer(this.programQueue, GEUtil.isETVMIX(this.etvFormat), this.datasource));
            SimpleDateFormat timeformatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            logger.warn((Object)String.format("PerformanceTest Start Time:%s", timeformatter.format(new Date())));
            List producerResults = this.producerExecutor.invokeAll(producerTasks);
            for (Future future : producerResults) {
                GEProducer taskResult = (GEProducer)future.get();
                logger.debug((Object)String.format("%s - Is all %s filtered out of published data for publisher? %s", PluginLogComponent.EXPORT_TO_XML, taskResult.getProducerName(), taskResult.isResult()));
            }
            logger.warn((Object)String.format("PerformanceTest End Time:%s", timeformatter.format(new Date())));
            result.setResult(true);
        }
        catch (InterruptedException ex) {
            result.handleException(ex);
        }
        catch (ExecutionException ex) {
            result.handleException(ex);
        }
        finally {
            this.shutdown(true);
        }
        return result;
    }

    private void shutdown(boolean graceful) {
        if (this.producerExecutor != null) {
            if (graceful) {
                this.producerExecutor.shutdown();
            } else {
                this.producerExecutor.shutdownNow();
            }
            this.producerExecutor = null;
        } else {
            logger.debug((Object)"GuideDataProducer:shutdown() - producerExecutor has already been shut down.");
        }
    }

    public void shutdownNow() {
        this.shutdown(false);
    }
}

