/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer;

import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDHEADEND;
import com.ericsson.cms.epgmgmt.export.worker.future.GEProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.RowObjectExtractor;
import com.ericsson.cms.epgmgmt.util.ResourceUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.sql.DataSource;

public class HeadendProducer
implements Callable<GEProducer> {
    private final BlockingQueue<RowTypeSGDHEADEND> headendQueue;
    private final boolean isHeGenericSupported;
    private DataSource datasource;
    private String getheadendcount = "select count(*) from exp_HEADEND";
    private String getheadends = "select * from exp_HEADEND order by HEADEND_ID";
    private String getheadendgeneric = "select * from exp_headend_generic where exp_headend_generic.headend_id = ? order by Name";
    private GEProducer geProducer;

    public HeadendProducer(BlockingQueue<RowTypeSGDHEADEND> headendQueue, boolean isHeGenericSupported, DataSource datasource) {
        this.headendQueue = headendQueue;
        this.isHeGenericSupported = isHeGenericSupported;
        this.datasource = datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public GEProducer call() throws ExportToXMLException {
        block18: {
            this.geProducer = new GEProducer("Headend", false);
            Connection connection = null;
            PreparedStatement pStatement = null;
            ResultSet rs = null;
            PreparedStatement pStatementGeneric = null;
            ResultSet rsGeneric = null;
            long count = 0L;
            this.geProducer.setTotalCount(this.datasource, this.getheadendcount);
            connection = this.datasource.getConnection();
            pStatement = ResourceUtils.createReadOnlyForwardPS(connection, this.getheadends);
            pStatementGeneric = ResourceUtils.createReadOnlyForwardPS(connection, this.getheadendgeneric);
            rs = pStatement.executeQuery();
            Thread currentThread = Thread.currentThread();
            while (rs.next() && !currentThread.isInterrupted()) {
                RowTypeSGDHEADEND rowHeadend = RowObjectExtractor.create().extractHeadEnd(rs);
                if (this.isHeGenericSupported) {
                    pStatementGeneric.setString(1, rs.getString("HEADEND_ID"));
                    rsGeneric = pStatementGeneric.executeQuery();
                    while (rsGeneric.next() && !currentThread.isInterrupted()) {
                        GenericType heGeneric = RowObjectExtractor.create().extractHeadEndGeneric(rsGeneric);
                        rowHeadend.getHEGENERIC().add(heGeneric);
                    }
                }
                this.headendQueue.put(rowHeadend);
                if (++count % 10L != 0L) continue;
                this.geProducer.logProgress(count);
            }
            this.geProducer.setResult(true);
            this.geProducer.logResult(count);
            this.geProducer.logProgress(count);
            ResourceUtils.closeResource(pStatement, rs);
            ResourceUtils.closeResource(pStatementGeneric, rsGeneric);
            ResourceUtils.closeResource(connection);
            RowTypeSGDHEADEND rowHeadend = new RowTypeSGDHEADEND();
            rowHeadend.setHEHEADENDID("done");
            try {
                this.headendQueue.put(rowHeadend);
            }
            catch (InterruptedException ex) {
                this.geProducer.handleException(ex);
            }
            break block18;
            catch (InterruptedException ex) {
                this.geProducer.handleException(ex);
                break block18;
            }
            catch (SQLException ex2) {
                this.geProducer.handleException(ex2);
                break block18;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.geProducer.logProgress(count);
                ResourceUtils.closeResource(pStatement, rs);
                ResourceUtils.closeResource(pStatementGeneric, rsGeneric);
                ResourceUtils.closeResource(connection);
                rowHeadend = new RowTypeSGDHEADEND();
                rowHeadend.setHEHEADENDID("done");
                try {
                    this.headendQueue.put(rowHeadend);
                }
                catch (InterruptedException ex) {
                    this.geProducer.handleException(ex);
                }
            }
        }
        return this.geProducer;
    }
}

