/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer;

import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.bo.EventIdType;
import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAM;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.bo.SeriesInformation;
import com.ericsson.cms.epgmgmt.export.bo.TableTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.worker.future.GEProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.RowObjectExtractor;
import com.ericsson.cms.epgmgmt.util.ResourceUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.lang.StringUtils;

public class ProgramProducer
implements Callable<GEProducer> {
    private final BlockingQueue<RowTypeSGDPROGRAM> programQueue;
    private final boolean isEtvMix;
    private DataSource datasource;
    private GEProducer geProducer;
    private String getprogramcount = "select count(*) from exp_program";
    private String getpgorams = "select * from exp_PROGRAM order by program_id";
    private String getprogramcast = "select FIRST_NAME, LAST_NAME, ROLE from exp_PROGRAM_CAST where exp_PROGRAM_CAST.program_id = ? order by SEQ";
    private String getprogramcredits = "select FIRST_NAME, LAST_NAME, ROLE from exp_PROGRAM_CREDITS where exp_PROGRAM_CREDITS.program_id = ? order by SEQ";
    private String getprogramrating = "select * from exp_PROGRAM_RATING where exp_PROGRAM_RATING.program_id = ? order by Authority";
    private String getprogramaudiotl = "select unique Type, Language from exp_PROGRAM_AUDIO_COMP where exp_PROGRAM_AUDIO_COMP.program_id = ? order by Type,Language";
    private String getprogramaudio = "select * from exp_PROGRAM_AUDIO_COMP where exp_PROGRAM_AUDIO_COMP.program_id = ? and exp_PROGRAM_AUDIO_COMP.Type= ? and exp_PROGRAM_AUDIO_COMP.Language= ? order by Attribute_Type";
    private String getprogramsubtitletl = "select unique Type, Language from exp_PROGRAM_SUBTITLE_COMP where exp_PROGRAM_SUBTITLE_COMP.program_id = ? order by Type,Language";
    private String getprogramsubtitle = "select * from exp_PROGRAM_SUBTITLE_COMP where exp_PROGRAM_SUBTITLE_COMP.program_id = ? and exp_PROGRAM_subtitle_COMP.Type= ? and exp_PROGRAM_SUBTITLE_COMP.Language= ? order by Attribute_Type";
    private String getprogramgeneric = "select * from exp_PROGRAM_GENERIC where exp_PROGRAM_GENERIC.program_id = ? order by Name";
    private String getschedule = "select * from exp_SCHEDULE where exp_SCHEDULE.program_id = ? order by station_id, program_id, Start_time";
    private String getscheduleeventids = "select * from exp_SCHEDULE_EVENT_ID where exp_SCHEDULE_EVENT_ID.program_id = ?  order by Identifier_Type";
    private String getscheduleseriesattribute = "select * from exp_SCHEDULE_SERIES_ATTRIB where exp_SCHEDULE_SERIES_ATTRIB.program_id = ?  order by Attribute_Type";
    private String getschedulegeneric = "select * from exp_SCHEDULE_GENERIC where exp_SCHEDULE_GENERIC.program_id = ? order by Name";

    public ProgramProducer(BlockingQueue<RowTypeSGDPROGRAM> programQueue, boolean isEtvMix, DataSource datasource) {
        this.programQueue = programQueue;
        this.isEtvMix = isEtvMix;
        this.datasource = datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GEProducer call() throws ExportToXMLException {
        this.geProducer = new GEProducer("Program", false);
        try {
            long count = this.queuePrograms();
            this.geProducer.setResult(true);
            this.geProducer.logResult(count);
        }
        finally {
            try {
                RowTypeSGDPROGRAM rowProgram = new RowTypeSGDPROGRAM();
                rowProgram.setDATABASEKEY("done");
                this.programQueue.put(rowProgram);
            }
            catch (InterruptedException ex) {
                this.geProducer.handleException(ex);
            }
        }
        return this.geProducer;
    }

    /*
     * Exception decompiling
     */
    private long queuePrograms() throws ExportToXMLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableTypeSGDSCHEDULE getSchedulesAssoicatedWithProgram(String programId) throws SQLException, DatatypeConfigurationException {
        TableTypeSGDSCHEDULE schedulesResult = new TableTypeSGDSCHEDULE();
        Connection scheduleConn = null;
        PreparedStatement pStatement = null;
        PreparedStatement pStatementGeneric = null;
        PreparedStatement pStatementEventId = null;
        PreparedStatement pStatementSeriesLink = null;
        ResultSet rs = null;
        ResultSet rsGeneric = null;
        try {
            scheduleConn = this.datasource.getConnection();
            pStatement = ResourceUtils.createReadOnlyForwardPS(scheduleConn, this.getschedule);
            pStatementGeneric = ResourceUtils.createReadOnlyForwardPS(scheduleConn, this.getschedulegeneric);
            pStatementEventId = ResourceUtils.createReadOnlyForwardPS(scheduleConn, this.getscheduleeventids);
            pStatementSeriesLink = ResourceUtils.createReadOnlyForwardPS(scheduleConn, this.getscheduleseriesattribute);
            pStatement.setString(1, programId);
            rs = pStatement.executeQuery();
            while (rs.next() && !Thread.currentThread().isInterrupted()) {
                RowTypeSGDSCHEDULE rowSchedule = RowObjectExtractor.create().extractSchedule(rs);
                pStatementGeneric.setString(1, programId);
                rsGeneric = pStatementGeneric.executeQuery();
                while (rsGeneric.next() && !Thread.currentThread().isInterrupted()) {
                    GenericType scheduleGeneric = RowObjectExtractor.create().extractScheduleGeneric(rsGeneric);
                    rowSchedule.getSCHEDULEGENERIC().add(scheduleGeneric);
                }
                rsGeneric.close();
                pStatementEventId.setString(1, programId);
                rsGeneric = pStatementEventId.executeQuery();
                while (rsGeneric.next() && !Thread.currentThread().isInterrupted()) {
                    EventIdType scheduleEventId = RowObjectExtractor.create().extractScheduleEventId(rsGeneric);
                    rowSchedule.getEVENTID().add(scheduleEventId);
                }
                rsGeneric.close();
                String seriesId = rs.getString("SERIES_ID");
                if (StringUtils.isNotEmpty((String)seriesId)) {
                    SeriesInformation seriesInfo = RowObjectExtractor.create().extractSeriesInformation(pStatementSeriesLink, seriesId, programId);
                    rowSchedule.setSERIESLINK(seriesInfo);
                }
                schedulesResult.getRow().add(rowSchedule);
            }
        }
        catch (Throwable throwable) {
            ResourceUtils.closeResource(pStatement, rs);
            ResourceUtils.closeResource(pStatementGeneric, rsGeneric);
            ResourceUtils.closeResource(pStatementEventId, null);
            ResourceUtils.closeResource(pStatementSeriesLink, null);
            ResourceUtils.closeResource(scheduleConn);
            throw throwable;
        }
        ResourceUtils.closeResource(pStatement, rs);
        ResourceUtils.closeResource(pStatementGeneric, rsGeneric);
        ResourceUtils.closeResource(pStatementEventId, null);
        ResourceUtils.closeResource(pStatementSeriesLink, null);
        ResourceUtils.closeResource(scheduleConn);
        return schedulesResult;
    }
}

