/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer;

import com.ericsson.cms.epgmgmt.export.bo.CASTNAMEROLEType;
import com.ericsson.cms.epgmgmt.export.bo.CREDITSNAMEROLEType;
import com.ericsson.cms.epgmgmt.export.bo.ComponentAttribute;
import com.ericsson.cms.epgmgmt.export.bo.EventIdType;
import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.RatingType;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDHEADEND;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUP;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAM;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.bo.SeriesAttributeType;
import com.ericsson.cms.epgmgmt.export.bo.SeriesInformation;
import com.ericsson.cms.epgmgmt.export.bo.SubtitleComponentType;
import com.ericsson.cms.epgmgmt.export.worker.future.GEUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.datatype.DatatypeConfigurationException;

public class RowObjectExtractor {
    private static RowObjectExtractor rowObjectExtractor = new RowObjectExtractor();

    private RowObjectExtractor() {
    }

    public static RowObjectExtractor create() {
        return rowObjectExtractor;
    }

    public RowTypeSGDHEADEND extractHeadEnd(ResultSet rs) throws SQLException {
        RowTypeSGDHEADEND rowHeadend = new RowTypeSGDHEADEND();
        rowHeadend.setHEHEADENDID(rs.getString("HEADEND_ID"));
        rowHeadend.setHECOMMUNITYNAME(rs.getString("COMMUNITY_NAME"));
        rowHeadend.setHECOUNTYNAME(rs.getString("COUNTY_NAME"));
        rowHeadend.setHECOUNTYSIZE(rs.getString("COUNTY_SIZE"));
        rowHeadend.setHESTCOUNTYCODE(rs.getString("ST_COUNTY_CODE"));
        rowHeadend.setHESTATESERVED(rs.getString("STATE"));
        rowHeadend.setHEZIPCODE(rs.getString("ZIPCODE"));
        rowHeadend.setHEDMACODE(rs.getString("DMA_CODE"));
        rowHeadend.setHEDMANAME(rs.getString("DMA_NAME"));
        rowHeadend.setHEMSOCODE(rs.getBigDecimal("MSO_CODE"));
        rowHeadend.setHEDMARANK(rs.getString("DMA_RANK"));
        rowHeadend.setHEHEADENDNAME(rs.getString("HEADEND_NAME"));
        rowHeadend.setHEHEADENDLOCATION(rs.getString("HEADEND_LOCATION"));
        rowHeadend.setHEMSONAME(rs.getString("MSO_NAME"));
        rowHeadend.setHETIMEZONECODE(rs.getString("TIME_ZONE"));
        return rowHeadend;
    }

    public GenericType extractHeadEndGeneric(ResultSet rsGeneric) throws SQLException {
        GenericType heGeneric = new GenericType();
        heGeneric.setAsset(rsGeneric.getString("ASSET"));
        heGeneric.setName(rsGeneric.getString("NAME"));
        heGeneric.setValue(rsGeneric.getString("VALUE"));
        return heGeneric;
    }

    public RowTypeSGDLINEUP extractLineup(ResultSet rs, boolean isEtv18) throws DatatypeConfigurationException, SQLException {
        RowTypeSGDLINEUP rowLineup = new RowTypeSGDLINEUP();
        rowLineup.setCLROWID(rs.getBigDecimal("lineup_id"));
        rowLineup.setCLSTATIONNUM(rs.getString("station_id"));
        rowLineup.setCLHEADENDID(rs.getString("headend_id"));
        if (!isEtv18) {
            rowLineup.setCLDEVICE(rs.getString("device"));
        } else if (rs.getString("device") != null && rs.getString("device").equalsIgnoreCase("X")) {
            rowLineup.setCLDEVICE("X");
        } else if (rs.getString("device") != null) {
            rowLineup.setCLDEVICE(" ");
        }
        rowLineup.setCLTMSCHAN(rs.getString("tms_channel"));
        rowLineup.setCLSERVICETIER(rs.getString("service_tier"));
        rowLineup.setCLEFFECTIVEDATE(GEUtil.getXMLDate(rs.getTimestamp("effective_date")));
        rowLineup.setCLEXPIRATIONDATE(GEUtil.getXMLDate(rs.getTimestamp("expiration_date")));
        return rowLineup;
    }

    public GenericType extractLineupGeneric(ResultSet rsGeneric) throws SQLException {
        GenericType lineupGeneric = new GenericType();
        lineupGeneric.setAsset(rsGeneric.getString("ASSET"));
        lineupGeneric.setName(rsGeneric.getString("NAME"));
        lineupGeneric.setValue(rsGeneric.getString("VALUE"));
        return lineupGeneric;
    }

    public RowTypeSGDPROGRAM extractProgram(ResultSet rs) throws SQLException, DatatypeConfigurationException {
        RowTypeSGDPROGRAM rowProgram = new RowTypeSGDPROGRAM();
        rowProgram.setDATABASEKEY(rs.getString("PROGRAM_ID"));
        rowProgram.setLANGUAGE(rs.getString("LANGUAGE"));
        rowProgram.setTITLE(rs.getString("TITLE"));
        rowProgram.getREDUCEDTITLE().add(rs.getString("REDUCED_TITLE1"));
        rowProgram.getREDUCEDTITLE().add(rs.getString("REDUCED_TITLE2"));
        rowProgram.getREDUCEDTITLE().add(rs.getString("REDUCED_TITLE3"));
        rowProgram.getREDUCEDTITLE().add(rs.getString("REDUCED_TITLE4"));
        rowProgram.setALTTITLE(rs.getString("ALT_TITLE"));
        rowProgram.getREDUCEDDESC().add(rs.getString("REDUCED_DESCRIPTION1"));
        rowProgram.getREDUCEDDESC().add(rs.getString("REDUCED_DESCRIPTION2"));
        rowProgram.getREDUCEDDESC().add(rs.getString("REDUCED_DESCRIPTION3"));
        rowProgram.getREDUCEDDESC().add(rs.getString("REDUCED_DESCRIPTION4"));
        rowProgram.getADVISORYDESC().add(rs.getString("ADVISORY_DESC1"));
        rowProgram.getADVISORYDESC().add(rs.getString("ADVISORY_DESC2"));
        rowProgram.getADVISORYDESC().add(rs.getString("ADVISORY_DESC3"));
        rowProgram.getADVISORYDESC().add(rs.getString("ADVISORY_DESC4"));
        rowProgram.getADVISORYDESC().add(rs.getString("ADVISORY_DESC5"));
        rowProgram.getADVISORYDESC().add(rs.getString("ADVISORY_DESC6"));
        rowProgram.getGENREDESC().add(rs.getString("GENRE_DESC1"));
        rowProgram.getGENREDESC().add(rs.getString("GENRE_DESC2"));
        rowProgram.getGENREDESC().add(rs.getString("GENRE_DESC3"));
        rowProgram.getGENREDESC().add(rs.getString("GENRE_DESC4"));
        rowProgram.getGENREDESC().add(rs.getString("GENRE_DESC5"));
        rowProgram.getGENREDESC().add(rs.getString("GENRE_DESC6"));
        rowProgram.getDESC().add(rs.getString("DESCRIPTION1"));
        rowProgram.getDESC().add(rs.getString("DESCRIPTION2"));
        rowProgram.setYEAR(rs.getString("YEAR_PROGRAM"));
        rowProgram.setMPAARATING(rs.getString("MPAA_RATING"));
        rowProgram.setSTARRATING(rs.getString("STAR_RATING"));
        rowProgram.setRUNTIME(rs.getString("RUN_TIME"));
        rowProgram.setCOLORCODE(rs.getString("COLOR_CODE"));
        rowProgram.setPROGRAMLANGUAGE(rs.getString("PROGRAM_LANGUAGE"));
        rowProgram.setORGCOUNTRY(rs.getString("COUNTRY_OF_ORIGIN"));
        rowProgram.setMADEFORTV(rs.getString("MADE_FOR_TV"));
        rowProgram.setSOURCETYPE(rs.getString("SOURCE_TYPE"));
        rowProgram.setSHOWTYPE(rs.getString("SHOW_TYPE"));
        rowProgram.setHOLIDAY(rs.getString("HOLIDAY"));
        rowProgram.setSYNEPINUM(rs.getString("SYNDICATE_EPISODE_NUM"));
        rowProgram.setALTSYNEPINUM(rs.getString("ALT_SYNDICATE_EPI_NUM"));
        rowProgram.setEPITITLE(rs.getString("EPISODE_TITLE"));
        rowProgram.setNETSYNSOURCE(rs.getString("NET_SYN_SOURCE"));
        rowProgram.setNETSYNTYPE(rs.getString("NET_SYN_TYPE"));
        rowProgram.setORGSTUDIO(rs.getString("ORG_STUDIO"));
        rowProgram.setGAMEDATE(GEUtil.getXMLDate(rs.getTimestamp("GAME_DATETIME")));
        rowProgram.setGAMETIMEZONE(rs.getString("GAME_TIMEZONE"));
        rowProgram.setORGAIRDATE(GEUtil.getXMLDate(rs.getTimestamp("ORG_AIR_DATE")));
        rowProgram.setUNIQUEID(rs.getString("UNIQUE_ID"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA1"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA2"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA3"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA4"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA5"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA6"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA7"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA8"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA9"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA10"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA11"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA12"));
        rowProgram.getUSERDATA().add(rs.getString("USER_DATA13"));
        return rowProgram;
    }

    public GenericType extractScheduleGeneric(ResultSet rsGeneric) throws SQLException {
        GenericType scheduleGeneric = new GenericType();
        scheduleGeneric.setAsset(rsGeneric.getString("ASSET"));
        scheduleGeneric.setName(rsGeneric.getString("NAME"));
        scheduleGeneric.setValue(rsGeneric.getString("VALUE"));
        return scheduleGeneric;
    }

    public RowTypeSGDSCHEDULE extractSchedule(ResultSet rs) throws SQLException, DatatypeConfigurationException {
        RowTypeSGDSCHEDULE rowSchedule = new RowTypeSGDSCHEDULE();
        rowSchedule.setSTATIONNUM(rs.getString("STATION_ID"));
        rowSchedule.setDATABASEKEY(rs.getString("PROGRAM_ID"));
        rowSchedule.setLANGUAGE(rs.getString("SCHEDULE_LANGUAGE"));
        rowSchedule.setAIRDATE(GEUtil.getXMLDate(rs.getTimestamp("START_TIME")));
        rowSchedule.setDURATION(GEUtil.getDuration(rs.getLong("DURATION") * 1000L));
        rowSchedule.setPARTNUM(rs.getBigDecimal("PART_NUMBER"));
        rowSchedule.setNUMOFPARTS(rs.getBigDecimal("NO_OF_PARTS"));
        rowSchedule.setCC(rs.getString("CC"));
        rowSchedule.setSTEREO(rs.getString("STEREO"));
        rowSchedule.setREPEAT(rs.getString("REPEAT"));
        rowSchedule.setLIVETAPEDELAY(rs.getString("LIVE_TAPE_DELAY"));
        rowSchedule.setSUBTITLED(rs.getString("SUBTITLED"));
        rowSchedule.setPREMIEREFINALE(rs.getString("PREMIERE_FINALE"));
        rowSchedule.setJOINEDINPROGRESS(rs.getString("JOINED_IN_PROGRESS"));
        rowSchedule.setCABLEINTHECLASSROOM(rs.getString("CABLE_IN_CLASSROOM"));
        rowSchedule.setTVRATING(rs.getString("TV_RATING"));
        rowSchedule.setSAP(rs.getString("SAP"));
        rowSchedule.setBLACKOUT(rs.getString("BLACKOUT"));
        rowSchedule.setSEXRATING(rs.getString("SEX_RATING"));
        rowSchedule.setVIOLENCERATING(rs.getString("VIOLENCE_RATING"));
        rowSchedule.setLANGUAGERATING(rs.getString("LANGUAGE_RATING"));
        rowSchedule.setDIALOGRATING(rs.getString("DIALOG_RATING"));
        rowSchedule.setFVRATING(rs.getString("FV_RATING"));
        rowSchedule.setENHANCED(rs.getString("ENHANCED"));
        rowSchedule.setTHREED(rs.getString("THREE_D"));
        rowSchedule.setLETTERBOX(rs.getString("LETTERBOX"));
        rowSchedule.setHDTV(rs.getString("HD_TV"));
        rowSchedule.setDOLBY(rs.getString("DOLBY"));
        rowSchedule.setDVS(rs.getString("DVS"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA1"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA2"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA3"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA4"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA5"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA6"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA7"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA8"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA9"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA10"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA11"));
        rowSchedule.setREQUESTRECORD(rs.getString("REQUEST_RECORD"));
        return rowSchedule;
    }

    public EventIdType extractScheduleEventId(ResultSet rsGeneric) throws SQLException {
        EventIdType scheduleEventId = new EventIdType();
        scheduleEventId.setValue(rsGeneric.getString("VALUE"));
        scheduleEventId.setIdentifierType(rsGeneric.getString("IDENTIFIER_TYPE"));
        return scheduleEventId;
    }

    public CASTNAMEROLEType extractCastNameRole(ResultSet rsGeneric) throws SQLException {
        CASTNAMEROLEType castNameRole = new CASTNAMEROLEType();
        castNameRole.setCASTFIRSTNAME(rsGeneric.getString("FIRST_NAME"));
        castNameRole.setCASTLASTNAME(rsGeneric.getString("LAST_NAME"));
        castNameRole.setCASTROLEDESC(rsGeneric.getString("ROLE"));
        return castNameRole;
    }

    public CREDITSNAMEROLEType extractCreditNameRole(ResultSet rsGeneric) throws SQLException {
        CREDITSNAMEROLEType creditsNameRole = new CREDITSNAMEROLEType();
        creditsNameRole.setCREDITSFIRSTNAME(rsGeneric.getString("FIRST_NAME"));
        creditsNameRole.setCREDITSLASTNAME(rsGeneric.getString("LAST_NAME"));
        creditsNameRole.setCREDITSROLEDESC(rsGeneric.getString("ROLE"));
        return creditsNameRole;
    }

    public RatingType extractRatingType(ResultSet rsGeneric) throws SQLException {
        RatingType ratingType = new RatingType();
        ratingType.setAuthority(rsGeneric.getString("AUTHORITY"));
        ratingType.setValue(rsGeneric.getString("VALUE"));
        return ratingType;
    }

    public SubtitleComponentType extractSubtitleComponentType(ResultSet rsGeneric, String programId) throws SQLException {
        SubtitleComponentType subTitleComponent = new SubtitleComponentType();
        subTitleComponent.setType(rsGeneric.getString("TYPE"));
        subTitleComponent.setLanguage(rsGeneric.getString("LANGUAGE"));
        return subTitleComponent;
    }

    public ComponentAttribute extractComponentAttribute(ResultSet rsGeneric1) throws SQLException {
        ComponentAttribute componentAttribute = new ComponentAttribute();
        componentAttribute.setAttributeType(rsGeneric1.getString("ATTRIBUTE_TYPE"));
        componentAttribute.setValue(rsGeneric1.getString("VALUE"));
        return componentAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeriesInformation extractSeriesInformation(PreparedStatement pStatementSeriesLink, String seriesId, String programId1) throws SQLException {
        SeriesInformation seriesInfo = new SeriesInformation();
        seriesInfo.setSeriesIdentifier(seriesId);
        pStatementSeriesLink.setString(1, programId1);
        ResultSet rsGeneric = pStatementSeriesLink.executeQuery();
        try {
            while (rsGeneric.next()) {
                if (rsGeneric.getString("ATTRIBUTE_TYPE").equalsIgnoreCase("seriesId")) continue;
                SeriesAttributeType seriesAttribute = new SeriesAttributeType();
                seriesAttribute.setValue(rsGeneric.getString("VALUE"));
                seriesAttribute.setAttributeType(rsGeneric.getString("ATTRIBUTE_TYPE"));
                seriesInfo.getSeriesAttribute().add(seriesAttribute);
            }
        }
        finally {
            rsGeneric.close();
        }
        return seriesInfo;
    }

    public RowTypeSGDSTATION extractStation(ResultSet rs) throws SQLException {
        RowTypeSGDSTATION rowStation = new RowTypeSGDSTATION();
        rowStation.setSTATIONNUM(rs.getString("station_id"));
        rowStation.setSTATIONTIMEZONE(rs.getString("time_zone"));
        rowStation.setSTATIONNAME(rs.getString("station_name"));
        rowStation.setSTATIONCALLSIGN(rs.getString("call_sign"));
        rowStation.setSTATIONAFFIL(rs.getString("affiliation"));
        rowStation.setSTATIONCITY(rs.getString("city"));
        rowStation.setSTATIONSTATE(rs.getString("state"));
        rowStation.setSTATIONZIPCODE(rs.getString("zipcode"));
        rowStation.setSTATIONCOUNTRY(rs.getString("country"));
        rowStation.setDMANAME(rs.getString("DMA_NAME"));
        rowStation.setDMANUM(rs.getBigDecimal("DMA_NUMBER"));
        rowStation.setFCCCHANNELNUM(rs.getBigDecimal("FCC_CHANNEL_NUM"));
        rowStation.getUSERDATA().add(rs.getString("USER_DATA1"));
        rowStation.getUSERDATA().add(rs.getString("USER_DATA2"));
        rowStation.getUSERDATA().add(rs.getString("USER_DATA3"));
        rowStation.getUSERDATA().add(rs.getString("USER_DATA4"));
        rowStation.getUSERDATA().add(rs.getString("USER_DATA5"));
        rowStation.getUSERDATA().add(rs.getString("USER_DATA6"));
        rowStation.getUSERDATA().add(rs.getString("USER_DATA7"));
        rowStation.getUSERDATA().add(rs.getString("USER_DATA8"));
        rowStation.getUSERDATA().add(rs.getString("USER_DATA9"));
        rowStation.getUSERDATA().add(rs.getString("USER_DATA10"));
        return rowStation;
    }

    public GenericType extractStationGeneric(ResultSet rsGeneric) throws SQLException {
        GenericType stationGeneric = new GenericType();
        stationGeneric.setAsset(rsGeneric.getString("ASSET"));
        stationGeneric.setName(rsGeneric.getString("NAME"));
        stationGeneric.setValue(rsGeneric.getString("VALUE"));
        return stationGeneric;
    }
}

