/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer;

import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.worker.future.GEProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.RowObjectExtractor;
import com.ericsson.cms.epgmgmt.util.ResourceUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.sql.DataSource;

public class StationProducer
implements Callable<GEProducer> {
    private final BlockingQueue<RowTypeSGDSTATION> stationQueue;
    private final boolean isStationGenericSupported;
    private DataSource datasource;
    private GEProducer geProducer = null;
    private String getstationscount = "select count(*) from exp_station";
    private String getstations = "select * from exp_station order by station_id";
    private String getstationgeneric = "select * from exp_station_generic where exp_station_generic.station_id = ? order by Name";

    public StationProducer(BlockingQueue<RowTypeSGDSTATION> stationQueue, boolean isStationGenericSupported, DataSource datasource) {
        this.stationQueue = stationQueue;
        this.isStationGenericSupported = isStationGenericSupported;
        this.datasource = datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GEProducer call() throws ExportToXMLException {
        this.geProducer = new GEProducer("Station", false);
        try {
            long count = this.queueStations();
            this.geProducer.setResult(true);
            this.geProducer.logResult(count);
        }
        finally {
            try {
                RowTypeSGDSTATION rowSation = new RowTypeSGDSTATION();
                rowSation.setSTATIONNUM("done");
                this.stationQueue.put(rowSation);
            }
            catch (InterruptedException ex) {
                this.geProducer.handleException(ex);
            }
        }
        return this.geProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long queueStations() throws ExportToXMLException {
        long count;
        block10: {
            Connection connection = null;
            PreparedStatement pStatement = null;
            ResultSet rs = null;
            PreparedStatement pStatementGeneric = null;
            ResultSet rsGeneric = null;
            count = 0L;
            try {
                this.geProducer.setTotalCount(this.datasource, this.getstationscount);
                connection = this.datasource.getConnection();
                pStatement = ResourceUtils.createReadOnlyForwardPS(connection, this.getstations);
                pStatementGeneric = ResourceUtils.createReadOnlyForwardPS(connection, this.getstationgeneric);
                rs = pStatement.executeQuery();
                while (rs.next() && !Thread.currentThread().isInterrupted()) {
                    RowTypeSGDSTATION rowStation = RowObjectExtractor.create().extractStation(rs);
                    if (this.isStationGenericSupported) {
                        pStatementGeneric.setBigDecimal(1, rs.getBigDecimal("station_id"));
                        rsGeneric = pStatementGeneric.executeQuery();
                        while (rsGeneric.next() && !Thread.currentThread().isInterrupted()) {
                            GenericType stationGeneric = RowObjectExtractor.create().extractStationGeneric(rsGeneric);
                            rowStation.getSTATIONGENERIC().add(stationGeneric);
                        }
                        rsGeneric.close();
                    }
                    this.stationQueue.put(rowStation);
                    if (++count % 200L != 0L) continue;
                    this.geProducer.logProgress(count);
                }
                this.geProducer.logProgress(count);
            }
            catch (InterruptedException ex) {
                this.geProducer.handleException(ex);
                break block10;
            }
            catch (SQLException ex2) {
                this.geProducer.handleException(ex2);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.geProducer.logProgress(count);
                ResourceUtils.closeResource(pStatement, rs);
                ResourceUtils.closeResource(pStatementGeneric, rsGeneric);
                ResourceUtils.closeResource(connection);
            }
            ResourceUtils.closeResource(pStatement, rs);
            ResourceUtils.closeResource(pStatementGeneric, rsGeneric);
            ResourceUtils.closeResource(connection);
        }
        return count;
    }
}

