/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.normalizationrules;

import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.entity.rule.NormalizationGroup;
import com.ericsson.cms.epgmgmt.entity.rule.NormalizationGroupComparator;
import com.ericsson.cms.epgmgmt.entity.rule.NormalizationRule;
import com.ericsson.cms.epgmgmt.exception.NormalizationRuleException;
import com.ericsson.cms.epgmgmt.normalizationrules.IEPGRulesNormalizer;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.INormalizationGroupManager;
import com.ericsson.cms.epgmgmt.service.IProviderManager;
import com.ericsson.cms.epgmgmt.service.IPublisherManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Local(value={IEPGRulesNormalizer.class})
@Stateless
public class EPGRulesNormalizer
implements IEPGRulesNormalizer {
    private static final Log logger = LogFactory.getLog(EPGRulesNormalizer.class);
    @PersistenceContext(unitName="epgmanagerjpaunit")
    private EntityManager entityManager;
    @EJB
    private IAlarmActivityLogManager applicationLogger;
    @EJB
    private IProviderManager providerManager;
    @EJB
    private IPublisherManager publisherManager;
    @EJB
    private INormalizationGroupManager normalizationGroupManager;

    @Override
    public boolean applyProviderNormalizationRules(long providerId) throws NormalizationRuleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"applyProviderNormalizationRules(long) - start");
        }
        boolean result = true;
        Provider provider = null;
        String normalizationQuery = null;
        try {
            provider = this.providerManager.getProvider(providerId);
            if (provider == null) {
                this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on provider %d - no provider found in database.", providerId));
                logger.warn((Object)String.format("applyProviderNormalizationRules(long) - no provider found for given provider %d", providerId));
                return result;
            }
            ArrayList normalizationGrps = new ArrayList();
            normalizationGrps.addAll(provider.getNormalizationGroups());
            normalizationGrps.addAll(this.normalizationGroupManager.getAllGlobalForProviders());
            if (normalizationGrps == null || normalizationGrps.size() == 0) {
                this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on provider %s - no normalization rule groups either configured or enabled.", provider.toString()));
                logger.warn((Object)String.format("applyProviderNormalizationRules(long) - no normalization rule groups found for given provider %d", providerId));
                return result;
            }
            Collections.sort(normalizationGrps, new NormalizationGroupComparator());
            for (NormalizationGroup nGrp : normalizationGrps) {
                if (nGrp.getEnabled().booleanValue()) {
                    List normalizationRules = nGrp.getRules();
                    if (normalizationRules == null || normalizationRules.size() == 0) {
                        this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on provider %s - no rules configured for normalization rule group %s.", provider.toString(), nGrp.getName()));
                        continue;
                    }
                    this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on provider %s - started applying normalization rules from group %s.", provider.toString(), nGrp.getName()));
                    logger.info((Object)String.format("Applying normalization rules on provider %s - started applying normalization rules from group %s.", provider.toString(), nGrp.getName()));
                    Query query = null;
                    for (NormalizationRule nRule : normalizationRules) {
                        try {
                            normalizationQuery = nRule.getRuleAsSqlString(false);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)String.format("applyProviderNormalizationRules(long) - Applying normalization rules on provider %d - normalization rule %s, query generate - %s.", providerId, nRule.getName(), normalizationQuery));
                            }
                            query = this.entityManager.createNativeQuery(normalizationQuery);
                            query.executeUpdate();
                        }
                        catch (RuntimeException rtEx) {
                            String errorMsg = String.format("Applying normalization rules on provider %s - normalization rule %s failed.", provider.toString(), nRule.getName());
                            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.NORMALIZATION_RULES, errorMsg);
                            logger.error((Object)("applyProviderNormalizationRules(long) - " + errorMsg), (Throwable)rtEx);
                        }
                    }
                    this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on provider %s - completed applying normalization rules from group %s.", provider.toString(), nGrp.getName()));
                    logger.info((Object)String.format("Applying normalization rules on provider %s - completed applying normalization rules from group %s.", provider.toString(), nGrp.getName()));
                    continue;
                }
                this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on provider %s - normalization rule group, %s,  is not enabled.", provider.toString(), nGrp.getName()));
                logger.info((Object)String.format("EPG Manager:Applying normalization rules on provider %s - normalization rule group, %s,  is not enabled.", provider.toString(), nGrp.getName()));
            }
        }
        catch (NormalizationRuleException nEx) {
            logger.error((Object)String.format("applyProviderNormalizationRules(long) - exception found while applying normalization rules for given provider %d ", providerId), (Throwable)nEx);
            if (normalizationQuery != null) {
                logger.error((Object)String.format(" Generated SQL - %s", normalizationQuery));
            }
            throw nEx;
        }
        catch (Exception ex) {
            String pDetails = provider == null ? Long.toString(providerId) : provider.toString();
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on provider %s - error found while applying normalization rules. error message - %s.", pDetails, ex.getMessage()));
            logger.error((Object)String.format("applyProviderNormalizationRules(long) - exception found while applying normalization rules for given provider %d ", providerId), (Throwable)ex);
            if (normalizationQuery != null) {
                logger.error((Object)String.format(" Generated SQL - %s", normalizationQuery));
            }
            throw new NormalizationRuleException(ex.getMessage(), (Throwable)ex);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"applyProviderNormalizationRules(long) - end");
        }
        return result;
    }

    @Override
    public boolean applyPublisherNormalizationRules(long publisherId) throws NormalizationRuleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"applyPublisherNormalizationRules(long) - start");
        }
        boolean result = true;
        Publisher publisher = null;
        try {
            publisher = this.publisherManager.getPublisher(publisherId);
            if (publisher == null) {
                this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on publisher %d - no publisher found in database.", publisherId));
                logger.warn((Object)String.format("applyPublisherNormalizationRules(long) - no publisher found for given publisher %d", publisherId));
                return result;
            }
            List normalizationGrps = publisher.getNormalizationGroup();
            normalizationGrps.addAll(this.normalizationGroupManager.getAllGlobalForPublishers());
            if (normalizationGrps == null || normalizationGrps.size() == 0) {
                this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on publisher %s - no normalization rule groups either configured or enabled.", publisher.toString()));
                logger.warn((Object)String.format("applyPublisherNormalizationRules(long) - no normalization rule groups found for given publisher %d", publisherId));
                return result;
            }
            Collections.sort(normalizationGrps, new NormalizationGroupComparator());
            for (NormalizationGroup nGrp : normalizationGrps) {
                if (nGrp.getEnabled().booleanValue()) {
                    List normalizationRules = nGrp.getRules();
                    if (normalizationRules == null || normalizationRules.size() == 0) {
                        this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on publisher %s - no rules configured for normalization rule group %s.", publisher.toString(), nGrp.getName()));
                        continue;
                    }
                    this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on publisher %s - started applying normalization rules from group %s.", publisher.toString(), nGrp.getName()));
                    logger.info((Object)String.format("Applying normalization rules on publisher %s - started applying normalization rules from group %s.", publisher.toString(), nGrp.getName()));
                    String normalizationQuery = null;
                    Query query = null;
                    for (NormalizationRule nRule : normalizationRules) {
                        try {
                            normalizationQuery = nRule.getRuleAsSqlString(true);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)String.format("applyPublisherNormalizationRules(long) - Applying normalization rules on publisher %d - normalization rule %s, query generate - %s.", publisherId, nRule.getName(), normalizationQuery));
                            }
                            query = this.entityManager.createNativeQuery(normalizationQuery);
                            query.executeUpdate();
                        }
                        catch (RuntimeException rtEx) {
                            String errorMsg = String.format("Applying normalization rules on publisher %s - normalization rule %s failed.", publisher.toString(), nRule.getName());
                            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.NORMALIZATION_RULES, errorMsg);
                            logger.error((Object)("applyPublisherNormalizationRules(long) - " + errorMsg), (Throwable)rtEx);
                        }
                    }
                    this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on publisher %s - completed applying normalization rules from group %s.", publisher.toString(), nGrp.getName()));
                    logger.info((Object)String.format("Applying normalization rules on publisher %s - completed applying normalization rules from group %s.", publisher.toString(), nGrp.getName()));
                    continue;
                }
                this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on publisher %s - normalization rule group, %s,  is not enabled.", publisher.toString(), nGrp.getName()));
                logger.info((Object)String.format("EPG Manager:Applying normalization rules on publisher %s - normalization rule group, %s,  is not enabled.", publisher.toString(), nGrp.getName()));
            }
        }
        catch (NormalizationRuleException nEx) {
            logger.error((Object)String.format("applyPublisherNormalizationRules(long) - exception found while applying normalization rules for given publisher %d ", publisherId), (Throwable)nEx);
            throw nEx;
        }
        catch (Exception ex) {
            String pDetails = publisher == null ? Long.toString(publisherId) : publisher.toString();
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.NORMALIZATION_RULES, String.format("Applying normalization rules on publisher %s - error found while applying normalization rules. error message - %s.", pDetails, ex.getMessage()));
            logger.error((Object)String.format("applyPublisherNormalizationRules(long) - exception found while applying normalization rules for given publisher %d ", publisherId), (Throwable)ex);
            throw new NormalizationRuleException(ex.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"applyPublisherNormalizationRules(long) - end");
        }
        return result;
    }
}

