/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.plugin;

import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.PluginPropertyEntity;
import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.ProviderPluginValue;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.PublisherPluginValue;
import com.ericsson.cms.epgmgmt.entity.enumeration.EPGPluginTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.exception.PluginFrameworkException;
import com.ericsson.cms.epgmgmt.plugin.IEPGPluginManager;
import com.ericsson.cms.epgmgmt.plugin.PluginFactory;
import com.ericsson.cms.epgmgmt.plugin.PluginMBean;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import com.ericsson.cms.epgmgmt.service.IProviderManager;
import com.ericsson.cms.epgmgmt.service.IPublisherManager;
import com.ericsson.cms.epgmgmt.service.ProviderRouteBuilder;
import com.ericsson.cms.epgmgmt.service.PublisherRouteBuilder;
import com.ericsson.epgmgr.plugin.EPGPluginException;
import com.ericsson.epgmgr.plugin.IEPGManagerPlugin;
import com.ericsson.epgmgr.plugin.IEPGManagerProvider;
import com.ericsson.epgmgr.plugin.IEPGManagerPublisher;
import com.ericsson.epgmgr.plugin.PluginAttribute;
import com.ericsson.epgmgr.plugin.PluginProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.camel.Exchange;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="EpgManager:service=com.ericsson.cms.epgmgmt.plugin.EPGPluginManager")
@Local(value={IEPGPluginManager.class})
public class EPGPluginManager
implements IEPGPluginManager,
PluginMBean {
    private JobManager jobManager = new JobManager();
    private static final Log logger = LogFactory.getLog(EPGPluginManager.class);
    private int providerPluginCount = 0;
    private int publisherPluginCount = 0;
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    public static String repository = System.getProperty("com.tandbergtv.cms.product.dir") + System.getProperty("file.separator") + "plugins" + System.getProperty("file.separator") + "epgmgmt";
    @EJB
    private IEPGMetadataManager epgMetadataManager;
    @EJB
    private IProviderManager providerManager;
    @EJB
    private IPublisherManager publisherManager;
    @EJB
    private IAlarmActivityLogManager applicationLogger;

    @Override
    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"start() - start");
        }
        this.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"start() - end");
        }
    }

    @Override
    public void stop() {
    }

    private synchronized void init() {
        this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.PLUGIN_FRAMEWORK, "Begin - Plug-in Discovery");
        if (repository == null || repository.length() <= 0 || !new File(repository).isDirectory()) {
            logger.error((Object)(" Invalid folder for plugins - " + repository));
            return;
        }
        try {
            List listOfFiles = (List)FileUtils.listFiles((File)new File(repository), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".jar"), (IOFileFilter)TrueFileFilter.INSTANCE);
            this.providerPluginCount = 0;
            this.publisherPluginCount = 0;
            for (File file : listOfFiles) {
                logger.debug((Object)("Looking in " + file.getAbsolutePath() + " for provider plugin"));
                IEPGManagerProvider providerPlugin = PluginFactory.getProviderPlugin(file);
                this.loadPlugin(file, providerPlugin);
                logger.debug((Object)("Looking in " + file.getAbsolutePath() + " for publisher plugin"));
                IEPGManagerPublisher publisherPlugin = PluginFactory.getPublisherPlugin(file);
                this.loadPlugin(file, publisherPlugin);
            }
            this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.PLUGIN_FRAMEWORK, "Provider plugins discovered: " + this.providerPluginCount);
            logger.debug((Object)("Total Providers Loaded " + this.providerPluginCount));
            this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.PLUGIN_FRAMEWORK, "Publisher plugins discovered: " + this.publisherPluginCount);
            logger.debug((Object)("Total Publishers Loaded " + this.publisherPluginCount));
        }
        catch (EPGPluginException e) {
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, "Error found while discovering plug-ins, error message " + e.getMessage());
            logger.error((Object)"init() - ", (Throwable)e);
            throw new EPGPluginException("Fail to init EPGPluginManager", (Throwable)e);
        }
    }

    private void loadPlugin(File file, IEPGManagerPublisher publisherPlugin) {
        if (publisherPlugin == null) {
            logger.debug((Object)(" Provider plugin not found in " + file.getAbsolutePath()));
            return;
        }
        try {
            logger.debug((Object)("Publisher plugin found in " + file.getAbsolutePath()));
            EpgFormat epgFormat = new EpgFormat();
            epgFormat.setJarName(file.getAbsolutePath());
            epgFormat.setFormatName(publisherPlugin.getFormat());
            epgFormat.setType(EPGPluginTypeEnum.Publisher.toString());
            epgFormat.setVersion(publisherPlugin.getVersion());
            epgFormat.setInfo(EPGPluginManager.getPluginInfo((IEPGManagerPlugin)publisherPlugin));
            ArrayList newPluginProperties = publisherPlugin.getProperties();
            if (newPluginProperties == null) {
                newPluginProperties = new ArrayList();
            }
            epgFormat.setPluginProperties(PluginPropertyEntity.bulkCreate((EpgFormat)epgFormat, newPluginProperties));
            this.epgMetadataManager.createOrUpdate(epgFormat);
            this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.PLUGIN_FRAMEWORK, "Discovered plug-in " + epgFormat.toString());
            ++this.publisherPluginCount;
        }
        catch (Exception ex) {
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, "Error while loading Publisher plug-in from " + file.getAbsolutePath());
            logger.error((Object)"exception found while initializing plugin ", (Throwable)ex);
        }
    }

    private void loadPlugin(File file, IEPGManagerProvider providerPlugin) {
        if (providerPlugin == null) {
            logger.debug((Object)(" Provider plugin not found in " + file.getAbsolutePath()));
            return;
        }
        try {
            logger.debug((Object)(" Provider plugin found in " + file.getAbsolutePath()));
            EpgFormat epgFormat = new EpgFormat();
            epgFormat.setJarName(file.getAbsolutePath());
            epgFormat.setFormatName(providerPlugin.getFormat());
            epgFormat.setType(EPGPluginTypeEnum.Provider.toString());
            epgFormat.setVersion(providerPlugin.getVersion());
            epgFormat.setInfo(EPGPluginManager.getPluginInfo((IEPGManagerPlugin)providerPlugin));
            ArrayList pluginProperties = providerPlugin.getProperties();
            if (pluginProperties == null) {
                pluginProperties = new ArrayList();
            }
            epgFormat.setPluginProperties(PluginPropertyEntity.bulkCreate((EpgFormat)epgFormat, pluginProperties));
            this.epgMetadataManager.createOrUpdate(epgFormat);
            this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.PLUGIN_FRAMEWORK, "Discovered plug-in " + epgFormat.toString());
            ++this.providerPluginCount;
        }
        catch (Exception ex) {
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, "Error while loading Provider plug-in from " + file.getAbsolutePath());
            logger.error((Object)"exception found while initializing plugin ", (Throwable)ex);
        }
    }

    public List<EpgFormat> getAllConfiguredEpgFormats() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllConfiguredEpgFormats() - start");
        }
        List result = null;
        try {
            result = this.epgMetadataManager.getAllEpgFormatDetails();
        }
        catch (Exception ex) {
            logger.error((Object)"getAllConfiguredEpgFormats()", (Throwable)ex);
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, "Error found while retrieving EPGFormat details, error message, " + ex.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllConfiguredEpgFormats() - end");
        }
        return result;
    }

    public List<EpgFormat> getAllProvidersEpgFormats() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllProvidersEpgFormats() - start");
        }
        List result = null;
        try {
            result = this.epgMetadataManager.getAllProvidersEpgFormats();
        }
        catch (Exception ex) {
            logger.error((Object)"getAllProvidersEpgFormats()", (Throwable)ex);
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, "Error found while retrieving EPGFormat details of Providers, error message, " + ex.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllProvidersEpgFormats() - end");
        }
        return result;
    }

    public List<EpgFormat> getAllPublishersEpgFormats() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllPublishersEpgFormats() - start");
        }
        List result = null;
        try {
            result = this.epgMetadataManager.getAllPublishersEpgFormats();
        }
        catch (Exception ex) {
            logger.error((Object)"getAllPublishersEpgFormats()", (Throwable)ex);
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, "Error found while retrieving EPGFormat details of Publishers, error message, " + ex.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getAllPublishersEpgFormats() - end");
        }
        return result;
    }

    public List<PluginProperty> getProperties(long formatId) throws EPGPluginException {
        EpgFormat epgFormat = null;
        List<Object> pluginProperty = null;
        try {
            pluginProperty = new ArrayList<PluginProperty>();
            epgFormat = this.epgMetadataManager.getEpgFormatDetailsbyId(formatId);
            if (epgFormat == null) {
                throw new Exception("no plug-in is registered for the given format Id" + formatId);
            }
            if (epgFormat.isETV()) {
                return pluginProperty;
            }
            if (epgFormat.isProviderType()) {
                IEPGManagerProvider epgProviderMgr = PluginFactory.getProviderPlugin(new File(epgFormat.getJarName()));
                if (epgProviderMgr == null) {
                    return pluginProperty;
                }
                pluginProperty = epgProviderMgr.getProperties();
            } else {
                IEPGManagerPublisher epgPublisherMgr = PluginFactory.getPublisherPlugin(new File(epgFormat.getJarName()));
                if (epgPublisherMgr == null) {
                    return pluginProperty;
                }
                pluginProperty = epgPublisherMgr.getProperties();
            }
        }
        catch (Exception epgEx) {
            logger.error((Object)"getProperties(long)", (Throwable)epgEx);
            String formatDtls = epgFormat == null ? Long.toString(formatId) : epgFormat.toString();
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, "Error found while retrieving plug-in properties for EPG Format " + formatDtls + ", error message, " + epgEx.getMessage());
            throw new EPGPluginException("Error found while retrieving plug-in properties for EPG Format ID " + formatId + ", error message, " + epgEx.getMessage());
        }
        return pluginProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void executePluginForProvider(Exchange exchange, String etvFileLocation) throws PluginFrameworkException, EPGPluginException {
        long providerId = -1L;
        Provider targetProvider = null;
        ArrayList<File> inputFiles = null;
        try {
            providerId = ProviderRouteBuilder.getProviderId(exchange);
            logger.trace((Object)(" Provider ID -" + providerId));
            targetProvider = this.providerManager.getProvider(providerId);
            IEPGManagerProvider epgProviderManager = null;
            File file = new File(targetProvider.getEpgFormat().getJarName());
            epgProviderManager = PluginFactory.getProviderPlugin(file);
            if (epgProviderManager == null) {
                throw new EPGPluginException(" PluginFactory returned null for " + targetProvider.getEpgFormat());
            }
            List grouped = (List)exchange.getProperty("CamelGroupedExchange", List.class);
            inputFiles = new ArrayList<File>(grouped.size());
            for (Exchange eachExchange : grouped) {
                String epgFileLocation = null;
                epgFileLocation = (String)eachExchange.getIn().getHeader("CamelFileNameProduced");
                if (StringUtils.isEmpty((String)epgFileLocation) || !new File(epgFileLocation).exists()) {
                    String msg = " Input file location " + epgFileLocation + " for Provider - " + targetProvider + " invalid";
                    logger.error((Object)msg);
                    throw new PluginFrameworkException(msg);
                }
                inputFiles.add(new File(epgFileLocation));
            }
            logger.info((Object)(" Found " + inputFiles.size() + " files for Provider " + targetProvider));
            File parentDir = new File(etvFileLocation).getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                String msg = "Failed to create " + parentDir + " for " + targetProvider;
                logger.error((Object)msg);
                throw new PluginFrameworkException(msg);
            }
            List ppList = epgProviderManager.getProperties();
            this.setProperties(targetProvider.getPluginPropertyValues(), ppList);
            logger.trace((Object)(" Calling plugin to execute for provider " + targetProvider + " with " + ppList.size() + " plugin properties"));
            String routeId = exchange.getFromRouteId();
            try {
                this.jobManager.bindThread(routeId);
                epgProviderManager.toETVFormat(inputFiles, etvFileLocation, ppList);
            }
            finally {
                this.jobManager.unbindThread(routeId);
            }
            if (EPGPluginManager.validateForPlugin((IEPGManagerPlugin)epgProviderManager) || EPGPluginManager.ftpToDatabasetForPlugin((IEPGManagerPlugin)epgProviderManager)) {
                if (!new File(etvFileLocation).exists()) {
                    String msg = "Plugin for Provider " + targetProvider + " did not create output file - " + etvFileLocation;
                    logger.error((Object)msg);
                    throw new PluginFrameworkException(msg);
                }
                exchange.getIn().setBody((Object)new File(etvFileLocation));
                exchange.getIn().setHeader("CamelFileName", (Object)etvFileLocation);
            }
        }
        catch (EPGPluginException e) {
            this.applicationLogger.createIngestErrorLog(exchange);
            this.handlePluginExecutionError(e, targetProvider.toString());
        }
        catch (Throwable t) {
            this.applicationLogger.createIngestErrorLog(exchange);
            String pDetails = targetProvider == null ? Long.toString(providerId) : targetProvider.toString();
            String msg = "Failed to execute Provider plugin" + (providerId != -1L ? " for Provider ID - " + pDetails : "") + " " + t.getMessage();
            logger.error((Object)msg);
            throw new PluginFrameworkException(msg, t);
        }
    }

    private void setProperties(List<ProviderPluginValue> values, List<PluginProperty> ppList) {
        block0: for (PluginProperty pluginProperty : ppList) {
            for (ProviderPluginValue ppv : values) {
                if (!pluginProperty.getName().equals(ppv.getPluginPropertyEntity().getPropertyName())) continue;
                pluginProperty.setConfiguredValue(ppv.getValue());
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void executePluginForPublisher(Exchange exchange, String epgFileLocation) throws PluginFrameworkException, EPGPluginException {
        long publisherId = -1L;
        Publisher targerPublisher = null;
        try {
            String etvFileLocation = ((File)exchange.getIn().getBody()).getAbsolutePath();
            publisherId = PublisherRouteBuilder.getPublisherId(exchange);
            logger.trace((Object)(" input file name -" + etvFileLocation));
            logger.trace((Object)(" output file name -" + epgFileLocation));
            logger.trace((Object)(" Publisher ID -" + publisherId));
            targerPublisher = this.publisherManager.getPublisher(publisherId);
            IEPGManagerPublisher epgPublisherManager = null;
            File file = new File(targerPublisher.getEpgFormat().getJarName());
            epgPublisherManager = PluginFactory.getPublisherPlugin(file);
            if (epgPublisherManager == null) {
                throw new EPGPluginException(" PluginFactory returned null for " + targerPublisher.getEpgFormat());
            }
            if (etvFileLocation == null || etvFileLocation.trim().equals("") || !new File(etvFileLocation).exists()) {
                String msg = " Input file location " + etvFileLocation + " for Publisher - " + targerPublisher + " invalid";
                throw new PluginFrameworkException(msg);
            }
            if (epgFileLocation == null || epgFileLocation.trim().equals("")) {
                String msg = " Output file location " + epgFileLocation + " for Publisher - " + targerPublisher + " invalid";
                throw new PluginFrameworkException(msg);
            }
            File parentDir = new File(epgFileLocation).getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                String msg = "Failed to create " + parentDir + " for " + targerPublisher;
                throw new PluginFrameworkException(msg);
            }
            List ppList = epgPublisherManager.getProperties();
            this.setPublisherProperties(targerPublisher.getPluginPropertyValues(), ppList);
            logger.trace((Object)(" Calling plugin to execute for publisher " + targerPublisher + " with " + ppList.size() + " plugin properties"));
            String routeId = exchange.getFromRouteId();
            try {
                this.jobManager.bindThread(routeId);
                epgPublisherManager.fromETVFormat(etvFileLocation, epgFileLocation, ppList);
            }
            finally {
                this.jobManager.unbindThread(routeId);
            }
            if (!new File(epgFileLocation).exists()) {
                String msg = "Plugin for Publisher " + targerPublisher + " did not create output file - " + epgFileLocation;
                logger.error((Object)msg);
                throw new PluginFrameworkException(msg);
            }
            exchange.getIn().setBody((Object)new File(epgFileLocation));
            exchange.getIn().setHeader("CamelFileName", (Object)epgFileLocation);
        }
        catch (EPGPluginException e) {
            this.applicationLogger.createPublishErrorLog(exchange);
            this.handlePluginExecutionError(e, targerPublisher.toString());
        }
        catch (Throwable t) {
            this.applicationLogger.createPublishErrorLog(exchange);
            String msg = "Failed to execute Publisher plugin " + (publisherId != -1L ? " for Publisher ID - " + publisherId : "") + t.getMessage();
            logger.error((Object)msg);
            throw new PluginFrameworkException(msg, t);
        }
    }

    private void setPublisherProperties(List<PublisherPluginValue> values, List<PluginProperty> ppList) {
        block0: for (PluginProperty pluginProperty : ppList) {
            for (PublisherPluginValue ppv : values) {
                if (!pluginProperty.getName().equals(ppv.getPluginPropertyEntity().getPropertyName())) continue;
                pluginProperty.setConfiguredValue(ppv.getValue());
                continue block0;
            }
        }
    }

    public static String getPluginInfo(IEPGManagerPlugin plugin) {
        return EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.INFO);
    }

    private static String getPluginAttribute(IEPGManagerPlugin plugin, PluginAttribute attrib) {
        if (plugin == null || plugin.getAttributes() == null) {
            return null;
        }
        return (String)plugin.getAttributes().get(attrib);
    }

    public static String getPluginETVFormat(IEPGManagerPlugin plugin) {
        return EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.ETV_FORMAT);
    }

    public static boolean validateForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.VALIDATE));
    }

    public static boolean ftpToDatabasetForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.FTP_TO_DATABASE));
    }

    public static boolean ingestForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.INGEST));
    }

    public static boolean validationRuleForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.VALIDATIONRULE));
    }

    public static boolean nomalizationRuleForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.NORMALIZATIONRULE));
    }

    public static boolean mergeForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.MERGE));
    }

    public static boolean exportToStgForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.EXPORT_TO_STG));
    }

    public static boolean exportToXmlForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.EXPORT_TO_XML));
    }

    public List<PluginProperty> validateProviderProperties(Provider provider) throws EPGPluginException {
        IEPGManagerProvider epgProviderManager = PluginFactory.getProviderPlugin(provider);
        List<PluginProperty> ppList = this.convertProviderPluginProperties(epgProviderManager.getProperties(), provider);
        epgProviderManager.validateProperties(ppList);
        logger.debug((Object)"validateProviderProperties(List<PluginProperty>) - end");
        return ppList;
    }

    public List<PluginProperty> validatePublisherProperties(Publisher publisher) throws EPGPluginException {
        IEPGManagerPublisher epgPublisherManager = PluginFactory.getPublisherPlugin(publisher);
        List<PluginProperty> ppList = this.convertPublisherPluginProperties(epgPublisherManager.getProperties(), publisher);
        epgPublisherManager.validateProperties(ppList);
        logger.debug((Object)"validatePublisherProperties(List<PluginProperty>) - end");
        return ppList;
    }

    private List<PluginProperty> convertProviderPluginProperties(List<PluginProperty> ppList, Provider provider) {
        for (PluginProperty pluginProperty : ppList) {
            for (ProviderPluginValue ppv : provider.getPluginPropertyValues()) {
                if (!pluginProperty.getName().equals(ppv.getPluginPropertyEntity().getPropertyName())) continue;
                pluginProperty.setConfiguredValue(ppv.getValue());
                break;
            }
            if (pluginProperty.getConfiguredValue() != null) continue;
            logger.warn((Object)(" Provider " + provider + " has a no value for property " + pluginProperty.getName() + ". use the default value :" + pluginProperty.getDefaultValue()));
            pluginProperty.setConfiguredValue(pluginProperty.getDefaultValue());
        }
        return ppList;
    }

    private List<PluginProperty> convertPublisherPluginProperties(List<PluginProperty> ppList, Publisher publisher) {
        for (PluginProperty pluginProperty : ppList) {
            for (PublisherPluginValue ppv : publisher.getPluginPropertyValues()) {
                if (!pluginProperty.getName().equals(ppv.getPluginPropertyEntity().getPropertyName())) continue;
                pluginProperty.setConfiguredValue(ppv.getValue());
                break;
            }
            if (pluginProperty.getConfiguredValue() != null) continue;
            logger.warn((Object)(" Publisher " + publisher + " has a no value for property " + pluginProperty.getName() + ". use the default value :" + pluginProperty.getDefaultValue()));
            pluginProperty.setConfiguredValue(pluginProperty.getDefaultValue());
        }
        return ppList;
    }

    public void interruptRunningJob(String routeId) {
        this.jobManager.interruptRoute(routeId);
    }

    private void handlePluginExecutionError(Throwable t, String target) {
        if (this.jobManager.isTriggedByInterrupted()) {
            logger.warn((Object)("The exception might be caused by stopping job ! (Target:" + target + " Error:" + t.getMessage() + ")"));
            this.jobManager.cleanTimeMarker();
            return;
        }
        throw new EPGPluginException(" Plugin threw exception " + t.getMessage() + "  for " + target, t);
    }

    class JobManager {
        private Map<String, Long> runningJob = new LinkedHashMap<String, Long>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Long> eldest) {
                return this.size() > 100;
            }
        };
        private long interruptedTime = 0L;

        JobManager() {
        }

        public void bindThread(String routeId) {
            this.runningJob.put(routeId, Thread.currentThread().getId());
        }

        public void unbindThread(String routeId) {
            this.runningJob.remove(routeId);
        }

        public boolean isTriggedByInterrupted() {
            return this.interruptedTime > 0L && System.currentTimeMillis() - this.interruptedTime < 10000L;
        }

        public void cleanTimeMarker() {
            this.interruptedTime = 0L;
        }

        public void interruptRoute(String routeId) {
            if (this.runningJob.get(routeId) == null) {
                return;
            }
            Long currentThreadId = this.runningJob.get(routeId);
            for (Thread thread : Thread.getAllStackTraces().keySet()) {
                if (!thread.isAlive() || thread.getId() != currentThreadId.longValue()) continue;
                try {
                    logger.info((Object)("The EPGPlugin is trying to interrupt the current running job for " + routeId + " , please ignore the follow exception stack."));
                    this.interruptedTime = System.currentTimeMillis();
                    thread.interrupt();
                }
                catch (SecurityException e) {
                    logger.error((Object)("Can not interrupt the current running job for " + routeId), (Throwable)e);
                }
                break;
            }
            this.unbindThread(routeId);
        }
    }
}

