/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.plugin;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JarClassLoader
extends URLClassLoader {
    private static Log logger = LogFactory.getLog(JarClassLoader.class);

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static boolean isJar(String fileName) {
        return fileName != null && fileName.toLowerCase().endsWith(".jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File jarEntryAsFile(JarFile jarFile, JarEntry jarEntry) throws IOException {
        File file;
        InputStream input = null;
        FileOutputStream output = null;
        try {
            int readCount;
            String name = jarEntry.getName();
            int i = name.lastIndexOf(46);
            String extension = i > -1 ? name.substring(i) : "";
            File file2 = File.createTempFile(name.substring(0, name.length() - extension.length()) + ".", extension);
            file2.deleteOnExit();
            input = jarFile.getInputStream(jarEntry);
            output = new FileOutputStream(file2);
            byte[] buffer = new byte[4096];
            while ((readCount = input.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, readCount);
            }
            file = file2;
        }
        catch (Throwable throwable) {
            JarClassLoader.close(input);
            JarClassLoader.close(output);
            throw throwable;
        }
        JarClassLoader.close(input);
        JarClassLoader.close(output);
        return file;
    }

    public JarClassLoader(URL[] urls, ClassLoader parent) throws IOException {
        super(urls, parent);
        for (URL url : urls) {
            if (!JarClassLoader.isJar(url.getPath())) continue;
            this.addJarResource(new File(url.getPath()));
        }
    }

    private void addJarResource(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        this.addURL(file.toURI().toURL());
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory() || !JarClassLoader.isJar(jarEntry.getName())) continue;
            this.addJarResource(JarClassLoader.jarEntryAsFile(jarFile, jarEntry));
        }
    }
}

