/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.plugin;

import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.plugin.EPGPluginLogger;
import com.ericsson.cms.epgmgmt.plugin.JarClassLoader;
import com.ericsson.epgmgr.plugin.EPGPluginException;
import com.ericsson.epgmgr.plugin.IEPGManagerPlugin;
import com.ericsson.epgmgr.plugin.IEPGManagerProvider;
import com.ericsson.epgmgr.plugin.IEPGManagerPublisher;
import com.ericsson.epgmgr.plugin.IEPGPluginLogger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.ServiceLoader;

public class PluginFactory {
    private static void initializePlugin(IEPGManagerPlugin plugin) {
        Locale locale = Locale.getDefault();
        plugin.setLogger((IEPGPluginLogger)new EPGPluginLogger());
        plugin.setLocale(locale);
    }

    private static <T extends IEPGManagerPlugin> T getPlugin(File file, Class<T> typeOfPlugin) {
        JarClassLoader urlCl;
        try {
            urlCl = new JarClassLoader(new URL[]{file.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException e) {
            throw new EPGPluginException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new EPGPluginException(e.getMessage(), (Throwable)e);
        }
        ServiceLoader<T> pluginServiceLoader = ServiceLoader.load(typeOfPlugin, urlCl);
        Iterator<T> pluginIterator = pluginServiceLoader.iterator();
        if (pluginIterator.hasNext()) {
            IEPGManagerPlugin plugin = (IEPGManagerPlugin)pluginIterator.next();
            PluginFactory.initializePlugin(plugin);
            return (T)plugin;
        }
        return null;
    }

    public static IEPGManagerProvider getProviderPlugin(File file) {
        return PluginFactory.getPlugin(file, IEPGManagerProvider.class);
    }

    public static IEPGManagerPublisher getPublisherPlugin(File file) {
        return PluginFactory.getPlugin(file, IEPGManagerPublisher.class);
    }

    public static IEPGManagerProvider getProviderPlugin(Provider provider) {
        return PluginFactory.getProviderPlugin(new File(provider.getEpgFormat().getJarName()));
    }

    public static IEPGManagerPublisher getPublisherPlugin(Publisher publisher) {
        return PluginFactory.getPublisherPlugin(new File(publisher.getEpgFormat().getJarName()));
    }
}

