/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.service;

import com.ericsson.cms.epgmgmt.service.IRouteStatusManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.camel.builder.RouteBuilder;
import org.apache.log4j.Logger;

public abstract class BaseRouteBuilder
extends RouteBuilder {
    private static final Logger logger = Logger.getLogger(BaseRouteBuilder.class);
    public static final long MIN_INITIAL_DELAY_MILLIS = 10000L;
    public static final String IS_ETV = "IS_ETV";

    public long getLastRuntime(String routeName) {
        try {
            IRouteStatusManager routeStatusManager = (IRouteStatusManager)InjectionUtil.injectInstance((String)"cms/RouteStatusManager/local", IRouteStatusManager.class);
            return routeStatusManager.getLastRunStartTimeInMillis(routeName);
        }
        catch (Exception e) {
            logger.error((Object)(" Failed to get last run start time for route - " + routeName + ". Using 0 as last run time."));
            return 0L;
        }
    }

    public static long calculateInitialDelay(long lastRunTimeMillis, long frequencyMillis, String routeId) {
        long currentTimeMillis = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        if (logger.isTraceEnabled()) {
            cal.setTimeInMillis(lastRunTimeMillis);
            logger.trace((Object)(" Route " + routeId + " last ran at - " + sdf.format(cal.getTime())));
            cal.setTimeInMillis(lastRunTimeMillis + frequencyMillis);
            logger.trace((Object)(" Route " + routeId + " would have ran at - " + sdf.format(cal.getTime())));
        }
        long initialDelayMillis = 10000L;
        if (currentTimeMillis < lastRunTimeMillis) {
            logger.error((Object)(" Last run time found to be in future for route " + routeId + "!"));
        } else {
            initialDelayMillis = lastRunTimeMillis + frequencyMillis - currentTimeMillis;
            if (initialDelayMillis < 10000L) {
                initialDelayMillis = 10000L;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(" InitialDelay: " + initialDelayMillis + " millis"));
            cal.setTimeInMillis(currentTimeMillis + initialDelayMillis);
            logger.trace((Object)(" Route " + routeId + " will now run at - " + sdf.format(cal.getTime())));
        }
        return initialDelayMillis;
    }
}

