/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.service;

import com.ericsson.cms.epgmgmt.camel.FtpComponentExt;
import com.ericsson.cms.epgmgmt.camel.FtpConsumerExt;
import com.ericsson.cms.epgmgmt.camel.FtpEndpointExt;
import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.RouteStatus;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.exception.ExportToStagingException;
import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.exception.IngestException;
import com.ericsson.cms.epgmgmt.exception.MergeException;
import com.ericsson.cms.epgmgmt.exception.NormalizationRuleException;
import com.ericsson.cms.epgmgmt.exception.PluginFrameworkException;
import com.ericsson.cms.epgmgmt.exception.ValidationRuleException;
import com.ericsson.cms.epgmgmt.export.ExportETVTypeEnum;
import com.ericsson.cms.epgmgmt.export.IEPGExportGuideData;
import com.ericsson.cms.epgmgmt.plugin.EPGPluginManager;
import com.ericsson.cms.epgmgmt.plugin.IEPGPluginManager;
import com.ericsson.cms.epgmgmt.plugin.PluginFactory;
import com.ericsson.cms.epgmgmt.service.CamelMbean;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.ICamelManager;
import com.ericsson.cms.epgmgmt.service.IProviderManager;
import com.ericsson.cms.epgmgmt.service.IPublisherManager;
import com.ericsson.cms.epgmgmt.service.IRouteStatusManager;
import com.ericsson.cms.epgmgmt.service.ProviderRouteBuilder;
import com.ericsson.cms.epgmgmt.service.PublisherRouteBuilder;
import com.ericsson.cms.epgmgmt.util.CalendarUtil;
import com.ericsson.cms.epgmgmt.util.ConfigProperties;
import com.ericsson.cms.epgmgmt.util.OnDemanFtpProducer;
import com.ericsson.epgmgr.plugin.EPGPluginException;
import com.ericsson.epgmgr.plugin.IEPGManagerPlugin;
import com.ericsson.epgmgr.plugin.IEPGManagerPublisher;
import com.ericsson.epgmgr.plugin.PluginAttribute;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.ejb.EjbComponent;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="EpgManager:service=com.ericsson.cms.epgmgmt.service.CamelManager")
@Depends(value={"Neptune:service=com.tandbergtv.neptune.configuration.service.IConfigurationService"})
@Local(value={ICamelManager.class})
public class CamelManager
implements ICamelManager,
CamelMbean {
    private CamelContext camelContext;
    private static final Logger logger = Logger.getLogger(CamelManager.class);
    private static final Logger auditLogger = Logger.getLogger((String)"com.ericsson.cms.epgmgmt.AuditLogger");
    public static final String FTP_TO_DATABASE_DIRECT_ENDPOINT_URI = "direct:ftpToDatabase";
    public static final String FTP_FROM_DATABASE_DIRECT_ENDPOINT_URI = "direct:ftpFromDatabase";
    public static final String FTP_TO_DATABASE_URI = "ftp://{{ftp.username}}@{{dbserver}}:{{ftp.port}}/public/epgmanager?password={{ftp.password}}&ftpClient.remoteVerificationEnabled=false&fileName=Guidedata.xml&separator=UNIX&passiveMode=true&disconnect=true&stepwise=false";
    public static final String VALIDATION_URI = "validator:ETV_EPG.xsd";
    private static final String INGEST_URI = "ejb:cms/CamelManager/local?method=executeLoad(*)";
    private static final String MERGE_URI = "ejb:cms/CamelManager/local?method=executeMerge(*)";
    private static final String EXPORT_TO_STG_URI = "ejb:cms/CamelManager/local?method=executeExportToStaging(*)";
    private static final String EXPORT_TO_XML_URI = "ejb:cms/CamelManager/local?method=executeExportToXML(*)";
    public static final String INGEST_ERROR_HANDLER_URI = "ejb:cms/AlarmActivityLogManager/local?method=createIngestErrorLog(*)";
    private static final String SCHEMA_VALIDATION_HANDLER_URI = "ejb:cms/AlarmActivityLogManager/local?method=createValidationError(*)";
    private static final String MERGE_ERROR_HANDLER_URI = "ejb:cms/AlarmActivityLogManager/local?method=createMergeErrorLog(*)";
    private static final String PLUGINFRAMEWORK_ERROR_HANDLER_URI = "ejb:cms/AlarmActivityLogManager/local?method=createPluginFrameworkErrorLog(*)";
    private static final String PLUGIN_ERROR_HANDLER_URI = "ejb:cms/AlarmActivityLogManager/local?method=createPluginErrorLog(*)";
    private static final String EXPORT_TO_STG_ERROR_HANDLER_URI = "ejb:cms/AlarmActivityLogManager/local?method=createExportToStagingErrorLog(*)";
    private static final String EXPORT_TO_XML_ERROR_HANDLER_URI = "ejb:cms/AlarmActivityLogManager/local?method=createExportToXMLErrorLog(*)";
    private static final String WORKFLOW_ERROR_HANDLER_URI = "ejb:cms/AlarmActivityLogManager/local?method=createWorkflowErrorLog(*)";
    private static final String VALIDATION_ERROR_HANDLER_URI = "ejb:cms/AlarmActivityLogManager/local?method=createValidationErrorLog(*)";
    private static final String NORMALIZATION_ERROR_HANDLER_URI = "ejb:cms/AlarmActivityLogManager/local?method=createNormalizationErrorLog(*)";
    private static final String PROVIDER_PLUGIN_URI = "ejb:cms/EPGPluginManager/local?method=executePluginForProvider(*,{{workfolder}}/providerpluginoutbox/${header.PROVIDER_ID}.xml)";
    private static final String PUBLISHER_PLUGIN_URI = "ejb:cms/EPGPluginManager/local?method=executePluginForPublisher(*,{{workfolder}}/publisherpluginoutbox/${header.PUBLISHER_ID}.xml)";
    private static final String NORMALIZATION_RULES_FOR_PROVIDER_URI = "ejb:cms/EPGRulesNormalizer/local?method=applyProviderNormalizationRules(${header.PROVIDER_ID})";
    private static final String VALIDATION_RULES_FOR_PROVIDER_URI = "ejb:cms/EPGRulesValidator/local?method=applyValidationRules(${header.PROVIDER_ID})";
    private static final String NORMALIZATION_RULES_FOR_PUBLISHER_URI = "ejb:cms/EPGRulesNormalizer/local?method=applyPublisherNormalizationRules(${header.PUBLISHER_ID})";
    private static final String FTP_TO_DATABASE_URI_KEY = "FTP_TO_DATABASE_URI";
    private static final String INGEST_URI_KEY = "INGEST_URI";
    private static final String MERGE_URI_KEY = "MERGE_URI";
    private static final String PROVIDER_PLUGIN_URI_KEY = "PROVIDER_PLUGIN_URI";
    private static final String PUBLISHER_PLUGIN_URI_KEY = "PUBLISHER_PLUGIN_URI";
    private static final String EXPORT_TO_STG_URI_KEY = "EXPORT_TO_STG_URI";
    private static final String EXPORT_TO_XML_URI_KEY = "EXPORT_TO_XML_URI";
    public static final String INGEST_ERROR_HANDLER_URI_KEY = "INGEST_ERROR_HANDLER_URI";
    private static final String MERGE_ERROR_HANDLER_URI_KEY = "MERGE_ERROR_HANDLER_URI";
    private static final String EXPORT_TO_STG_ERROR_HANDLER_URI_KEY = "EXPORT_TO_STG_ERROR_HANDLER_URI";
    private static final String EXPORT_TO_XML_ERROR_HANDLER_URI_KEY = "EXPORT_TO_XML_ERROR_HANDLER_URI";
    private static final String PLUGINFRAMEWORK_ERROR_HANDLER_URI_KEY = "PLUGINFRAMEWORK_ERROR_HANDLER_URI";
    private static final String PLUGIN_ERROR_HANDLER_URI_KEY = "PLUGIN_ERROR_HANDLER_URI";
    private static final String WORKFLOW_ERROR_HANDLER_URI_KEY = "WORKFLOW_ERROR_HANDLER_URI";
    private static String guideDataOutLocation = null;
    private static final String UI_CONFIGURATION_PROPERTIES_SETTING_PATH = "com.ericsson.cms.epgmgmt.configuration";
    @EJB
    IProviderManager providerManager;
    @EJB
    IPublisherManager publisherManager;
    @EJB
    IRouteStatusManager routeStatusManager;
    @EJB
    IEPGExportGuideData epgExportGuideData;
    @EJB
    private IAlarmActivityLogManager applicationLogger;
    @EJB
    private IEPGPluginManager epgPluginManager;
    @Resource(mappedName="java:/epgmanager")
    DataSource datasource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void start() {
        try {
            logger.info((Object)" Starting Camel for EPG Manager...");
            ConfigProperties.init();
            if (this.isCamelRunning()) {
                logger.error((Object)" Attempt to restart Camel when its already running!");
                return;
            }
            if (this.camelContext == null) {
                logger.debug((Object)" Creating default camelContext ");
                this.camelContext = new DefaultCamelContext();
                this.camelContext.getShutdownStrategy().setShutdownNowOnTimeout(true);
                this.camelContext.getShutdownStrategy().setTimeout(5L);
                this.camelContext.getShutdownStrategy().setTimeUnit(TimeUnit.SECONDS);
                this.camelContext.removeComponent("ftp");
                this.camelContext.addComponent("ftp", (Component)new FtpComponentExt());
            }
            this.initializePropertyComponent();
            guideDataOutLocation = ConfigProperties.getFtpTempFolderFromDatabase();
            FileUtils.forceMkdir((File)new File(guideDataOutLocation));
            this.intializeEjbContext();
            this.addFtpToDatabaseRoute();
            this.camelContext.disableJMX();
            this.camelContext.start();
            this.startAllProviderRoutes();
            this.startAllPublisherRoutes();
        }
        catch (Exception e) {
            logger.fatal((Object)" Failed to start Camel. EPG Manager will not be able to function! ");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)(" Camel is " + this.getCamelContextStatus()));
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    private final void initializePropertyComponent() {
        PropertiesComponent pc = new PropertiesComponent();
        pc.setPropertiesResolver(new PropertiesResolver(){

            public Properties resolveProperties(CamelContext arg0, boolean ignoreMissingLocation, String ... uri) throws Exception {
                logger.info((Object)"Configuration Properties for EPG:");
                if (ConfigProperties.getConfigPropertyFile().size() == 0) {
                    logger.warn((Object)"Cannot find any configuration settings for EPG ");
                }
                logger.info((Object)("\n" + ConfigProperties.getDebugString()));
                return ConfigProperties.getConfigPropertyFile();
            }
        });
        pc.setLocation("");
        this.camelContext.addComponent("properties", (Component)pc);
    }

    private final void addFtpToDatabaseRoute() throws Exception {
        this.camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                String providerPluginUri = ConfigProperties.getPropertyValue(CamelManager.PROVIDER_PLUGIN_URI_KEY, CamelManager.PROVIDER_PLUGIN_URI);
                String publisherPluginUri = ConfigProperties.getPropertyValue(CamelManager.PUBLISHER_PLUGIN_URI_KEY, CamelManager.PUBLISHER_PLUGIN_URI);
                String exportToStgUri = ConfigProperties.getPropertyValue(CamelManager.EXPORT_TO_STG_URI_KEY, CamelManager.EXPORT_TO_STG_URI);
                PropertiesComponent pc = (PropertiesComponent)CamelManager.this.getCamelContext().getComponent("properties");
                String ftpToDatabaseUri = pc.parseUri(ConfigProperties.getPropertyValue(CamelManager.FTP_TO_DATABASE_URI_KEY, CamelManager.FTP_TO_DATABASE_URI));
                providerPluginUri = pc.parseUri(providerPluginUri);
                publisherPluginUri = pc.parseUri(publisherPluginUri);
                this.onException(EPGPluginException.class).handled(true).maximumRedeliveries(0).to(ConfigProperties.getPropertyValue(CamelManager.PLUGIN_ERROR_HANDLER_URI_KEY, CamelManager.PLUGIN_ERROR_HANDLER_URI));
                this.onException(PluginFrameworkException.class).handled(true).maximumRedeliveries(0).to(ConfigProperties.getPropertyValue(CamelManager.PLUGINFRAMEWORK_ERROR_HANDLER_URI_KEY, CamelManager.PLUGINFRAMEWORK_ERROR_HANDLER_URI));
                this.onException(IngestException.class).handled(true).maximumRedeliveries(0).to(ConfigProperties.getPropertyValue(CamelManager.INGEST_ERROR_HANDLER_URI_KEY, CamelManager.INGEST_ERROR_HANDLER_URI));
                this.onException(GenericFileOperationFailedException.class).handled(true).maximumRedeliveries(0).to(ConfigProperties.getPropertyValue(CamelManager.INGEST_ERROR_HANDLER_URI_KEY, CamelManager.INGEST_ERROR_HANDLER_URI));
                this.onException(ValidationException.class).handled(true).maximumRedeliveries(0).to(ConfigProperties.getPropertyValue(CamelManager.INGEST_ERROR_HANDLER_URI_KEY, CamelManager.SCHEMA_VALIDATION_HANDLER_URI));
                this.onException(MergeException.class).handled(true).maximumRedeliveries(0).to(ConfigProperties.getPropertyValue(CamelManager.MERGE_ERROR_HANDLER_URI_KEY, CamelManager.MERGE_ERROR_HANDLER_URI));
                this.onException(ExportToStagingException.class).handled(true).maximumRedeliveries(0).to(ConfigProperties.getPropertyValue(CamelManager.EXPORT_TO_STG_ERROR_HANDLER_URI_KEY, CamelManager.EXPORT_TO_STG_ERROR_HANDLER_URI));
                this.onException(ExportToXMLException.class).handled(true).maximumRedeliveries(0).to(ConfigProperties.getPropertyValue(CamelManager.EXPORT_TO_XML_ERROR_HANDLER_URI_KEY, CamelManager.EXPORT_TO_XML_ERROR_HANDLER_URI));
                this.onException(NormalizationRuleException.class).handled(true).maximumRedeliveries(0).to(CamelManager.NORMALIZATION_ERROR_HANDLER_URI);
                this.onException(ValidationRuleException.class).handled(true).maximumRedeliveries(0).to(CamelManager.VALIDATION_ERROR_HANDLER_URI);
                this.onException(Exception.class).handled(true).maximumRedeliveries(0).to(ConfigProperties.getPropertyValue(CamelManager.WORKFLOW_ERROR_HANDLER_URI_KEY, CamelManager.WORKFLOW_ERROR_HANDLER_URI));
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ChoiceDefinition)this.from(CamelManager.FTP_TO_DATABASE_DIRECT_ENDPOINT_URI).routeId("EPG_INGEST_ROUTE").startupOrder(0).threads(1, 1).choice().when((Predicate)this.simple("${in.header.IS_ETV} != true")).to(providerPluginUri)).end().filter(this.header(PluginAttribute.VALIDATE.toString()).isNotEqualTo((Object)Boolean.FALSE)).to("ejb:cms/AlarmActivityLogManager/local?method=logIngestInfo(*, 'Starting XSD validation of ETV format data')")).to(CamelManager.VALIDATION_URI)).to("ejb:cms/AlarmActivityLogManager/local?method=logIngestInfo(*, 'Finished XSD validation of ETV format data')")).end().filter(this.header(PluginAttribute.FTP_TO_DATABASE.toString()).isNotEqualTo((Object)Boolean.FALSE)).to("ejb:cms/AlarmActivityLogManager/local?method=logIngestInfo(*, 'Starting FTP to database')")).process((Processor)new OnDemanFtpProducer(CamelManager.this.camelContext, ftpToDatabaseUri))).to("ejb:cms/AlarmActivityLogManager/local?method=logIngestInfo(*, 'Finished FTP to database')")).end().filter(this.header(PluginAttribute.INGEST.toString()).isEqualTo((Object)Boolean.TRUE)).to(ConfigProperties.getPropertyValue(CamelManager.INGEST_URI_KEY, CamelManager.INGEST_URI))).end().filter(this.header(PluginAttribute.VALIDATIONRULE.toString()).isNotEqualTo((Object)Boolean.FALSE)).to(CamelManager.VALIDATION_RULES_FOR_PROVIDER_URI)).end().filter(this.header(PluginAttribute.NORMALIZATIONRULE.toString()).isNotEqualTo((Object)Boolean.FALSE)).to(CamelManager.NORMALIZATION_RULES_FOR_PROVIDER_URI)).end().filter(this.header(PluginAttribute.MERGE.toString()).isNotEqualTo((Object)Boolean.FALSE)).to(ConfigProperties.getPropertyValue(CamelManager.MERGE_URI_KEY, CamelManager.MERGE_URI))).end();
                ((ChoiceDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(CamelManager.FTP_FROM_DATABASE_DIRECT_ENDPOINT_URI).routeId("EPG_EXPORT_ROUTE").startupOrder(1).to(exportToStgUri)).to(CamelManager.NORMALIZATION_RULES_FOR_PUBLISHER_URI)).to(ConfigProperties.getPropertyValue(CamelManager.EXPORT_TO_XML_URI_KEY, CamelManager.EXPORT_TO_XML_URI))).choice().when((Predicate)this.simple("${in.header.IS_ETV} != true")).to(publisherPluginUri)).end();
            }
        });
    }

    private final void intializeEjbContext() {
        try {
            logger.debug((Object)" Intializing Ejb context for Camel");
            EjbComponent ejb = (EjbComponent)this.camelContext.getComponent("ejb", EjbComponent.class);
            InitialContext context = new InitialContext();
            ejb.setContext((Context)context);
        }
        catch (Exception e) {
            logger.error((Object)(" Failed to initialize Ejb Context for Camel " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            logger.info((Object)" Stopping Camel for EPG Manager...");
            if (this.camelContext == null) {
                logger.error((Object)"Camelcontext is null");
            } else if (this.camelContext.getStatus().equals((Object)ServiceStatus.Stopped)) {
                logger.error((Object)"Camelcontext is not running");
            } else {
                List routes = this.camelContext.getRoutes();
                for (Route route : routes) {
                    this.camelContext.stopRoute(route.getId(), 5L, TimeUnit.SECONDS, false);
                }
                this.interruptedRunningPluginJob();
                this.camelContext.stop();
                this.camelContext = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            logger.info((Object)(" Camel is " + this.getCamelContextStatus()));
        }
    }

    private void interruptedRunningPluginJob() {
        List routes = this.camelContext.getRoutes();
        if (routes == null || routes.size() == 0) {
            return;
        }
        for (Route route : routes) {
            if (!this.isRouteRunning(route.getId())) continue;
            this.epgPluginManager.interruptRunningJob(route.getId());
        }
    }

    public boolean isCamelRunning() {
        return this.getCamelContextStatus().equals((Object)ServiceStatus.Started) || this.getCamelContextStatus().equals((Object)ServiceStatus.Starting);
    }

    public void createProviderRoute(Provider p) {
        try {
            if (!p.isActive()) {
                logger.info((Object)(" Provider " + p.getName() + " is not active..skipping route creation"));
                return;
            }
            ProviderRouteBuilder providerRouteBuilder = new ProviderRouteBuilder(p);
            this.camelContext.addRoutes((RoutesBuilder)providerRouteBuilder);
            logger.trace((Object)(" Created route for provider " + p.getName()));
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create route for provider " + p.getName() + " " + e.getMessage()));
        }
    }

    public void removeProviderRoute(Provider p) {
        try {
            boolean isRunning;
            String routeId = ProviderRouteBuilder.getRouteName(p);
            if (this.camelContext.getRoute(routeId) == null) {
                logger.info((Object)(" try to remove a route, but  Route for provider " + p.getName() + " not found."));
                return;
            }
            boolean bl = isRunning = this.isRouteRunning(routeId) || this.camelContext.getRouteStatus(routeId).isStarted();
            if (isRunning) {
                this.stopRoute(routeId, 2, false);
            }
            this.cleanProviderWorkFolder(p);
            if (!this.camelContext.removeRoute(routeId)) {
                logger.info((Object)("Unable to remove route for " + p));
            }
            if (!p.isActive()) {
                this.routeStatusManager.removeRouteById(ProviderRouteBuilder.getRouteName(p));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to remove route for " + p + " " + e.getMessage()), (Throwable)e);
        }
    }

    private void cleanProviderWorkFolder(Provider p) throws IOException {
        String folder = ConfigProperties.getWorkFolderForProvider(p);
        File workFolder = new File(folder);
        if (workFolder.exists()) {
            FileUtils.cleanDirectory((File)workFolder);
        }
    }

    private final ServiceStatus getCamelContextStatus() {
        if (this.camelContext == null) {
            return ServiceStatus.Stopped;
        }
        return this.camelContext.getStatus();
    }

    private void startAllProviderRoutes() {
        logger.debug((Object)"starting all Provider routes");
        List providers = this.providerManager.getProviders();
        for (Provider provider : providers) {
            try {
                this.createProviderRoute(provider);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to start route for provider: " + provider.getName() + " due to " + e.getMessage()));
            }
        }
    }

    public void createPublisherRoute(Publisher p) {
        try {
            if (!p.isActive()) {
                logger.info((Object)(" Publisher " + p.getName() + " is not active..skipping route creation"));
                return;
            }
            PublisherRouteBuilder publisherRouteBuilder = new PublisherRouteBuilder(p);
            this.camelContext.addRoutes((RoutesBuilder)publisherRouteBuilder);
            logger.trace((Object)(" Created route for publisher " + p.getName()));
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create route for publisher " + p.getName() + ", due to: " + e.getMessage()));
        }
    }

    public void removePublisherRoute(Publisher p) {
        try {
            String routeId = PublisherRouteBuilder.getRouteName(p);
            if (this.camelContext.getRoute(routeId) == null) {
                logger.info((Object)("try to remove route, but Route for publisher " + p.getName() + " not found."));
                return;
            }
            this.epgExportGuideData.stopExportingGuideData(p.getName());
            this.forceCloseRunningFtpProducer(p);
            if (!this.stopRoute(routeId, 3, false)) {
                logger.error((Object)("Unable to stop route for " + p));
            }
            if (!this.camelContext.removeRoute(routeId)) {
                logger.info((Object)("Unable to remove route for " + p));
            }
            if (!p.isActive()) {
                this.routeStatusManager.removeRouteById(PublisherRouteBuilder.getRouteName(p));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to remove route for " + p + " , due to: " + e.getMessage()));
        }
    }

    private void startAllPublisherRoutes() {
        logger.debug((Object)"starting all Publisher routes");
        List publishers = this.publisherManager.getPublishers();
        for (Publisher publisher : publishers) {
            try {
                this.createPublisherRoute(publisher);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to start route for provider: " + publisher.getName() + ",due to:" + e.getMessage()));
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void executeLoad(Exchange exchange) {
        Connection connection = null;
        Statement proc = null;
        try {
            Provider provider = this.providerManager.getProvider(ProviderRouteBuilder.getProviderId(exchange));
            connection = this.datasource.getConnection();
            logger.info((Object)("Executing EPGMERGE.LOAD() for " + provider.toString()));
            auditLogger.info((Object)(" Loading staging tables for " + provider.toString()));
            proc = connection.prepareCall("BEGIN EPGMERGE.LOAD(:v_filename, :provider_id); END;");
            proc.setString("v_filename", "Guidedata.xml");
            proc.setString("provider_id", String.valueOf(provider.getId()));
            proc.execute();
        }
        catch (Exception e) {
            logger.error((Object)("EPGMERGE.LOAD() failed " + e.getMessage()));
            String errMsg = "Failed to load EPG data to staging tables";
            auditLogger.error((Object)errMsg);
            throw new IngestException(errMsg);
        }
        finally {
            block12: {
                try {
                    if (proc != null && !proc.isClosed()) {
                        proc.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqlEx) {
                    if (!logger.isDebugEnabled()) break block12;
                    logger.error((Object)"executeLoad(Exchange) - sql exception found while closing jdbc statement/connection object", (Throwable)sqlEx);
                }
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void executeMerge(Exchange exchange) {
        Connection connection = null;
        Statement proc = null;
        Map<Object, Object> configProviderProperties = new HashMap();
        try {
            Provider provider = this.providerManager.getProvider(ProviderRouteBuilder.getProviderId(exchange));
            logger.info((Object)"Executing EPGMERGE.MERGE()");
            auditLogger.info((Object)(" Merging to production for " + provider.toString()));
            connection = this.datasource.getConnection();
            proc = connection.prepareCall("BEGIN EPGMERGE.MERGE(:provider_id, :overwriteWithEmpty, :truncateProduction, :daysBehindNowToKeep); END;");
            proc.setString("provider_id", String.valueOf(provider.getId()));
            configProviderProperties = this.getConfigProperties(UI_CONFIGURATION_PROPERTIES_SETTING_PATH);
            String overwriteWithEmptyFlagStr = (String)configProviderProperties.get("overwriteWithEmpty");
            boolean overwriteWithEmptyFlag = !"false".equalsIgnoreCase(overwriteWithEmptyFlagStr);
            proc.setString("overwriteWithEmpty", overwriteWithEmptyFlag ? "Y" : "N");
            String truncateProductionFlagTemp = (String)configProviderProperties.get("truncateProduction");
            boolean truncateProductionFlag = !"false".equalsIgnoreCase(truncateProductionFlagTemp);
            proc.setString("truncateProduction", truncateProductionFlag ? "Y" : "N");
            String historyTemp = (String)configProviderProperties.get("history");
            int history = 0;
            if (historyTemp != null && !historyTemp.isEmpty()) {
                history = Integer.parseInt(historyTemp);
            }
            proc.setInt("daysBehindNowToKeep", history);
            proc.execute();
        }
        catch (Exception e) {
            logger.error((Object)("EPGMERGE.MERGE() failed " + e.getMessage()));
            String errMsg = "Failed to merge EPG data to production tables";
            auditLogger.error((Object)errMsg);
            throw new MergeException(errMsg);
        }
        finally {
            block13: {
                try {
                    if (proc != null && !proc.isClosed()) {
                        proc.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqlEx) {
                    if (!logger.isDebugEnabled()) break block13;
                    logger.error((Object)"executeMerge(Exchange) - sql exception found while closing jdbc statement/connection object", (Throwable)sqlEx);
                }
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void executeExportToStaging(Exchange exchange) throws ExportToStagingException {
        Connection connection = null;
        Statement proc = null;
        Map<Object, Object> configPublisherProperties = new HashMap();
        try {
            String daysInFutureStr;
            logger.info((Object)"Executing EPGEXPORT.EXPORTEPGDATA()");
            Publisher publisher = this.publisherManager.getPublisher(PublisherRouteBuilder.getPublisherId(exchange));
            auditLogger.info((Object)(" Exporting to staging for " + publisher.toString()));
            Set publishers = publisher.getStations();
            StringBuilder commaSeperateList = new StringBuilder();
            String sep = "";
            for (String str : publishers) {
                commaSeperateList.append(sep);
                commaSeperateList.append("'" + str + "'");
                sep = ",";
            }
            connection = this.datasource.getConnection();
            proc = connection.prepareCall("BEGIN EPGEXPORT.EXPORTEPGDATA(:publisher_id, :lowerDate, :upperDate, :channelIds); END;");
            proc.setLong("publisher_id", publisher.getId());
            int daysInPast = 0;
            int daysInFuture = 0;
            configPublisherProperties = this.getConfigProperties(UI_CONFIGURATION_PROPERTIES_SETTING_PATH);
            String daysInPastStr = (String)configPublisherProperties.get("daysInPast");
            if (daysInPastStr != null && !daysInPastStr.isEmpty()) {
                daysInPast = Integer.parseInt(daysInPastStr);
            }
            if ((daysInFutureStr = (String)configPublisherProperties.get("daysInFuture")) != null && !daysInFutureStr.isEmpty()) {
                daysInFuture = Integer.parseInt(daysInFutureStr);
            }
            String daysInPastTime = CalendarUtil.dayInPastAsUTC(daysInPast);
            String daysInFutureTime = CalendarUtil.dayInFutureAsUTC(daysInFuture);
            proc.setString("lowerDate", daysInPastTime);
            proc.setString("upperDate", daysInFutureTime);
            proc.setString("channelIds", commaSeperateList.toString());
            sep = ",";
            logger.debug((Object)("Calling EPGEXPORT.EXPORTEPGDATA(" + publisher.getId() + sep + daysInPastTime + sep + daysInFutureTime + sep + commaSeperateList.toString() + ") for Publisher: " + publisher.toString()));
            proc.execute();
        }
        catch (Exception e) {
            if (e instanceof SQLException && ((SQLException)e).getErrorCode() == 20130 && logger.isDebugEnabled()) {
                logger.debug((Object)("EPGEXPORT.EXPORTEPGDATA() reported " + e.getMessage()));
            } else {
                logger.error((Object)("EPGEXPORT.EXPORTEPGDATA() failed " + e.getMessage() + " " + e.getCause()));
            }
            String errMsg = "Failed to export EPG data to staging tables";
            auditLogger.error((Object)errMsg);
            throw new ExportToStagingException(errMsg);
        }
        finally {
            block17: {
                try {
                    if (proc != null && !proc.isClosed()) {
                        proc.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqlEx) {
                    if (!logger.isDebugEnabled()) break block17;
                    logger.error((Object)"executeExportToStaging(Exchange) - sql exception found while closing jdbc statement/connection object", (Throwable)sqlEx);
                }
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void executeExportToXML(Exchange exchange) throws ExportToXMLException {
        try {
            Publisher publisher = this.publisherManager.getPublisher(PublisherRouteBuilder.getPublisherId(exchange));
            Validate.notNull((Object)publisher, (String)"Cannot find the publisher");
            String etvFormat = publisher.getEpgFormat().isETV() ? "ETV_18" : this.findETVFormatByPlugin(publisher);
            logger.info((Object)"Executing EpgExportGuideData.exportGuideData() - create XML");
            auditLogger.info((Object)("Exporting to XML for " + publisher.toString()));
            this.epgExportGuideData.exportGuideData(publisher.getName(), ExportETVTypeEnum.valueOf(etvFormat), guideDataOutLocation);
            exchange.getIn().setBody((Object)new File(ConfigProperties.getExportedETVFileName()));
        }
        catch (Exception e) {
            logger.error((Object)("Executing EpgExportGuideData.exportGuideData() - create XML failed: " + e.getMessage()), (Throwable)e);
            String errMsg = "Failed to export EPG data to XML";
            auditLogger.error((Object)errMsg);
            ExportToXMLException ex = e instanceof ExportToXMLException ? (ExportToXMLException)e : new ExportToXMLException(errMsg, (Throwable)e);
            throw ex;
        }
    }

    private String findETVFormatByPlugin(Publisher publisher) {
        IEPGManagerPublisher epgPublisherManager = PluginFactory.getPublisherPlugin(new File(publisher.getEpgFormat().getJarName()));
        Validate.notNull((Object)epgPublisherManager, (String)("Cannot find the specified plugin in PluginFactor for " + publisher.getEpgFormat()));
        String etvFormat = EPGPluginManager.getPluginETVFormat((IEPGManagerPlugin)epgPublisherManager);
        Validate.notNull((Object)etvFormat, (String)("Cannot find the specified ETV format in PluginFactor for " + publisher.getEpgFormat()));
        boolean isNotETV20 = !"ETV_20".equalsIgnoreCase(etvFormat) && !"ETV_18".equalsIgnoreCase(etvFormat) && !"ETV_MIX".equalsIgnoreCase(etvFormat);
        etvFormat = isNotETV20 ? "ETV_20" : etvFormat.toUpperCase();
        return etvFormat;
    }

    public String getCamelStatistics() {
        try {
            StringBuilder response = new StringBuilder();
            for (RouteStatus routeStatus : this.routeStatusManager.getRoutesStatus()) {
                response.append(routeStatus).append("\n");
            }
            return response.toString();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return " Unable to get list of route status " + e.getMessage();
        }
    }

    public Map<String, String> getConfigProperties(String configServerProperties) {
        HashMap<String, String> configProperties = new HashMap();
        try {
            IConfigurationService configService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
            configProperties = configService.getProperties(configServerProperties);
            return configProperties;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            logger.error((Object)"Error in retrieving EPG manager properties");
            return configProperties;
        }
    }

    public boolean isRouteRunning(String routeId) {
        if (StringUtils.isBlank((String)routeId)) {
            return false;
        }
        return this.camelContext.getInflightRepository().size(routeId) > 0;
    }

    public boolean isPublisherRouteRunning(Publisher publisher) {
        return this.isRouteRunning(PublisherRouteBuilder.getRouteName(publisher));
    }

    public boolean isProviderRouteRunning(Provider provider) {
        return this.isRouteRunning(ProviderRouteBuilder.getRouteName(provider));
    }

    public boolean stopRoute(String routeName, int timeout, boolean gracefulclose) {
        boolean success = false;
        logger.info((Object)("The previous rout job is not finished, try to stop  it [" + routeName + "]"));
        String alarmMsg = "Force stop the running route for  " + routeName;
        this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.PLUGIN, alarmMsg);
        try {
            this.forceCloseRunningFtpConsumer(routeName);
            success = this.camelContext.stopRoute(routeName, (long)timeout, TimeUnit.SECONDS, gracefulclose);
            this.epgPluginManager.interruptRunningJob(routeName);
        }
        catch (Exception e) {
            String error = "Fail to stop the route[" + routeName + "], the new route might be delayed " + "untill the old job is done";
            logger.error((Object)error, (Throwable)e);
        }
        return success;
    }

    private void forceCloseRunningFtpConsumer(String routeName) {
        Consumer service = this.camelContext.getRoute(routeName).getConsumer();
        if (service == null || !(service instanceof FtpConsumerExt)) {
            return;
        }
        FtpConsumerExt ftpConsumer = (FtpConsumerExt)service;
        String alarmMsg = "Force stop the running ftp connection for  " + routeName;
        this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.PLUGIN, alarmMsg);
        ftpConsumer.forceDisconnect();
    }

    private void forceCloseRunningFtpProducer(Publisher p) {
        Endpoint e = this.camelContext.getEndpoint(p.getEndPointUri());
        if (e == null || !(e instanceof FtpEndpointExt)) {
            return;
        }
        FtpEndpointExt ep = (FtpEndpointExt)e;
        String routeName = PublisherRouteBuilder.getRouteName(p);
        boolean flag = ep.stopFtpOperations(routeName);
        if (flag) {
            String alarmMsg = "Force stop the running ftp connection for  " + routeName;
            this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.PLUGIN, alarmMsg);
        }
    }
}

