/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.service;

import com.ericsson.cms.epgmgmt.service.IRouteStatusManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.log4j.Logger;

public class CustomPollingConsumerPollStrategy
implements PollingConsumerPollStrategy {
    private static final Logger logger = Logger.getLogger(CustomPollingConsumerPollStrategy.class);

    public boolean begin(Consumer consumer, Endpoint endpoint) {
        logger.trace((Object)("Starting to poll endpoint -" + endpoint.getEndpointUri()));
        return true;
    }

    public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
        logger.trace((Object)("Completed poll to endpoint  " + endpoint.getEndpointUri()));
    }

    public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) throws Exception {
        logger.debug((Object)("Failed to poll endpoint " + endpoint.getEndpointUri() + " No of attempts -" + retryCounter));
        logger.error((Object)cause.getMessage());
        if (retryCounter < 2) {
            logger.debug((Object)" Will retry ");
            return true;
        }
        String uri = ((Object)endpoint.getEndpointUri().subSequence(0, endpoint.getEndpointUri().indexOf("?"))).toString();
        logger.debug((Object)(" Tried " + retryCounter + " times for URI " + uri));
        return false;
    }

    protected void createRunningRouteStatusEntry(String routeId, String remark) throws Exception {
        IRouteStatusManager routeStatusManager = (IRouteStatusManager)InjectionUtil.injectInstance((String)"cms/RouteStatusManager/local", IRouteStatusManager.class);
        routeStatusManager.createOrUpdateRouteStatusToRunning(routeId, remark);
    }

    protected void createStoppedRouteStatusEntry(String routeId, String remark) throws Exception {
        IRouteStatusManager routeStatusManager = (IRouteStatusManager)InjectionUtil.injectInstance((String)"cms/RouteStatusManager/local", IRouteStatusManager.class);
        routeStatusManager.createOrUpdateRouteStatusToStopped(routeId, remark);
    }
}

