/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.service;

import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.enumeration.RouteTypeEnum;
import com.ericsson.cms.epgmgmt.exception.IngestException;
import com.ericsson.cms.epgmgmt.service.CustomPollingConsumerPollStrategy;
import com.ericsson.cms.epgmgmt.service.ProviderRouteBuilder;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ProviderPollStrategy
extends CustomPollingConsumerPollStrategy {
    private final Provider provider;
    private static final Logger logger = Logger.getLogger(ProviderPollStrategy.class);
    private String userDefinedIncludePattern;

    public ProviderPollStrategy(Provider provider) {
        this.provider = provider;
    }

    @Override
    public boolean begin(Consumer consumer, Endpoint endpoint) {
        if (!super.begin(consumer, endpoint)) {
            return false;
        }
        try {
            this.createRunningRouteStatusEntry(ProviderRouteBuilder.getRouteName(this.provider), " About to consume files from " + endpoint.getEndpointUri());
        }
        catch (Exception e) {
            logger.error((Object)(" Unable to create/update Route Status entry for " + this.provider.toString()));
            logger.error((Object)" Route might start off at application restart!");
        }
        if (endpoint instanceof GenericFileEndpoint) {
            String includePattern;
            this.userDefinedIncludePattern = includePattern = ((GenericFileEndpoint)endpoint).getInclude();
            if (!StringUtils.isBlank((String)includePattern)) {
                Exchange dummy = endpoint.createExchange();
                Expression expression = ExpressionBuilder.simpleExpression((String)includePattern);
                String newIncludePattern = (String)expression.evaluate(dummy, String.class);
                logger.trace((Object)(" Changing include pattern to " + newIncludePattern + " from " + this.userDefinedIncludePattern));
                ((GenericFileEndpoint)endpoint).setInclude(newIncludePattern);
            }
        }
        return true;
    }

    @Override
    public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
        super.commit(consumer, endpoint, polledMessages);
        if (polledMessages == 0) {
            try {
                this.createStoppedRouteStatusEntry(ProviderRouteBuilder.getRouteName(this.provider), " No files found Or another consumer already in progress for " + endpoint.getEndpointUri());
            }
            catch (Exception e) {
                logger.error((Object)(" Unable to update Route Status entry to Stopped for " + this.provider.toString()));
            }
        }
        this.restoreIncludePattern(endpoint);
    }

    @Override
    public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) throws Exception {
        this.restoreIncludePattern(endpoint);
        if (!super.rollback(consumer, endpoint, retryCounter, cause)) {
            this.generateCamelException(consumer, endpoint, cause);
            try {
                String remark = " Failed to consumer files from " + endpoint.getEndpointUri();
                if (cause != null) {
                    remark = remark + cause.getMessage();
                }
                this.createStoppedRouteStatusEntry(ProviderRouteBuilder.getRouteName(this.provider), remark);
            }
            catch (Exception e) {
                logger.error((Object)(" Unable to update Route Status entry to Stopped for " + this.provider.toString()));
            }
            return false;
        }
        return true;
    }

    private void restoreIncludePattern(Endpoint endpoint) {
        if (endpoint instanceof GenericFileEndpoint) {
            logger.trace((Object)(" Restoring include pattern from " + ((GenericFileEndpoint)endpoint).getInclude() + " to " + this.userDefinedIncludePattern));
            ((GenericFileEndpoint)endpoint).setInclude(this.userDefinedIncludePattern);
        }
    }

    protected void generateCamelException(Consumer consumer, final Endpoint endpoint, final Exception cause) {
        ProducerTemplate template = consumer.getEndpoint().getCamelContext().createProducerTemplate(1);
        template.send("direct:ftpToDatabase", new Processor(){

            public void process(Exchange exchange) throws Exception {
                IngestException ingestException = new IngestException(cause.getMessage() + " for URI " + endpoint.getEndpointUri());
                exchange.setException((Throwable)ingestException);
                exchange.getIn().setHeader("ROUTE_TYPE", (Object)RouteTypeEnum.PROVIDER);
                exchange.getIn().setHeader("PROVIDER_ID", (Object)ProviderPollStrategy.this.provider.getId());
            }
        });
    }
}

