/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.service;

import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.enumeration.EndpointSchemeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.RouteTypeEnum;
import com.ericsson.cms.epgmgmt.entitymanager.ProviderRoutePolicy;
import com.ericsson.cms.epgmgmt.plugin.EPGPluginManager;
import com.ericsson.cms.epgmgmt.plugin.PluginFactory;
import com.ericsson.cms.epgmgmt.service.BaseRouteBuilder;
import com.ericsson.cms.epgmgmt.service.Delete;
import com.ericsson.cms.epgmgmt.service.ProviderPollStrategy;
import com.ericsson.cms.epgmgmt.util.ConfigProperties;
import com.ericsson.cms.epgmgmt.util.RegexUtil;
import com.ericsson.epgmgr.plugin.IEPGManagerPlugin;
import com.ericsson.epgmgr.plugin.IEPGManagerProvider;
import com.ericsson.epgmgr.plugin.PluginAttribute;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ProviderRouteBuilder
extends BaseRouteBuilder {
    final Provider provider;
    public static final String PROVIDER_ID = "PROVIDER_ID";
    private static final Logger logger = Logger.getLogger(ProviderRouteBuilder.class);

    public ProviderRouteBuilder(Provider p) throws URISyntaxException {
        this.provider = p;
    }

    public void configure() throws Exception {
        boolean isETV = this.provider.getEpgFormat().isETV();
        String tmpFolderName = ConfigProperties.getWorkFolderForProvider(this.provider);
        if (isETV) {
            ((RouteDefinition)((RouteDefinition)this.from(this.createEndpoint()).routePolicy(new RoutePolicy[]{new ProviderRoutePolicy()}).process(new Processor(){

                public void process(Exchange exchange) throws Exception {
                    ProviderRouteBuilder.this.setHeaders(exchange);
                }
            })).to("direct:ftpToDatabase")).routeId(ProviderRouteBuilder.getRouteName(this.provider));
        } else {
            ((AggregateDefinition)((AggregateDefinition)((AggregateDefinition)((RouteDefinition)this.from(this.createEndpoint()).routePolicy(new RoutePolicy[]{new ProviderRoutePolicy()}).to("file://" + tmpFolderName)).aggregate((Expression)this.constant(true)).completionFromBatchConsumer().groupExchanges().process((Processor)new Delete(tmpFolderName))).process(new Processor(){

                public void process(Exchange exchange) throws Exception {
                    ProviderRouteBuilder.this.setHeaders(exchange);
                }
            })).to("direct:ftpToDatabase")).routeId(ProviderRouteBuilder.getRouteName(this.provider));
        }
    }

    private void setHeaders(Exchange exchange) throws IOException {
        Message message = exchange.getIn();
        message.setHeader("ROUTE_TYPE", (Object)RouteTypeEnum.PROVIDER);
        message.setHeader(PROVIDER_ID, (Object)this.provider.getId());
        boolean isETV = this.provider.getEpgFormat().isETV();
        message.setHeader("IS_ETV", (Object)isETV);
        if (isETV) {
            message.setHeader(PluginAttribute.VALIDATE.toString(), (Object)true);
            message.setHeader(PluginAttribute.FTP_TO_DATABASE.toString(), (Object)true);
            message.setHeader(PluginAttribute.INGEST.toString(), (Object)true);
            message.setHeader(PluginAttribute.VALIDATIONRULE.toString(), (Object)true);
            message.setHeader(PluginAttribute.NORMALIZATIONRULE.toString(), (Object)true);
            message.setHeader(PluginAttribute.MERGE.toString(), (Object)true);
        } else {
            IEPGManagerProvider plugin = PluginFactory.getProviderPlugin(this.provider);
            message.setHeader(PluginAttribute.VALIDATE.toString(), (Object)EPGPluginManager.validateForPlugin((IEPGManagerPlugin)plugin));
            message.setHeader(PluginAttribute.FTP_TO_DATABASE.toString(), (Object)EPGPluginManager.ftpToDatabasetForPlugin((IEPGManagerPlugin)plugin));
            message.setHeader(PluginAttribute.INGEST.toString(), (Object)EPGPluginManager.ingestForPlugin((IEPGManagerPlugin)plugin));
            message.setHeader(PluginAttribute.VALIDATIONRULE.toString(), (Object)EPGPluginManager.validationRuleForPlugin((IEPGManagerPlugin)plugin));
            message.setHeader(PluginAttribute.NORMALIZATIONRULE.toString(), (Object)EPGPluginManager.nomalizationRuleForPlugin((IEPGManagerPlugin)plugin));
            message.setHeader(PluginAttribute.MERGE.toString(), (Object)EPGPluginManager.mergeForPlugin((IEPGManagerPlugin)plugin));
        }
    }

    private Endpoint createEndpoint() throws Exception {
        String providerEndpointUri = this.providerToEndPointUri();
        Endpoint endpoint = super.getContext().getEndpoint(providerEndpointUri);
        if (endpoint instanceof ScheduledPollEndpoint) {
            HashMap<String, ProviderPollStrategy> consumerProperties = ((ScheduledPollEndpoint)endpoint).getConsumerProperties();
            if (consumerProperties == null) {
                consumerProperties = new HashMap<String, ProviderPollStrategy>();
                ((ScheduledPollEndpoint)endpoint).setConsumerProperties(consumerProperties);
            }
            consumerProperties.put("pollStrategy", new ProviderPollStrategy(this.provider));
        }
        return endpoint;
    }

    public String providerToEndPointUri() throws Exception {
        com.ericsson.cms.epgmgmt.entity.Endpoint endPoint = this.provider.getRetrievalDetails();
        EndpointSchemeEnum endPointScheme = endPoint.getEndpointTypeDetails().getName();
        String providerEndpointUri = null;
        switch (endPointScheme) {
            case ftp: {
                StringBuilder filePath = new StringBuilder("/");
                if (endPoint.getFolder() != null) {
                    filePath.append(endPoint.getFolder());
                }
                providerEndpointUri = new URI(endPointScheme.name(), endPoint.getUserName(), endPoint.getServerIp(), (int)endPoint.getPort(), filePath.toString(), this.getOptionsForEndpoint(endPoint).toString(), null).toString();
                break;
            }
            case file: {
                providerEndpointUri = new URI(endPointScheme.name(), null, endPoint.getFolder(), -1, null, this.getOptionsForEndpoint(endPoint), null).toString();
                break;
            }
            default: {
                throw new Exception("Endpoint of type - " + endPointScheme + " not supported");
            }
        }
        return providerEndpointUri;
    }

    public static String getRouteName(Provider provider) {
        return "Provider_" + String.valueOf(provider.getId());
    }

    private String getOptionsForEndpoint(com.ericsson.cms.epgmgmt.entity.Endpoint endPoint) {
        StringBuilder uriOptions = new StringBuilder();
        long providerFrequency = this.provider.getFrequency() > 0L ? this.provider.getFrequency() * 1000L : 60000L;
        long providerLastRuntime = this.getLastRuntime(ProviderRouteBuilder.getRouteName(this.provider));
        uriOptions.append("consumer.delay=");
        uriOptions.append(providerFrequency);
        long initialDelay = ProviderRouteBuilder.calculateInitialDelay(providerLastRuntime, providerFrequency, ProviderRouteBuilder.getRouteName(this.provider));
        uriOptions.append("&initialDelay=" + initialDelay);
        if (endPoint.getEndpointTypeDetails().getName().equals((Object)EndpointSchemeEnum.ftp)) {
            String tempFolder;
            uriOptions.append("&throwExceptionOnConnectFailed=true");
            uriOptions.append("&maximumReconnectAttempts=0");
            uriOptions.append("&disconnect=true&noop=false");
            uriOptions.append("&binary=true");
            uriOptions.append("&delete=false");
            if (endPoint.getPassword() != null) {
                uriOptions.append("&password=");
                uriOptions.append(endPoint.getPassword());
            }
            if (StringUtils.isNotBlank((String)(tempFolder = ConfigProperties.getFtpTempFolderForProvider()))) {
                logger.trace((Object)(" Setting temp folder for FTP Consumer to " + tempFolder));
                uriOptions.append("&localWorkDirectory=" + tempFolder);
            }
        }
        if (endPoint.getFileName() != null) {
            uriOptions.append("&recursive=true");
            if (endPoint.getFileName().contains("*")) {
                String includeRegex = RegexUtil.toJavaStyleRegex(endPoint.getFileName());
                uriOptions.append("&include=" + includeRegex);
            } else {
                uriOptions.append("&fileName=" + endPoint.getFileName());
            }
            if (!StringUtils.isBlank((String)endPoint.getDoneFile())) {
                uriOptions.append("&doneFileName=" + endPoint.getDoneFile());
            }
            if (endPoint.getEndpointTypeDetails().getName().equals((Object)EndpointSchemeEnum.ftp)) {
                uriOptions.append("&separator=UNIX");
            }
        }
        return uriOptions.toString();
    }

    public static long getProviderId(Exchange exchange) {
        return (Long)exchange.getIn().getHeader(PROVIDER_ID, (Object)-1);
    }
}

