/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.service;

import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.enumeration.RouteTypeEnum;
import com.ericsson.cms.epgmgmt.exception.IngestException;
import com.ericsson.cms.epgmgmt.service.CustomPollingConsumerPollStrategy;
import com.ericsson.cms.epgmgmt.service.IPublisherManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;

public class PublisherPollStrategy
extends CustomPollingConsumerPollStrategy {
    private final Publisher publisher;

    public PublisherPollStrategy(Publisher publisher) {
        this.publisher = publisher;
    }

    public PublisherPollStrategy(long publisherId) {
        IPublisherManager publisherManager = (IPublisherManager)InjectionUtil.injectInstance((String)"cms/PublisherManager/local", IPublisherManager.class);
        this.publisher = publisherManager.getPublisher(publisherId);
    }

    @Override
    public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) throws Exception {
        if (!super.rollback(consumer, endpoint, retryCounter, cause)) {
            this.generateCamelException(consumer, endpoint, cause);
            return false;
        }
        return true;
    }

    protected void generateCamelException(Consumer consumer, final Endpoint endpoint, final Exception cause) {
        ProducerTemplate template = consumer.getEndpoint().getCamelContext().createProducerTemplate(1);
        template.send("direct:ftpToDatabase", new Processor(){

            public void process(Exchange exchange) throws Exception {
                IngestException ingestException = new IngestException(cause.getMessage() + " for URI " + endpoint.getEndpointUri());
                exchange.setException((Throwable)ingestException);
                exchange.getIn().setHeader("ROUTE_TYPE", (Object)RouteTypeEnum.PUBLISHER);
                exchange.getIn().setHeader("PUBLISHER_ID", (Object)PublisherPollStrategy.this.publisher.getId());
            }
        });
    }
}

