/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.service;

import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.enumeration.EndpointSchemeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.RouteTypeEnum;
import com.ericsson.cms.epgmgmt.entitymanager.PublisherRoutePolicy;
import com.ericsson.cms.epgmgmt.service.BaseRouteBuilder;
import com.ericsson.cms.epgmgmt.service.PublisherPollStrategy;
import com.ericsson.cms.epgmgmt.util.ConfigProperties;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;

public final class PublisherRouteBuilder
extends BaseRouteBuilder {
    public static final String TIMER_FOR_PUBLISHERS = "TIMER_FOR_PUBLISHER";
    private final Publisher publisher;
    public static final String PUBLISHER_ID = "PUBLISHER_ID";

    public PublisherRouteBuilder(Publisher publisher) {
        this.publisher = publisher;
    }

    public void configure() throws Exception {
        boolean isETV = this.publisher.getEpgFormat().isETV();
        String publisherRouteId = PublisherRouteBuilder.getRouteName(this.publisher);
        long frequency = this.publisher.getFrequency() > 0L ? this.publisher.getFrequency() * 1000L : 60000L;
        long delay = PublisherRouteBuilder.calculateInitialDelay(this.getLastRuntime(publisherRouteId), frequency, publisherRouteId);
        this.onException(GenericFileOperationFailedException.class).handled(true).maximumRedeliveries(0).to(ConfigProperties.getPropertyValue("INGEST_ERROR_HANDLER_URI", "ejb:cms/AlarmActivityLogManager/local?method=createIngestErrorLog(*)"));
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("timer:TIMER_FOR_PUBLISHER?daemon=true&fixedRate=true&period=" + frequency + "&delay=" + delay).routePolicy(new RoutePolicy[]{new PublisherRoutePolicy()}).setHeader("ROUTE_TYPE", (Expression)this.simple(RouteTypeEnum.PUBLISHER.toString(), RouteTypeEnum.class))).setHeader(PUBLISHER_ID, (Expression)this.simple(Long.toString(this.publisher.getId()), Long.class))).setHeader("IS_ETV", (Expression)this.simple(Boolean.toString(isETV), Boolean.class))).routeId(publisherRouteId).to("ejb:cms/AlarmActivityLogManager/local?method=logSystemInfo(*, 'Starting EPG publish')")).to("direct:ftpFromDatabase")).to(this.createEndpoint())).to("ejb:cms/AlarmActivityLogManager/local?method=logSystemInfo(*, 'Finished EPG publish')");
    }

    public static String getRouteName(Publisher publisher) {
        return "Publisher_" + String.valueOf(publisher.getId());
    }

    private Endpoint createEndpoint() throws Exception {
        String publisherEndpoint = this.publisherToEndPointUri();
        Endpoint endpoint = super.getContext().getEndpoint(publisherEndpoint);
        if (endpoint instanceof ScheduledPollEndpoint) {
            HashMap<String, PublisherPollStrategy> consumerProperties = ((ScheduledPollEndpoint)endpoint).getConsumerProperties();
            if (consumerProperties == null) {
                consumerProperties = new HashMap<String, PublisherPollStrategy>();
                ((ScheduledPollEndpoint)endpoint).setConsumerProperties(consumerProperties);
            }
            consumerProperties.put("pollStrategy", new PublisherPollStrategy(this.publisher));
        }
        return endpoint;
    }

    public String publisherToEndPointUri() throws Exception {
        com.ericsson.cms.epgmgmt.entity.Endpoint endPoint = this.publisher.getPublishDetails();
        EndpointSchemeEnum endPointScheme = endPoint.getEndpointTypeDetails().getName();
        String providerEndpointUri = null;
        switch (endPointScheme) {
            case ftp: {
                StringBuilder filePath = new StringBuilder("/");
                if (endPoint.getFolder() != null) {
                    filePath.append(endPoint.getFolder());
                }
                providerEndpointUri = new URI(endPointScheme.name(), endPoint.getUserName(), endPoint.getServerIp(), (int)endPoint.getPort(), filePath.toString(), this.getOptionsForEndpoint(endPoint).toString(), null).toString();
                break;
            }
            case file: {
                providerEndpointUri = new URI(endPointScheme.name(), null, endPoint.getFolder(), -1, null, this.getOptionsForEndpoint(endPoint), null).toString();
                break;
            }
            default: {
                throw new Exception("Endpoint of type - " + endPointScheme + " not supported");
            }
        }
        return providerEndpointUri;
    }

    private String getOptionsForEndpoint(com.ericsson.cms.epgmgmt.entity.Endpoint endPoint) {
        ArrayList<String> options = new ArrayList<String>(3);
        if (endPoint.getFileName() != null) {
            options.add("fileName=" + endPoint.getFileName());
        }
        if (endPoint.getEndpointTypeDetails().getName().equals((Object)EndpointSchemeEnum.ftp)) {
            options.add("maximumReconnectAttempts=0");
            options.add("disconnect=true");
            options.add("separator=UNIX");
            if (endPoint.getPassword() != null) {
                options.add("password=" + endPoint.getPassword());
            }
        }
        StringBuilder uriOptions = new StringBuilder();
        if (options.size() > 0) {
            uriOptions.append((String)options.get(0));
            options.remove(0);
        }
        for (String option : options) {
            uriOptions.append("&");
            uriOptions.append(option);
        }
        return uriOptions.toString();
    }

    public static long getPublisherId(Exchange exchange) {
        return (Long)exchange.getIn().getHeader(PUBLISHER_ID);
    }
}

