/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarUtil {
    public static String DATEFORMAT = "dd-MMM-yy hh.mm.ss.SSS aa z";

    private static Date timeTravel(int days) {
        Calendar now = Calendar.getInstance();
        now.add(5, days);
        return now.getTime();
    }

    public static Date daysInFuture(int days) {
        return CalendarUtil.timeTravel(days);
    }

    public static Date daysInPast(int days) {
        return CalendarUtil.timeTravel(-1 * days);
    }

    public static String getUTCTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATEFORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String utcTime = sdf.format(date);
        return utcTime;
    }

    public static String dayInPastAsUTC(int days) {
        return CalendarUtil.getUTCTime(CalendarUtil.daysInPast(days));
    }

    public static String dayInFutureAsUTC(int days) {
        return CalendarUtil.getUTCTime(CalendarUtil.daysInFuture(days));
    }

    public static void main(String[] args) {
        System.out.println(CalendarUtil.dayInPastAsUTC(0));
    }
}

