/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.util;

import com.ericsson.cms.epgmgmt.entity.Provider;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConfigProperties {
    private static Properties configPropertyFile;
    private static final String CAMEL_PROPERTIES_SETTING = "com.ericsson.cms.epgmgmt.configuration";
    public static final String FTP_TMP_FOLDER = "ftptmpforprovider";
    private static final Log logger;

    public static String getPropertyValue(String key) {
        if (configPropertyFile == null) {
            throw new IllegalStateException(" ConfigProperties not intialized yet");
        }
        return StringUtils.trim((String)configPropertyFile.getProperty(key));
    }

    public static String getPropertyValue(String key, String defaultValue) {
        if (configPropertyFile == null) {
            throw new IllegalStateException(" ConfigProperties not intialized yet");
        }
        return configPropertyFile.getProperty(key, defaultValue);
    }

    public static void init() {
        try {
            if (configPropertyFile != null) {
                logger.info((Object)" configPropertyFile have been inited [UNIT TESTING ?]");
                logger.info((Object)ConfigProperties.getDebugString());
                return;
            }
            configPropertyFile = new Properties();
            Map<String, String> configCamelProperties = new HashMap();
            IConfigurationService configService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
            configCamelProperties = configService.getProperties(CAMEL_PROPERTIES_SETTING);
            if (configCamelProperties == null || configCamelProperties.size() == 0) {
                logger.error((Object)"Cannot Load setting for EPG by com.ericsson.cms.epgmgmt.configuration,it mabye caused by wrong setting or License file. ");
                logger.info((Object)("debug:\n" + configService.getAllSettingDefinitionsAsJSON()));
            } else {
                logger.info((Object)("Load setting for EPG:\n" + ConfigProperties.getDebugString()));
                ConfigProperties.setConfigPropertyFile(configCamelProperties);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in retrieving EPG manager properties", (Throwable)e);
            throw new IllegalStateException("Error in retrieving EPG manager properties");
        }
    }

    public static Properties getConfigPropertyFile() {
        return configPropertyFile;
    }

    public static void setConfigPropertyFile(Properties configPropertyFile) {
        ConfigProperties.configPropertyFile = configPropertyFile;
    }

    public static String getWorkFolderForProvider(Provider p) {
        return ConfigProperties.getPropertyValue("workfolder", "/tmp") + File.separator + p.getId();
    }

    public static String getFtpTempFolderForProvider() {
        String tempFolder = ConfigProperties.getPropertyValue("workfolder");
        if (tempFolder == null) {
            logger.error((Object)"Temp folder not specified for FTP consumer. This will cause reading the whole input file in memory!");
            return null;
        }
        return tempFolder + File.separator + FTP_TMP_FOLDER;
    }

    public static String getFtpTempFolderFromDatabase() {
        return ConfigProperties.getPropertyValue("workfolder") + System.getProperty("file.separator") + "ftpfromdatabase";
    }

    private static void setConfigPropertyFile(Map<String, String> camelMapProps) {
        for (Map.Entry<String, String> properties : camelMapProps.entrySet()) {
            configPropertyFile.setProperty(properties.getKey(), properties.getValue());
        }
    }

    public static String getDebugString() {
        if (ConfigProperties.getConfigPropertyFile() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(200);
        for (Map.Entry<Object, Object> entry : ConfigProperties.getConfigPropertyFile().entrySet()) {
            sb.append("\t[" + entry.getKey() + "] " + entry.getValue() + "\n");
        }
        return sb.toString();
    }

    public static String getExportedETVFileName() {
        return ConfigProperties.getFtpTempFolderFromDatabase() + System.getProperty("file.separator") + "GuideDataOut.xml";
    }

    static {
        logger = LogFactory.getLog(ConfigProperties.class);
    }
}

